/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.ConfirmPickingAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.ConfirmPickingOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.PickAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.PickOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.PostGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.ReverseGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.SerialNmbrDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.batch.DefaultOutboundDeliveryServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete outbound deliveries. It can be consumed in Fiori apps and
 * on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b1/b123d381bb4ad6b9cbaafaaa87aa24/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_OUTBOUND_DELIVERY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_OUTBOUND_DELIVERY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Outbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the
 *             <a href="https://api.sap.com/api/API_OUTBOUND_DELIVERY_SRV_0002"> successor API</a> instead.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultOutboundDeliveryService" )
@Deprecated
public class DefaultOutboundDeliveryService implements OutboundDeliveryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link OutboundDeliveryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultOutboundDeliveryService()
    {
        servicePath = OutboundDeliveryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultOutboundDeliveryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultOutboundDeliveryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultOutboundDeliveryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultOutboundDeliveryServiceBatch batch()
    {
        return new DefaultOutboundDeliveryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public OutbDeliveryItemFluentHelper getAllOutbDeliveryItem()
    {
        return new OutbDeliveryItemFluentHelper(servicePath, "A_OutbDeliveryItem");
    }

    @Override
    @Nonnull
    public
        OutbDeliveryItemByKeyFluentHelper
        getOutbDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem )
    {
        return new OutbDeliveryItemByKeyFluentHelper(
            servicePath,
            "A_OutbDeliveryItem",
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public OutbDeliveryItemUpdateFluentHelper updateOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return new OutbDeliveryItemUpdateFluentHelper(servicePath, outbDeliveryItem, "A_OutbDeliveryItem");
    }

    @Override
    @Nonnull
    public OutbDeliveryItemDeleteFluentHelper deleteOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return new OutbDeliveryItemDeleteFluentHelper(servicePath, outbDeliveryItem, "A_OutbDeliveryItem");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderFluentHelper getAllOutbDeliveryHeader()
    {
        return new OutbDeliveryHeaderFluentHelper(servicePath, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderByKeyFluentHelper getOutbDeliveryHeaderByKey( final String deliveryDocument )
    {
        return new OutbDeliveryHeaderByKeyFluentHelper(servicePath, "A_OutbDeliveryHeader", deliveryDocument);
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderCreateFluentHelper createOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return new OutbDeliveryHeaderCreateFluentHelper(servicePath, outbDeliveryHeader, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderUpdateFluentHelper updateOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return new OutbDeliveryHeaderUpdateFluentHelper(servicePath, outbDeliveryHeader, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderDeleteFluentHelper deleteOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return new OutbDeliveryHeaderDeleteFluentHelper(servicePath, outbDeliveryHeader, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryDocFlowByKeyFluentHelper getOutbDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory )
    {
        return new OutbDeliveryDocFlowByKeyFluentHelper(
            servicePath,
            "A_OutbDeliveryDocFlow",
            precedingDocument,
            precedingDocumentItem,
            subsequentDocumentCategory);
    }

    @Override
    @Nonnull
    public OutbDeliveryDocFlowUpdateFluentHelper updateOutbDeliveryDocFlow(
        @Nonnull final OutbDeliveryDocFlow outbDeliveryDocFlow )
    {
        return new OutbDeliveryDocFlowUpdateFluentHelper(servicePath, outbDeliveryDocFlow, "A_OutbDeliveryDocFlow");
    }

    @Override
    @Nonnull
    public SerialNmbrDeliveryByKeyFluentHelper getSerialNmbrDeliveryByKey( final Integer maintenanceItemObjectList )
    {
        return new SerialNmbrDeliveryByKeyFluentHelper(servicePath, "A_SerialNmbrDelivery", maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    public
        OutbDeliveryPartnerByKeyFluentHelper
        getOutbDeliveryPartnerByKey( final String partnerFunction, final String sDDocument )
    {
        return new OutbDeliveryPartnerByKeyFluentHelper(
            servicePath,
            "A_OutbDeliveryPartner",
            partnerFunction,
            sDDocument);
    }

    @Override
    @Nonnull
    public PostGoodsIssueFluentHelper postGoodsIssue( @Nonnull final String deliveryDocument )
    {
        return new PostGoodsIssueFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public ReverseGoodsIssueFluentHelper reverseGoodsIssue(
        @Nonnull final String deliveryDocument,
        @Nonnull final LocalDateTime actualGoodsMovementDate )
    {
        return new ReverseGoodsIssueFluentHelper(servicePath, deliveryDocument, actualGoodsMovementDate);
    }

    @Override
    @Nonnull
    public ConfirmPickingAllItemsFluentHelper confirmPickingAllItems( @Nonnull final String deliveryDocument )
    {
        return new ConfirmPickingAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        ConfirmPickingOneItemFluentHelper
        confirmPickingOneItem( @Nonnull final String deliveryDocumentItem, @Nonnull final String deliveryDocument )
    {
        return new ConfirmPickingOneItemFluentHelper(servicePath, deliveryDocumentItem, deliveryDocument);
    }

    @Override
    @Nonnull
    public PickAllItemsFluentHelper pickAllItems( @Nonnull final String deliveryDocument )
    {
        return new PickAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        PickOneItemFluentHelper
        pickOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new PickOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

}
