/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.AddSerialNumberToDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.AssignHandlingUnitToDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.ConfirmPickingAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.ConfirmPickingOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.CreateBatchSplitItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.DeleteAllHandlingUnitsFromDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.DeleteAllSerialNumbersFromDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.DeleteSerialNumberFromDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDeliveryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDeliveryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.PickAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.PickAndBatchSplitOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.PickOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.PickOneItemWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.PickOneItemWithSalesQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.PostGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.ReverseGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.SerialNmbrDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.SetPickingQuantityWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.batch.DefaultOutboundDeliveryV2ServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete outbound deliveries. It can be consumed in Fiori apps and
 * on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4b/ec9116ac56435ca1332e4a75998d51/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_OUTBOUND_DELIVERY_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_OUTBOUND_DELIVERY_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106), Delivery Insights Replication App Integration
 * (Obsolete)(SAP_COM_0571), Excise Tax EMCS Integration(SAP_COM_0634)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4IH'>Delivery Insights Enabled by IoT(4IH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4O0'>Electronic Movement Control System(4O0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Outbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultOutboundDeliveryV2Service" )
@Deprecated
public class DefaultOutboundDeliveryV2Service implements OutboundDeliveryV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link OutboundDeliveryV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultOutboundDeliveryV2Service()
    {
        servicePath = OutboundDeliveryV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultOutboundDeliveryV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultOutboundDeliveryV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultOutboundDeliveryV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultOutboundDeliveryV2ServiceBatch batch()
    {
        return new DefaultOutboundDeliveryV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public OutbDeliveryItemTextCreateFluentHelper createOutbDeliveryItemText(
        @Nonnull final OutbDeliveryItemText outbDeliveryItemText )
    {
        return new OutbDeliveryItemTextCreateFluentHelper(servicePath, outbDeliveryItemText, "A_OutbDeliveryItemText");
    }

    @Override
    @Nonnull
    public OutbDeliveryItemTextUpdateFluentHelper updateOutbDeliveryItemText(
        @Nonnull final OutbDeliveryItemText outbDeliveryItemText )
    {
        return new OutbDeliveryItemTextUpdateFluentHelper(servicePath, outbDeliveryItemText, "A_OutbDeliveryItemText");
    }

    @Override
    @Nonnull
    public OutbDeliveryItemTextDeleteFluentHelper deleteOutbDeliveryItemText(
        @Nonnull final OutbDeliveryItemText outbDeliveryItemText )
    {
        return new OutbDeliveryItemTextDeleteFluentHelper(servicePath, outbDeliveryItemText, "A_OutbDeliveryItemText");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderTextCreateFluentHelper createOutbDeliveryHeaderText(
        @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText )
    {
        return new OutbDeliveryHeaderTextCreateFluentHelper(
            servicePath,
            outbDeliveryHeaderText,
            "A_OutbDeliveryHeaderText");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderTextUpdateFluentHelper updateOutbDeliveryHeaderText(
        @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText )
    {
        return new OutbDeliveryHeaderTextUpdateFluentHelper(
            servicePath,
            outbDeliveryHeaderText,
            "A_OutbDeliveryHeaderText");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderTextDeleteFluentHelper deleteOutbDeliveryHeaderText(
        @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText )
    {
        return new OutbDeliveryHeaderTextDeleteFluentHelper(
            servicePath,
            outbDeliveryHeaderText,
            "A_OutbDeliveryHeaderText");
    }

    @Override
    @Nonnull
    public HandlingUnitHeaderDeliveryByKeyFluentHelper getHandlingUnitHeaderDeliveryByKey(
        final String handlingUnitInternalId )
    {
        return new HandlingUnitHeaderDeliveryByKeyFluentHelper(
            servicePath,
            "A_HandlingUnitHeaderDelivery",
            handlingUnitInternalId);
    }

    @Override
    @Nonnull
    public HandlingUnitHeaderDeliveryCreateFluentHelper createHandlingUnitHeaderDelivery(
        @Nonnull final HandlingUnitHeaderDelivery handlingUnitHeaderDelivery )
    {
        return new HandlingUnitHeaderDeliveryCreateFluentHelper(
            servicePath,
            handlingUnitHeaderDelivery,
            "A_HandlingUnitHeaderDelivery");
    }

    @Override
    @Nonnull
    public HandlingUnitItemDeliveryCreateFluentHelper createHandlingUnitItemDelivery(
        @Nonnull final HandlingUnitItemDelivery handlingUnitItemDelivery )
    {
        return new HandlingUnitItemDeliveryCreateFluentHelper(
            servicePath,
            handlingUnitItemDelivery,
            "A_HandlingUnitItemDelivery");
    }

    @Override
    @Nonnull
    public OutbDeliveryAddress2FluentHelper getAllOutbDeliveryAddress2()
    {
        return new OutbDeliveryAddress2FluentHelper(servicePath, "A_OutbDeliveryAddress2");
    }

    @Override
    @Nonnull
    public
        OutbDeliveryAddress2ByKeyFluentHelper
        getOutbDeliveryAddress2ByKey( final String deliveryDocument, final String partnerFunction )
    {
        return new OutbDeliveryAddress2ByKeyFluentHelper(
            servicePath,
            "A_OutbDeliveryAddress2",
            deliveryDocument,
            partnerFunction);
    }

    @Override
    @Nonnull
    public OutbDeliveryAddress2UpdateFluentHelper updateOutbDeliveryAddress2(
        @Nonnull final OutbDeliveryAddress2 outbDeliveryAddress2 )
    {
        return new OutbDeliveryAddress2UpdateFluentHelper(servicePath, outbDeliveryAddress2, "A_OutbDeliveryAddress2");
    }

    @Override
    @Nonnull
    public OutbDeliveryItemFluentHelper getAllOutbDeliveryItem()
    {
        return new OutbDeliveryItemFluentHelper(servicePath, "A_OutbDeliveryItem");
    }

    @Override
    @Nonnull
    public
        OutbDeliveryItemByKeyFluentHelper
        getOutbDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem )
    {
        return new OutbDeliveryItemByKeyFluentHelper(
            servicePath,
            "A_OutbDeliveryItem",
            deliveryDocument,
            deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public OutbDeliveryItemCreateFluentHelper createOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return new OutbDeliveryItemCreateFluentHelper(servicePath, outbDeliveryItem, "A_OutbDeliveryItem");
    }

    @Override
    @Nonnull
    public OutbDeliveryItemUpdateFluentHelper updateOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return new OutbDeliveryItemUpdateFluentHelper(servicePath, outbDeliveryItem, "A_OutbDeliveryItem");
    }

    @Override
    @Nonnull
    public OutbDeliveryItemDeleteFluentHelper deleteOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return new OutbDeliveryItemDeleteFluentHelper(servicePath, outbDeliveryItem, "A_OutbDeliveryItem");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderFluentHelper getAllOutbDeliveryHeader()
    {
        return new OutbDeliveryHeaderFluentHelper(servicePath, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderByKeyFluentHelper getOutbDeliveryHeaderByKey( final String deliveryDocument )
    {
        return new OutbDeliveryHeaderByKeyFluentHelper(servicePath, "A_OutbDeliveryHeader", deliveryDocument);
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderCreateFluentHelper createOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return new OutbDeliveryHeaderCreateFluentHelper(servicePath, outbDeliveryHeader, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderUpdateFluentHelper updateOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return new OutbDeliveryHeaderUpdateFluentHelper(servicePath, outbDeliveryHeader, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryHeaderDeleteFluentHelper deleteOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return new OutbDeliveryHeaderDeleteFluentHelper(servicePath, outbDeliveryHeader, "A_OutbDeliveryHeader");
    }

    @Override
    @Nonnull
    public OutbDeliveryDocFlowByKeyFluentHelper getOutbDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory )
    {
        return new OutbDeliveryDocFlowByKeyFluentHelper(
            servicePath,
            "A_OutbDeliveryDocFlow",
            precedingDocument,
            precedingDocumentItem,
            subsequentDocumentCategory);
    }

    @Override
    @Nonnull
    public OutbDeliveryDocFlowUpdateFluentHelper updateOutbDeliveryDocFlow(
        @Nonnull final OutbDeliveryDocFlow outbDeliveryDocFlow )
    {
        return new OutbDeliveryDocFlowUpdateFluentHelper(servicePath, outbDeliveryDocFlow, "A_OutbDeliveryDocFlow");
    }

    @Override
    @Nonnull
    public SerialNmbrDeliveryByKeyFluentHelper getSerialNmbrDeliveryByKey( final Long maintenanceItemObjectList )
    {
        return new SerialNmbrDeliveryByKeyFluentHelper(servicePath, "A_SerialNmbrDelivery", maintenanceItemObjectList);
    }

    @Override
    @Nonnull
    public
        OutbDeliveryPartnerByKeyFluentHelper
        getOutbDeliveryPartnerByKey( final String partnerFunction, final String sDDocument )
    {
        return new OutbDeliveryPartnerByKeyFluentHelper(
            servicePath,
            "A_OutbDeliveryPartner",
            partnerFunction,
            sDDocument);
    }

    @Override
    @Nonnull
    public DeleteAllHandlingUnitsFromDeliveryFluentHelper deleteAllHandlingUnitsFromDelivery(
        @Nonnull final String deliveryDocument )
    {
        return new DeleteAllHandlingUnitsFromDeliveryFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public CreateBatchSplitItemFluentHelper createBatchSplitItem(
        @Nonnull final String deliveryQuantityUnit,
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument,
        @Nonnull final String batch,
        @Nullable final BigDecimal pickQuantityInSalesUOM )
    {
        return new CreateBatchSplitItemFluentHelper(
            servicePath,
            deliveryQuantityUnit,
            actualDeliveryQuantity,
            deliveryDocumentItem,
            deliveryDocument,
            batch,
            pickQuantityInSalesUOM);
    }

    @Override
    @Nonnull
    public PickAndBatchSplitOneItemFluentHelper pickAndBatchSplitOneItem(
        @Nonnull final String splitQuantityUnit,
        @Nonnull final BigDecimal splitQuantity,
        @Nonnull final String batch,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument )
    {
        return new PickAndBatchSplitOneItemFluentHelper(
            servicePath,
            splitQuantityUnit,
            splitQuantity,
            batch,
            deliveryDocumentItem,
            deliveryDocument);
    }

    @Override
    @Nonnull
    public AssignHandlingUnitToDeliveryFluentHelper assignHandlingUnitToDelivery(
        @Nonnull final String deliveryDocument,
        @Nonnull final String handlingUnitExternalId )
    {
        return new AssignHandlingUnitToDeliveryFluentHelper(servicePath, deliveryDocument, handlingUnitExternalId);
    }

    @Override
    @Nonnull
    public SetPickingQuantityWithBaseQuantityFluentHelper setPickingQuantityWithBaseQuantity(
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument,
        @Nonnull final String baseUnit,
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit )
    {
        return new SetPickingQuantityWithBaseQuantityFluentHelper(
            servicePath,
            deliveryDocumentItem,
            deliveryDocument,
            baseUnit,
            actualDeliveredQtyInBaseUnit);
    }

    @Override
    @Nonnull
    public AddSerialNumberToDeliveryItemFluentHelper addSerialNumberToDeliveryItem(
        @Nonnull final String serialNumber,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument )
    {
        return new AddSerialNumberToDeliveryItemFluentHelper(
            servicePath,
            serialNumber,
            deliveryDocumentItem,
            deliveryDocument);
    }

    @Override
    @Nonnull
    public DeleteSerialNumberFromDeliveryItemFluentHelper deleteSerialNumberFromDeliveryItem(
        @Nonnull final String serialNumber,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument )
    {
        return new DeleteSerialNumberFromDeliveryItemFluentHelper(
            servicePath,
            serialNumber,
            deliveryDocumentItem,
            deliveryDocument);
    }

    @Override
    @Nonnull
    public DeleteAllSerialNumbersFromDeliveryItemFluentHelper deleteAllSerialNumbersFromDeliveryItem(
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument )
    {
        return new DeleteAllSerialNumbersFromDeliveryItemFluentHelper(
            servicePath,
            deliveryDocumentItem,
            deliveryDocument);
    }

    @Override
    @Nonnull
    public PostGoodsIssueFluentHelper postGoodsIssue( @Nonnull final String deliveryDocument )
    {
        return new PostGoodsIssueFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public ReverseGoodsIssueFluentHelper reverseGoodsIssue(
        @Nonnull final LocalDateTime actualGoodsMovementDate,
        @Nonnull final String deliveryDocument )
    {
        return new ReverseGoodsIssueFluentHelper(servicePath, actualGoodsMovementDate, deliveryDocument);
    }

    @Override
    @Nonnull
    public ConfirmPickingAllItemsFluentHelper confirmPickingAllItems( @Nonnull final String deliveryDocument )
    {
        return new ConfirmPickingAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        ConfirmPickingOneItemFluentHelper
        confirmPickingOneItem( @Nonnull final String deliveryDocument, @Nonnull final String deliveryDocumentItem )
    {
        return new ConfirmPickingOneItemFluentHelper(servicePath, deliveryDocument, deliveryDocumentItem);
    }

    @Override
    @Nonnull
    public PickAllItemsFluentHelper pickAllItems( @Nonnull final String deliveryDocument )
    {
        return new PickAllItemsFluentHelper(servicePath, deliveryDocument);
    }

    @Override
    @Nonnull
    public
        PickOneItemFluentHelper
        pickOneItem( @Nonnull final String deliveryDocumentItem, @Nonnull final String deliveryDocument )
    {
        return new PickOneItemFluentHelper(servicePath, deliveryDocumentItem, deliveryDocument);
    }

    @Override
    @Nonnull
    public PickOneItemWithSalesQuantityFluentHelper pickOneItemWithSalesQuantity(
        @Nonnull final String deliveryQuantityUnit,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument,
        @Nonnull final BigDecimal actualDeliveryQuantity )
    {
        return new PickOneItemWithSalesQuantityFluentHelper(
            servicePath,
            deliveryQuantityUnit,
            deliveryDocumentItem,
            deliveryDocument,
            actualDeliveryQuantity);
    }

    @Override
    @Nonnull
    public PickOneItemWithBaseQuantityFluentHelper pickOneItemWithBaseQuantity(
        @Nonnull final String baseUnit,
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument )
    {
        return new PickOneItemWithBaseQuantityFluentHelper(
            servicePath,
            baseUnit,
            actualDeliveredQtyInBaseUnit,
            deliveryDocumentItem,
            deliveryDocument);
    }

}
