/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.batch.DefaultPackingInstructionServiceBatch;

/**
 * <p>
 * Packing instructions serve as templates for the creation of handling units.
 *
 * With this API, you can carry out the following operations: - Create a packing instruction comprising packaging
 * material and material to be packed. - Create a packing instruction including packaging material and reference
 * material. The reference material enables you to reuse one packing instruction for several materials. - Create a
 * packing instruction including subordinated packing instructions (multi-level packing instructions). - Retrieve header
 * information for a packing instruction. You can use filter criteria to retrieve information based on other selection
 * criteria, for example, material numbers. - Retrieve component information for a packing instruction, which contains
 * information about the packaging material and the material to be packed in the handling unit. - Retrieve texts in
 * different languages for a packing instruction.
 *
 * Note
 *
 * The following operations are available on the ***API Reference*** tab but are not supported by the API: -
 * &lt;TT&gt;POST
 * /PackingInstructionHeader(guid&#39;{PackingInstructionSystemUUID}&#39;)/to_PackingInstructionComponent&lt;/TT&gt; -
 * &lt;TT&gt;POST
 * /PackingInstructionHeader(guid&#39;{PackingInstructionSystemUUID}&#39;)/to_PackingInstructionText&lt;/TT&gt; .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8c/64ea338f6a4c68b40f8dbcafde8954/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PACKINGINSTRUCTION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PACKINGINSTRUCTION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Packing Instruction Integration(SAP_COM_0399)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4MM'>Handling Unit Management(4MM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Packing Instruction</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPackingInstructionService" )
@Deprecated
public class DefaultPackingInstructionService implements PackingInstructionService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PackingInstructionService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPackingInstructionService()
    {
        servicePath = PackingInstructionService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPackingInstructionService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPackingInstructionService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPackingInstructionService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPackingInstructionServiceBatch batch()
    {
        return new DefaultPackingInstructionServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PackingInstructionComponentFluentHelper getAllPackingInstructionComponent()
    {
        return new PackingInstructionComponentFluentHelper(servicePath, "PackingInstructionComponent");
    }

    @Override
    @Nonnull
    public PackingInstructionComponentByKeyFluentHelper getPackingInstructionComponentByKey(
        final UUID packingInstructionItemSystUUID )
    {
        return new PackingInstructionComponentByKeyFluentHelper(
            servicePath,
            "PackingInstructionComponent",
            packingInstructionItemSystUUID);
    }

    @Override
    @Nonnull
    public PackingInstructionHeaderFluentHelper getAllPackingInstructionHeader()
    {
        return new PackingInstructionHeaderFluentHelper(servicePath, "PackingInstructionHeader");
    }

    @Override
    @Nonnull
    public PackingInstructionHeaderByKeyFluentHelper getPackingInstructionHeaderByKey(
        final UUID packingInstructionSystemUUID )
    {
        return new PackingInstructionHeaderByKeyFluentHelper(
            servicePath,
            "PackingInstructionHeader",
            packingInstructionSystemUUID);
    }

    @Override
    @Nonnull
    public PackingInstructionHeaderCreateFluentHelper createPackingInstructionHeader(
        @Nonnull final PackingInstructionHeader packingInstructionHeader )
    {
        return new PackingInstructionHeaderCreateFluentHelper(
            servicePath,
            packingInstructionHeader,
            "PackingInstructionHeader");
    }

    @Override
    @Nonnull
    public PackingInstructionTextFluentHelper getAllPackingInstructionText()
    {
        return new PackingInstructionTextFluentHelper(servicePath, "PackingInstructionText");
    }

    @Override
    @Nonnull
    public
        PackingInstructionTextByKeyFluentHelper
        getPackingInstructionTextByKey( final String language, final UUID packingInstructionSystemUUID )
    {
        return new PackingInstructionTextByKeyFluentHelper(
            servicePath,
            "PackingInstructionText",
            language,
            packingInstructionSystemUUID);
    }

}
