/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.batch.DefaultPaymentAdviceServiceBatch;

/**
 * <p>
 *
 * You can use this inbound synchronous service to create, read, update, and delete payment advices related to a
 * customer or a supplier. It is based on the OData protocol and can be consumed in SAP Fiori apps and other user
 * interfaces. The service can be used with payment advices of any supported type..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f8/f29bb9d08a418d936ce5de8a78b33f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PAYMENT_ADVICE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PAYMENT_ADVICE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Payment Advice Integration(SAP_COM_0331)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J59'>Accounts Receivable(J59)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O59'>Accounts Receivable(O59)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Payment Advice</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPaymentAdviceService" )
@Deprecated
public class DefaultPaymentAdviceService implements PaymentAdviceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PaymentAdviceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPaymentAdviceService()
    {
        servicePath = PaymentAdviceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPaymentAdviceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPaymentAdviceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPaymentAdviceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPaymentAdviceServiceBatch batch()
    {
        return new DefaultPaymentAdviceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PaymentAdviceFluentHelper getAllPaymentAdvice()
    {
        return new PaymentAdviceFluentHelper(servicePath, "A_PaymentAdvice");
    }

    @Override
    @Nonnull
    public PaymentAdviceByKeyFluentHelper getPaymentAdviceByKey(
        final String companyCode,
        final String paymentAdviceAccountType,
        final String paymentAdviceAccount,
        final String paymentAdvice )
    {
        return new PaymentAdviceByKeyFluentHelper(
            servicePath,
            "A_PaymentAdvice",
            companyCode,
            paymentAdviceAccountType,
            paymentAdviceAccount,
            paymentAdvice);
    }

    @Override
    @Nonnull
    public PaymentAdviceCreateFluentHelper createPaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice )
    {
        return new PaymentAdviceCreateFluentHelper(servicePath, paymentAdvice, "A_PaymentAdvice");
    }

    @Override
    @Nonnull
    public PaymentAdviceUpdateFluentHelper updatePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice )
    {
        return new PaymentAdviceUpdateFluentHelper(servicePath, paymentAdvice, "A_PaymentAdvice");
    }

    @Override
    @Nonnull
    public PaymentAdviceDeleteFluentHelper deletePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice )
    {
        return new PaymentAdviceDeleteFluentHelper(servicePath, paymentAdvice, "A_PaymentAdvice");
    }

    @Override
    @Nonnull
    public PaymentAdviceItemFluentHelper getAllPaymentAdviceItem()
    {
        return new PaymentAdviceItemFluentHelper(servicePath, "A_PaymentAdviceItem");
    }

    @Override
    @Nonnull
    public PaymentAdviceItemByKeyFluentHelper getPaymentAdviceItemByKey(
        final String companyCode,
        final String paymentAdviceAccountType,
        final String paymentAdviceAccount,
        final String paymentAdvice,
        final String paymentAdviceItem )
    {
        return new PaymentAdviceItemByKeyFluentHelper(
            servicePath,
            "A_PaymentAdviceItem",
            companyCode,
            paymentAdviceAccountType,
            paymentAdviceAccount,
            paymentAdvice,
            paymentAdviceItem);
    }

    @Override
    @Nonnull
    public PaymentAdviceItemCreateFluentHelper createPaymentAdviceItem(
        @Nonnull final PaymentAdviceItem paymentAdviceItem )
    {
        return new PaymentAdviceItemCreateFluentHelper(servicePath, paymentAdviceItem, "A_PaymentAdviceItem");
    }

    @Override
    @Nonnull
    public PaymentAdviceItemUpdateFluentHelper updatePaymentAdviceItem(
        @Nonnull final PaymentAdviceItem paymentAdviceItem )
    {
        return new PaymentAdviceItemUpdateFluentHelper(servicePath, paymentAdviceItem, "A_PaymentAdviceItem");
    }

    @Override
    @Nonnull
    public PaymentAdviceItemDeleteFluentHelper deletePaymentAdviceItem(
        @Nonnull final PaymentAdviceItem paymentAdviceItem )
    {
        return new PaymentAdviceItemDeleteFluentHelper(servicePath, paymentAdviceItem, "A_PaymentAdviceItem");
    }

}
