/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.batch.DefaultPaymentItemServiceBatch;

/**
 * <p>
 *
 * This service contains payment header and payment item. The payment header is read by groups, and in each group, there
 * are one or more payment items. Appropriate checks for restricted values and authorizations are executed for updating
 * the approval status of payment items. Once the update has been completed, the status code is sent in the response. If
 * there are any issues during updating the approval status of payment item, the system display error messages in the
 * response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/cf/a122d11c1e4393b24bee18c7feb983/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CN_PAYMENTRELEASELIST_APPR_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CN_PAYMENTRELEASELIST_APPR_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - China Payment Approval Integration(SAP_COM_0711)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J60'>Accounts Payable(J60)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Payment Medium</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPaymentItemService" )
@Deprecated
public class DefaultPaymentItemService implements PaymentItemService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PaymentItemService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPaymentItemService()
    {
        servicePath = PaymentItemService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPaymentItemService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPaymentItemService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPaymentItemService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPaymentItemServiceBatch batch()
    {
        return new DefaultPaymentItemServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PaymentReleaseListHeaderFluentHelper getAllPaymentReleaseListHeader()
    {
        return new PaymentReleaseListHeaderFluentHelper(servicePath, "PaymentReleaseListHeaderSet");
    }

    @Override
    @Nonnull
    public PaymentReleaseListHeaderByKeyFluentHelper getPaymentReleaseListHeaderByKey( final String paymentreleaselist )
    {
        return new PaymentReleaseListHeaderByKeyFluentHelper(
            servicePath,
            "PaymentReleaseListHeaderSet",
            paymentreleaselist);
    }

    @Override
    @Nonnull
    public PaymentReleaseListItemFluentHelper getAllPaymentReleaseListItem()
    {
        return new PaymentReleaseListItemFluentHelper(servicePath, "PaymentReleaseListItemSet");
    }

    @Override
    @Nonnull
    public PaymentReleaseListItemByKeyFluentHelper getPaymentReleaseListItemByKey(
        final UUID paymentreleaselistitemuuid )
    {
        return new PaymentReleaseListItemByKeyFluentHelper(
            servicePath,
            "PaymentReleaseListItemSet",
            paymentreleaselistitemuuid);
    }

    @Override
    @Nonnull
    public PaymentReleaseListItemUpdateFluentHelper updatePaymentReleaseListItem(
        @Nonnull final PaymentReleaseListItem paymentReleaseListItem )
    {
        return new PaymentReleaseListItemUpdateFluentHelper(
            servicePath,
            paymentReleaseListItem,
            "PaymentReleaseListItemSet");
    }

}
