/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.batch.DefaultPersonnelSettlementDocumentServiceBatch;

/**
 * <p>
 *
 * The service enables you to read the transactional data of personnel settlement documents.
 *
 * It is based on the OData protocol and it is intended for consumption in background by remote interfaces for
 * application integration scenarios.
 *
 * In every API call, you can make use of the following operations: - You can retrieve an individual personnel
 * settlement document by document number - You can retrieve multiple documents by filtering on the available properties
 * - You can request additional information on the assignment of settled amounts to cost centers - You can retrieve
 * delta information by filtering on date and time to only get documents which have been created after that point in
 * time.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f1/96aa7b945547b99f58896ee3d3f8d4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PERS_SETTLMT_DOC?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PERS_SETTLMT_DOC</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Employee Central Personnel Settlement Document Integration(SAP_COM_0469)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3TD'>Internal Commissions Settlement with SAP Sales
 * Cloud(3TD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Personnel Settlement Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPersonnelSettlementDocumentService" )
@Deprecated
public class DefaultPersonnelSettlementDocumentService implements PersonnelSettlementDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PersonnelSettlementDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPersonnelSettlementDocumentService()
    {
        servicePath = PersonnelSettlementDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPersonnelSettlementDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPersonnelSettlementDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPersonnelSettlementDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPersonnelSettlementDocumentServiceBatch batch()
    {
        return new DefaultPersonnelSettlementDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PersCompnElmntCostAssgmtFluentHelper getAllPersCompnElmntCostAssgmt()
    {
        return new PersCompnElmntCostAssgmtFluentHelper(servicePath, "PersCompnElmntCostAssgmt");
    }

    @Override
    @Nonnull
    public PersCompnElmntCostAssgmtByKeyFluentHelper getPersCompnElmntCostAssgmtByKey(
        final String personnelSettlementDocument,
        final String controllingArea,
        final String costCenter )
    {
        return new PersCompnElmntCostAssgmtByKeyFluentHelper(
            servicePath,
            "PersCompnElmntCostAssgmt",
            personnelSettlementDocument,
            controllingArea,
            costCenter);
    }

    @Override
    @Nonnull
    public PersonnelCompensationElementFluentHelper getAllPersonnelCompensationElement()
    {
        return new PersonnelCompensationElementFluentHelper(servicePath, "PersonnelCompensationElement");
    }

    @Override
    @Nonnull
    public PersonnelCompensationElementByKeyFluentHelper getPersonnelCompensationElementByKey(
        final String personnelSettlementDocument )
    {
        return new PersonnelCompensationElementByKeyFluentHelper(
            servicePath,
            "PersonnelCompensationElement",
            personnelSettlementDocument);
    }

}
