/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.batch.DefaultPhaseRelationshipTypeServiceBatch;

/**
 * <p>
 *
 * Relationships link the start or end of a preceding phase with the start or end of a succeeding phase. The
 * relationship type specifies how the phase dates are linked with each other. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/3e/f14e1f076343a4ae9af4692d2633fa/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_MSTRRCPPHSE_RELSHPTYPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_MSTRRCPPHSE_RELSHPTYPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Master Data Integration(SAP_COM_0519)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Master Recipe</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPhaseRelationshipTypeService" )
@Deprecated
public class DefaultPhaseRelationshipTypeService implements PhaseRelationshipTypeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PhaseRelationshipTypeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPhaseRelationshipTypeService()
    {
        servicePath = PhaseRelationshipTypeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPhaseRelationshipTypeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPhaseRelationshipTypeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPhaseRelationshipTypeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPhaseRelationshipTypeServiceBatch batch()
    {
        return new DefaultPhaseRelationshipTypeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PhaseRelationshipTypeFluentHelper getAllPhaseRelationshipType()
    {
        return new PhaseRelationshipTypeFluentHelper(servicePath, "PhaseRelationshipType");
    }

    @Override
    @Nonnull
    public PhaseRelationshipTypeByKeyFluentHelper getPhaseRelationshipTypeByKey( final String phaseRelationshipTypeKey )
    {
        return new PhaseRelationshipTypeByKeyFluentHelper(
            servicePath,
            "PhaseRelationshipType",
            phaseRelationshipTypeKey);
    }

    @Override
    @Nonnull
    public PhaseRelationshipTypeTextFluentHelper getAllPhaseRelationshipTypeText()
    {
        return new PhaseRelationshipTypeTextFluentHelper(servicePath, "PhaseRelationshipTypeText");
    }

    @Override
    @Nonnull
    public
        PhaseRelationshipTypeTextByKeyFluentHelper
        getPhaseRelationshipTypeTextByKey( final String language, final String phaseRelationshipTypeKey )
    {
        return new PhaseRelationshipTypeTextByKeyFluentHelper(
            servicePath,
            "PhaseRelationshipTypeText",
            language,
            phaseRelationshipTypeKey);
    }

}
