/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.InitiateRecountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.InitiateRecountOnItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PostDifferencesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PostDifferencesOnItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.batch.DefaultPhysicalInventoryDocumentServiceBatch;

/**
 * <p>
 *
 * You can count items and post differences on both document and item level. The service can be consumed by external
 * systems..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/58/361658745b1f60e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PHYSICAL_INVENTORY_DOC_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PHYSICAL_INVENTORY_DOC_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Physical Inventory Document Integration(SAP_COM_0107)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BML'>Physical Inventory - Inventory Count and Adjustment(BML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OML'>Physical Inventory - Inventory Count and Adjustment(OML)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Physical Inventory Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPhysicalInventoryDocumentService" )
@Deprecated
public class DefaultPhysicalInventoryDocumentService implements PhysicalInventoryDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PhysicalInventoryDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPhysicalInventoryDocumentService()
    {
        servicePath = PhysicalInventoryDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPhysicalInventoryDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPhysicalInventoryDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPhysicalInventoryDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPhysicalInventoryDocumentServiceBatch batch()
    {
        return new DefaultPhysicalInventoryDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PhysInventoryDocHeaderFluentHelper getAllPhysInventoryDocHeader()
    {
        return new PhysInventoryDocHeaderFluentHelper(servicePath, "A_PhysInventoryDocHeader");
    }

    @Override
    @Nonnull
    public
        PhysInventoryDocHeaderByKeyFluentHelper
        getPhysInventoryDocHeaderByKey( final String fiscalYear, final String physicalInventoryDocument )
    {
        return new PhysInventoryDocHeaderByKeyFluentHelper(
            servicePath,
            "A_PhysInventoryDocHeader",
            fiscalYear,
            physicalInventoryDocument);
    }

    @Override
    @Nonnull
    public PhysInventoryDocHeaderCreateFluentHelper createPhysInventoryDocHeader(
        @Nonnull final PhysInventoryDocHeader physInventoryDocHeader )
    {
        return new PhysInventoryDocHeaderCreateFluentHelper(
            servicePath,
            physInventoryDocHeader,
            "A_PhysInventoryDocHeader");
    }

    @Override
    @Nonnull
    public PhysInventoryDocItemFluentHelper getAllPhysInventoryDocItem()
    {
        return new PhysInventoryDocItemFluentHelper(servicePath, "A_PhysInventoryDocItem");
    }

    @Override
    @Nonnull
    public PhysInventoryDocItemByKeyFluentHelper getPhysInventoryDocItemByKey(
        final String fiscalYear,
        final String physicalInventoryDocument,
        final String physicalInventoryDocumentItem )
    {
        return new PhysInventoryDocItemByKeyFluentHelper(
            servicePath,
            "A_PhysInventoryDocItem",
            fiscalYear,
            physicalInventoryDocument,
            physicalInventoryDocumentItem);
    }

    @Override
    @Nonnull
    public PhysInventoryDocItemUpdateFluentHelper updatePhysInventoryDocItem(
        @Nonnull final PhysInventoryDocItem physInventoryDocItem )
    {
        return new PhysInventoryDocItemUpdateFluentHelper(servicePath, physInventoryDocItem, "A_PhysInventoryDocItem");
    }

    @Override
    @Nonnull
    public SerialNumberPhysInventoryDocFluentHelper getAllSerialNumberPhysInventoryDoc()
    {
        return new SerialNumberPhysInventoryDocFluentHelper(servicePath, "A_SerialNumberPhysInventoryDoc");
    }

    @Override
    @Nonnull
    public SerialNumberPhysInventoryDocByKeyFluentHelper getSerialNumberPhysInventoryDocByKey(
        final String equipment,
        final String fiscalYear,
        final String physicalInventoryDocument,
        final String physicalInventoryDocumentItem,
        final String serialNumberPhysicalInvtryType )
    {
        return new SerialNumberPhysInventoryDocByKeyFluentHelper(
            servicePath,
            "A_SerialNumberPhysInventoryDoc",
            equipment,
            fiscalYear,
            physicalInventoryDocument,
            physicalInventoryDocumentItem,
            serialNumberPhysicalInvtryType);
    }

    @Override
    @Nonnull
    public SerialNumberPhysInventoryDocUpdateFluentHelper updateSerialNumberPhysInventoryDoc(
        @Nonnull final SerialNumberPhysInventoryDoc serialNumberPhysInventoryDoc )
    {
        return new SerialNumberPhysInventoryDocUpdateFluentHelper(
            servicePath,
            serialNumberPhysInventoryDoc,
            "A_SerialNumberPhysInventoryDoc");
    }

    @Override
    @Nonnull
    public PostDifferencesFluentHelper postDifferences(
        @Nullable final BigDecimal postingThresholdValue,
        @Nullable final LocalDateTime postingDate,
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear )
    {
        return new PostDifferencesFluentHelper(
            servicePath,
            postingThresholdValue,
            postingDate,
            physicalInventoryDocument,
            fiscalYear);
    }

    @Override
    @Nonnull
    public PostDifferencesOnItemFluentHelper postDifferencesOnItem(
        @Nonnull final String physicalInventoryDocumentItem,
        @Nonnull final String material,
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear,
        @Nullable final String batch,
        @Nullable final String reasonForPhysInvtryDifference,
        @Nullable final LocalDateTime postingDate )
    {
        return new PostDifferencesOnItemFluentHelper(
            servicePath,
            physicalInventoryDocumentItem,
            material,
            physicalInventoryDocument,
            fiscalYear,
            batch,
            reasonForPhysInvtryDifference,
            postingDate);
    }

    @Override
    @Nonnull
    public InitiateRecountFluentHelper initiateRecount(
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear,
        @Nullable final LocalDateTime physInventoryPlannedCountDate,
        @Nullable final LocalDateTime documentDate,
        @Nullable final String physicalInventoryNumber,
        @Nullable final String physInventoryReferenceNumber,
        @Nullable final String physicalInventoryDocumentDesc,
        @Nullable final BigDecimal postingThresholdValue,
        @Nullable final Boolean physInvtryDocHasQtySnapshot,
        @Nullable final Boolean postingIsBlockedForPhysInvtry )
    {
        return new InitiateRecountFluentHelper(
            servicePath,
            physicalInventoryDocument,
            fiscalYear,
            physInventoryPlannedCountDate,
            documentDate,
            physicalInventoryNumber,
            physInventoryReferenceNumber,
            physicalInventoryDocumentDesc,
            postingThresholdValue,
            physInvtryDocHasQtySnapshot,
            postingIsBlockedForPhysInvtry);
    }

    @Override
    @Nonnull
    public InitiateRecountOnItemFluentHelper initiateRecountOnItem(
        @Nonnull final String physicalInventoryDocument,
        @Nonnull final String fiscalYear,
        @Nonnull final String physicalInventoryDocumentItem,
        @Nullable final LocalDateTime physInventoryPlannedCountDate,
        @Nullable final LocalDateTime documentDate,
        @Nullable final String physicalInventoryNumber,
        @Nullable final String physInventoryReferenceNumber,
        @Nullable final String physicalInventoryDocumentDesc,
        @Nullable final Boolean physInvtryDocHasQtySnapshot,
        @Nullable final Boolean postingIsBlockedForPhysInvtry )
    {
        return new InitiateRecountOnItemFluentHelper(
            servicePath,
            physicalInventoryDocument,
            fiscalYear,
            physicalInventoryDocumentItem,
            physInventoryPlannedCountDate,
            documentDate,
            physicalInventoryNumber,
            physInventoryReferenceNumber,
            physicalInventoryDocumentDesc,
            physInvtryDocHasQtySnapshot,
            postingIsBlockedForPhysInvtry);
    }

}
