/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriodUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.batch.DefaultPlannedIndependentRequirementServiceBatch;

/**
 * <p>
 *
 * This API has been deprecated and won&#39;t be available as of SAP S/4HANA Cloud 2102.
 *
 * We recommend that you use the following API:
 *
 * https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PLND_INDEP_RQMT_SRV .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/81/552c58c01b1f60e10000000a44147b/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FORECAST_DEMAND_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FORECAST_DEMAND_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Planned Independent Requirement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2002 (Feb 2020). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPlannedIndependentRequirementService" )
@Deprecated
public class DefaultPlannedIndependentRequirementService implements PlannedIndependentRequirementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PlannedIndependentRequirementService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPlannedIndependentRequirementService()
    {
        servicePath = PlannedIndependentRequirementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPlannedIndependentRequirementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPlannedIndependentRequirementService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPlannedIndependentRequirementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPlannedIndependentRequirementServiceBatch batch()
    {
        return new DefaultPlannedIndependentRequirementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaintainYearsPeriodFluentHelper getAllMaintainYearsPeriod()
    {
        return new MaintainYearsPeriodFluentHelper(servicePath, "MaintainYearsPeriodSet");
    }

    @Override
    @Nonnull
    public MaintainYearsPeriodByKeyFluentHelper getMaintainYearsPeriodByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final String requirementsType,
        final String forecastDemandVersion,
        final LocalDateTime forecastPeriodStartDate )
    {
        return new MaintainYearsPeriodByKeyFluentHelper(
            servicePath,
            "MaintainYearsPeriodSet",
            material,
            plant,
            mRPArea,
            requirementsType,
            forecastDemandVersion,
            forecastPeriodStartDate);
    }

    @Override
    @Nonnull
    public MaintainYearsPeriodUpdateFluentHelper updateMaintainYearsPeriod(
        @Nonnull final MaintainYearsPeriod maintainYearsPeriod )
    {
        return new MaintainYearsPeriodUpdateFluentHelper(servicePath, maintainYearsPeriod, "MaintainYearsPeriodSet");
    }

}
