/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderScheduleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.SchedulePlannedOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.batch.DefaultPlannedOrderServiceBatch;

/**
 * <p>
 *
 * The service contains planned order header, planned order capacity and planned order components. The information is
 * sent in the request as a payload. You can read, create, change and delete components of orders and also use this
 * service to schedule planned order operations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/43/ae2e5876b4a107e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PLANNED_ORDERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PLANNED_ORDERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Planned Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPlannedOrderService" )
@Deprecated
public class DefaultPlannedOrderService implements PlannedOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PlannedOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPlannedOrderService()
    {
        servicePath = PlannedOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPlannedOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPlannedOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPlannedOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPlannedOrderServiceBatch batch()
    {
        return new DefaultPlannedOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PlannedOrderFluentHelper getAllPlannedOrder()
    {
        return new PlannedOrderFluentHelper(servicePath, "A_PlannedOrder");
    }

    @Override
    @Nonnull
    public PlannedOrderByKeyFluentHelper getPlannedOrderByKey( final String plannedOrder )
    {
        return new PlannedOrderByKeyFluentHelper(servicePath, "A_PlannedOrder", plannedOrder);
    }

    @Override
    @Nonnull
    public PlannedOrderCreateFluentHelper createPlannedOrder( @Nonnull final PlannedOrder plannedOrder )
    {
        return new PlannedOrderCreateFluentHelper(servicePath, plannedOrder, "A_PlannedOrder");
    }

    @Override
    @Nonnull
    public PlannedOrderUpdateFluentHelper updatePlannedOrder( @Nonnull final PlannedOrder plannedOrder )
    {
        return new PlannedOrderUpdateFluentHelper(servicePath, plannedOrder, "A_PlannedOrder");
    }

    @Override
    @Nonnull
    public PlannedOrderDeleteFluentHelper deletePlannedOrder( @Nonnull final PlannedOrder plannedOrder )
    {
        return new PlannedOrderDeleteFluentHelper(servicePath, plannedOrder, "A_PlannedOrder");
    }

    @Override
    @Nonnull
    public PlannedOrderCapacityFluentHelper getAllPlannedOrderCapacity()
    {
        return new PlannedOrderCapacityFluentHelper(servicePath, "A_PlannedOrderCapacity");
    }

    @Override
    @Nonnull
    public PlannedOrderCapacityByKeyFluentHelper getPlannedOrderCapacityByKey(
        final String capacityRequirement,
        final String capacityRequirementItem,
        final String capacityRqmtItemCapacity )
    {
        return new PlannedOrderCapacityByKeyFluentHelper(
            servicePath,
            "A_PlannedOrderCapacity",
            capacityRequirement,
            capacityRequirementItem,
            capacityRqmtItemCapacity);
    }

    @Override
    @Nonnull
    public PlannedOrderComponentFluentHelper getAllPlannedOrderComponent()
    {
        return new PlannedOrderComponentFluentHelper(servicePath, "A_PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public
        PlannedOrderComponentByKeyFluentHelper
        getPlannedOrderComponentByKey( final String reservation, final String reservationItem )
    {
        return new PlannedOrderComponentByKeyFluentHelper(
            servicePath,
            "A_PlannedOrderComponent",
            reservation,
            reservationItem);
    }

    @Override
    @Nonnull
    public PlannedOrderComponentCreateFluentHelper createPlannedOrderComponent(
        @Nonnull final PlannedOrderComponent plannedOrderComponent )
    {
        return new PlannedOrderComponentCreateFluentHelper(
            servicePath,
            plannedOrderComponent,
            "A_PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public PlannedOrderComponentUpdateFluentHelper updatePlannedOrderComponent(
        @Nonnull final PlannedOrderComponent plannedOrderComponent )
    {
        return new PlannedOrderComponentUpdateFluentHelper(
            servicePath,
            plannedOrderComponent,
            "A_PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public PlannedOrderComponentDeleteFluentHelper deletePlannedOrderComponent(
        @Nonnull final PlannedOrderComponent plannedOrderComponent )
    {
        return new PlannedOrderComponentDeleteFluentHelper(
            servicePath,
            plannedOrderComponent,
            "A_PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public PlannedOrderScheduleFluentHelper plannedOrderSchedule( @Nonnull final String plannedOrder )
    {
        return new PlannedOrderScheduleFluentHelper(servicePath, plannedOrder);
    }

    @Override
    @Nonnull
    public SchedulePlannedOrderOperationFluentHelper schedulePlannedOrderOperation(
        @Nonnull final String plannedOrder,
        @Nonnull final String capacityRequirement,
        @Nonnull final String capacityRequirementItem,
        @Nonnull final String capacityRqmtItemCapacity,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy )
    {
        return new SchedulePlannedOrderOperationFluentHelper(
            servicePath,
            plannedOrder,
            capacityRequirement,
            capacityRequirementItem,
            capacityRqmtItemCapacity,
            opSchedldStartDate,
            opSchedldStartTime,
            opSchedldEndDate,
            opSchedldEndTime,
            opSchedulingMode,
            opSchedulingStatus,
            opSchedulingStrategy);
    }

}
