/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.batch.DefaultPlanningCategoryServiceBatch;

/**
 * <p>
 * The service contains plan category and plan category text nodes.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4b/5cbdcaeabe47ffb63cd21477308efb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PLANNINGCATEGORY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PLANNINGCATEGORY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>PlanningCategory</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPlanningCategoryService" )
@Deprecated
public class DefaultPlanningCategoryService implements PlanningCategoryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PlanningCategoryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPlanningCategoryService()
    {
        servicePath = PlanningCategoryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPlanningCategoryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPlanningCategoryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPlanningCategoryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPlanningCategoryServiceBatch batch()
    {
        return new DefaultPlanningCategoryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PlanningCategoryFluentHelper getAllPlanningCategory()
    {
        return new PlanningCategoryFluentHelper(servicePath, "A_PlanningCategory");
    }

    @Override
    @Nonnull
    public PlanningCategoryByKeyFluentHelper getPlanningCategoryByKey( final String planningCategory )
    {
        return new PlanningCategoryByKeyFluentHelper(servicePath, "A_PlanningCategory", planningCategory);
    }

    @Override
    @Nonnull
    public PlanningCategoryTextFluentHelper getAllPlanningCategoryText()
    {
        return new PlanningCategoryTextFluentHelper(servicePath, "A_PlanningCategoryText");
    }

    @Override
    @Nonnull
    public
        PlanningCategoryTextByKeyFluentHelper
        getPlanningCategoryTextByKey( final String planningCategory, final String language )
    {
        return new PlanningCategoryTextByKeyFluentHelper(
            servicePath,
            "A_PlanningCategoryText",
            planningCategory,
            language);
    }

}
