/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.batch.DefaultPostLockboxServiceBatch;

/**
 * <p>
 *
 * This service creates lockbox batches, lockbox batch items and clearing information. The lockbox batch root entity and
 * associated entities are sent in the POST request as a payload. After the lockbox batches are created, they are posted
 * immediately and can be processed further using the Manage Lockbox Batches app..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4b/61ff6992fa4567a9c29766c157ee24/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LOCKBOXPOST_IN?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LOCKBOXPOST_IN</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Accounts Receivable Lockbox Integration(SAP_COM_0759)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JT'>Lockbox(1JT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OJT'>Lockbox(OJT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Accounts Receivable Lockbox</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPostLockboxService" )
@Deprecated
public class DefaultPostLockboxService implements PostLockboxService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PostLockboxService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPostLockboxService()
    {
        servicePath = PostLockboxService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPostLockboxService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPostLockboxService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPostLockboxService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPostLockboxServiceBatch batch()
    {
        return new DefaultPostLockboxServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public LockboxBatchFluentHelper getAllLockboxBatch()
    {
        return new LockboxBatchFluentHelper(servicePath, "LockboxBatch");
    }

    @Override
    @Nonnull
    public
        LockboxBatchByKeyFluentHelper
        getLockboxBatchByKey( final String lockboxBatchInternalKey, final String lockboxBatch )
    {
        return new LockboxBatchByKeyFluentHelper(servicePath, "LockboxBatch", lockboxBatchInternalKey, lockboxBatch);
    }

    @Override
    @Nonnull
    public LockboxBatchCreateFluentHelper createLockboxBatch( @Nonnull final LockboxBatch lockboxBatch )
    {
        return new LockboxBatchCreateFluentHelper(servicePath, lockboxBatch, "LockboxBatch");
    }

    @Override
    @Nonnull
    public LockboxBatchItemFluentHelper getAllLockboxBatchItem()
    {
        return new LockboxBatchItemFluentHelper(servicePath, "LockboxBatchItem");
    }

    @Override
    @Nonnull
    public LockboxBatchItemByKeyFluentHelper getLockboxBatchItemByKey(
        final String lockboxBatchInternalKey,
        final String lockboxBatchItem,
        final String lockboxBatch )
    {
        return new LockboxBatchItemByKeyFluentHelper(
            servicePath,
            "LockboxBatchItem",
            lockboxBatchInternalKey,
            lockboxBatchItem,
            lockboxBatch);
    }

    @Override
    @Nonnull
    public LockboxBatchItemCreateFluentHelper createLockboxBatchItem( @Nonnull final LockboxBatchItem lockboxBatchItem )
    {
        return new LockboxBatchItemCreateFluentHelper(servicePath, lockboxBatchItem, "LockboxBatchItem");
    }

    @Override
    @Nonnull
    public LockboxClearingFluentHelper getAllLockboxClearing()
    {
        return new LockboxClearingFluentHelper(servicePath, "LockboxClearing");
    }

    @Override
    @Nonnull
    public LockboxClearingByKeyFluentHelper getLockboxClearingByKey(
        final String paymentAdvice,
        final String paymentAdviceItem,
        final String paymentAdviceAccount,
        final String paymentAdviceAccountType,
        final String companyCode )
    {
        return new LockboxClearingByKeyFluentHelper(
            servicePath,
            "LockboxClearing",
            paymentAdvice,
            paymentAdviceItem,
            paymentAdviceAccount,
            paymentAdviceAccountType,
            companyCode);
    }

}
