/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_IcmCacheFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_PrintOptionsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_PrintQueuesOfUserFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Get_QItem_DocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextQueueItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Set_PrintParameterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.Set_QItem_StatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.batch.DefaultPrintQueueItemServiceBatch;

/**
 * <p>
 * This service enables you to retrieve print queue items of all print queues of a specified user. The status of the
 * print queue items can be modified according to the performed processing in the external application.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com/viewer/e8c6621864654025997c9daea001a778/latest/en-US/26bbee4468f34f06958417e7b70f088b.html'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLOUD_PRINT_PULL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLOUD_PRINT_PULL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Printing - Pull Integration (SAP_COM_0466)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1LQ'>Output Management (‏1LQ‏)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPrintQueueItemService" )
@Deprecated
public class DefaultPrintQueueItemService implements PrintQueueItemService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PrintQueueItemService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPrintQueueItemService()
    {
        servicePath = PrintQueueItemService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPrintQueueItemService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPrintQueueItemService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPrintQueueItemService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPrintQueueItemServiceBatch batch()
    {
        return new DefaultPrintQueueItemServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public
        RetrieveNextQueueItemFluentHelper
        retrieveNextQueueItem( @Nonnull final String qname, @Nonnull final String language )
    {
        return new RetrieveNextQueueItemFluentHelper(servicePath, qname, language);
    }

    @Override
    @Nonnull
    public Get_IcmCacheFluentHelper get_IcmCache()
    {
        return new Get_IcmCacheFluentHelper(servicePath);
    }

    @Override
    @Nonnull
    public Get_PrintQueuesOfUserFluentHelper get_PrintQueuesOfUser()
    {
        return new Get_PrintQueuesOfUserFluentHelper(servicePath);
    }

    @Override
    @Nonnull
    public Set_QItem_StatusFluentHelper set_QItem_Status(
        @Nonnull final String qname,
        @Nonnull final String item_id,
        @Nonnull final String item_status,
        @Nonnull final String status_desc )
    {
        return new Set_QItem_StatusFluentHelper(servicePath, qname, item_id, item_status, status_desc);
    }

    @Override
    @Nonnull
    public Get_QItem_DocumentFluentHelper get_QItem_Document(
        @Nonnull final String item_id,
        @Nonnull final Boolean main_doc,
        @Nonnull final Boolean attachments,
        @Nonnull final String qname )
    {
        return new Get_QItem_DocumentFluentHelper(servicePath, item_id, main_doc, attachments, qname);
    }

    @Override
    @Nonnull
    public Get_PrintOptionsFluentHelper get_PrintOptions( @Nonnull final String qname, @Nonnull final String item_id )
    {
        return new Get_PrintOptionsFluentHelper(servicePath, qname, item_id);
    }

    @Override
    @Nonnull
    public
        Set_PrintParameterFluentHelper
        set_PrintParameter( @Nonnull final String printParams, @Nonnull final String qname )
    {
        return new Set_PrintParameterFluentHelper(servicePath, printParams, qname);
    }

}
