/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.CancelProcOrdConfFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetConfProposalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.GetGdsMvtProposalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConf2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItm;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrdConfMatlDocItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.ProcOrderConfBatchCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2.batch.DefaultProcessOrderConfirmationV2ServiceBatch;

/**
 * <p>
 * You can create time ticket and time event confirmations as well as confirmations on order level, read them, and
 * cancel the confirmations on time ticket, time event, or order level. Before creating a confirmation, you can fetch
 * the proposed data for quantities, work activities, dates and times, personnel data, and goods movements depending on
 * the type of confirmation.
 *
 * Note
 *
 * The following operations are available on the API Reference tab but are not supported by this API: - POST
 * /ProcOrdConf2(ConfirmationGroup=&#39;{ConfirmationGroup}&#39;,ConfirmationCount=&#39;{ConfirmationCount}&#39;,/to_ProcOrdConfMatlDocItm
 * - POST
 * /ProcOrdConfMatlDocItm(ConfirmationGroup=&#39;{ConfirmationGroup}&#39;,ConfirmationCount=&#39;{ConfirmationCount}&#39;,MaterialDocument=&#39;{MaterialDocument}&#39;,MaterialDocumentItem=&#39;{MaterialDocumentItem}&#39;,MaterialDocumentYear=&#39;{MaterialDocumentYear}&#39;,/to_ProcOrderConfBatchCharc
 * .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fc/8dbf5e46004f1c9069b6ac4301c384/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROC_ORDER_CONFIRMATION_2_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROC_ORDER_CONFIRMATION_2_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Process Order Confirmation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProcessOrderConfirmationV2Service" )
@Deprecated
public class DefaultProcessOrderConfirmationV2Service implements ProcessOrderConfirmationV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProcessOrderConfirmationV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProcessOrderConfirmationV2Service()
    {
        servicePath = ProcessOrderConfirmationV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProcessOrderConfirmationV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProcessOrderConfirmationV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProcessOrderConfirmationV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProcessOrderConfirmationV2ServiceBatch batch()
    {
        return new DefaultProcessOrderConfirmationV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProcOrdConf2FluentHelper getAllProcOrdConf2()
    {
        return new ProcOrdConf2FluentHelper(servicePath, "ProcOrdConf2");
    }

    @Override
    @Nonnull
    public
        ProcOrdConf2ByKeyFluentHelper
        getProcOrdConf2ByKey( final String confirmationGroup, final String confirmationCount )
    {
        return new ProcOrdConf2ByKeyFluentHelper(servicePath, "ProcOrdConf2", confirmationGroup, confirmationCount);
    }

    @Override
    @Nonnull
    public ProcOrdConf2CreateFluentHelper createProcOrdConf2( @Nonnull final ProcOrdConf2 procOrdConf2 )
    {
        return new ProcOrdConf2CreateFluentHelper(servicePath, procOrdConf2, "ProcOrdConf2");
    }

    @Override
    @Nonnull
    public ProcOrdConfMatlDocItmFluentHelper getAllProcOrdConfMatlDocItm()
    {
        return new ProcOrdConfMatlDocItmFluentHelper(servicePath, "ProcOrdConfMatlDocItm");
    }

    @Override
    @Nonnull
    public ProcOrdConfMatlDocItmByKeyFluentHelper getProcOrdConfMatlDocItmByKey(
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear )
    {
        return new ProcOrdConfMatlDocItmByKeyFluentHelper(
            servicePath,
            "ProcOrdConfMatlDocItm",
            confirmationGroup,
            confirmationCount,
            materialDocument,
            materialDocumentItem,
            materialDocumentYear);
    }

    @Override
    @Nonnull
    public ProcOrdConfMatlDocItmCreateFluentHelper createProcOrdConfMatlDocItm(
        @Nonnull final ProcOrdConfMatlDocItm procOrdConfMatlDocItm )
    {
        return new ProcOrdConfMatlDocItmCreateFluentHelper(servicePath, procOrdConfMatlDocItm, "ProcOrdConfMatlDocItm");
    }

    @Override
    @Nonnull
    public ProcOrderConfBatchCharcFluentHelper getAllProcOrderConfBatchCharc()
    {
        return new ProcOrderConfBatchCharcFluentHelper(servicePath, "ProcOrderConfBatchCharc");
    }

    @Override
    @Nonnull
    public ProcOrderConfBatchCharcByKeyFluentHelper getProcOrderConfBatchCharcByKey(
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear,
        final String plant,
        final String material,
        final String batch,
        final String charcInternalID )
    {
        return new ProcOrderConfBatchCharcByKeyFluentHelper(
            servicePath,
            "ProcOrderConfBatchCharc",
            confirmationGroup,
            confirmationCount,
            materialDocument,
            materialDocumentItem,
            materialDocumentYear,
            plant,
            material,
            batch,
            charcInternalID);
    }

    @Override
    @Nonnull
    public CancelProcOrdConfFluentHelper cancelProcOrdConf(
        @Nonnull final String confirmationGroup,
        @Nonnull final String confirmationCount,
        @Nullable final LocalDateTime postingDate,
        @Nullable final String confirmationText,
        @Nullable final UUID externalSystemConfirmation )
    {
        return new CancelProcOrdConfFluentHelper(
            servicePath,
            confirmationGroup,
            confirmationCount,
            postingDate,
            confirmationText,
            externalSystemConfirmation);
    }

    @Override
    @Nonnull
    public GetConfProposalFluentHelper getConfProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed )
    {
        return new GetConfProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed);
    }

    @Override
    @Nonnull
    public GetConfProposalFluentHelper getConfProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed,
        @Nullable final String confirmationUnitSAPCode )
    {
        return new GetConfProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed,
            confirmationUnitSAPCode);
    }

    @Override
    @Nonnull
    public GetGdsMvtProposalFluentHelper getGdsMvtProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed )
    {
        return new GetGdsMvtProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed);
    }

    @Override
    @Nonnull
    public GetGdsMvtProposalFluentHelper getGdsMvtProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed,
        @Nullable final String confirmationUnitSAPCode )
    {
        return new GetGdsMvtProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed,
            confirmationUnitSAPCode);
    }

}
