/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.CloseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ConvertPlndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DeletionFlagOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DeletionIndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.DiscardOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ReleaseOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ReleaseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ScheduleProcessOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.TechlyCmpltOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.batch.DefaultProcessOrderServiceBatch;

/**
 * <p>
 * In addition to create, read, and update, you can also release process orders and operations. This service also
 * enables you to schedule process order operations, technically complete and close process orders as well as set the
 * deletion flag and deletion indicator.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/10/e72f5883fa9244e10000000a4450e5/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROCESS_ORDERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROCESS_ORDERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Process Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2008 (Aug 2020). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProcessOrderService" )
@Deprecated
public class DefaultProcessOrderService implements ProcessOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProcessOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProcessOrderService()
    {
        servicePath = ProcessOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProcessOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProcessOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProcessOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProcessOrderServiceBatch batch()
    {
        return new DefaultProcessOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public FunctionMessageFluentHelper getAllFunctionMessage()
    {
        return new FunctionMessageFluentHelper(servicePath, "FunctionMessageCollection");
    }

    @Override
    @Nonnull
    public FunctionMessageByKeyFluentHelper getFunctionMessageByKey( final String message )
    {
        return new FunctionMessageByKeyFluentHelper(servicePath, "FunctionMessageCollection", message);
    }

    @Override
    @Nonnull
    public FunctionMessageCreateFluentHelper createFunctionMessage( @Nonnull final FunctionMessage functionMessage )
    {
        return new FunctionMessageCreateFluentHelper(servicePath, functionMessage, "FunctionMessageCollection");
    }

    @Override
    @Nonnull
    public FunctionMessageUpdateFluentHelper updateFunctionMessage( @Nonnull final FunctionMessage functionMessage )
    {
        return new FunctionMessageUpdateFluentHelper(servicePath, functionMessage, "FunctionMessageCollection");
    }

    @Override
    @Nonnull
    public FunctionMessageDeleteFluentHelper deleteFunctionMessage( @Nonnull final FunctionMessage functionMessage )
    {
        return new FunctionMessageDeleteFluentHelper(servicePath, functionMessage, "FunctionMessageCollection");
    }

    @Override
    @Nonnull
    public ProcessOrderFluentHelper getAllProcessOrder()
    {
        return new ProcessOrderFluentHelper(servicePath, "A_ProcessOrder");
    }

    @Override
    @Nonnull
    public ProcessOrderByKeyFluentHelper getProcessOrderByKey( final String processOrder )
    {
        return new ProcessOrderByKeyFluentHelper(servicePath, "A_ProcessOrder", processOrder);
    }

    @Override
    @Nonnull
    public ProcessOrderCreateFluentHelper createProcessOrder( @Nonnull final ProcessOrder processOrder )
    {
        return new ProcessOrderCreateFluentHelper(servicePath, processOrder, "A_ProcessOrder");
    }

    @Override
    @Nonnull
    public ProcessOrderUpdateFluentHelper updateProcessOrder( @Nonnull final ProcessOrder processOrder )
    {
        return new ProcessOrderUpdateFluentHelper(servicePath, processOrder, "A_ProcessOrder");
    }

    @Override
    @Nonnull
    public ProcessOrderComponentFluentHelper getAllProcessOrderComponent()
    {
        return new ProcessOrderComponentFluentHelper(servicePath, "A_ProcessOrderComponent");
    }

    @Override
    @Nonnull
    public
        ProcessOrderComponentByKeyFluentHelper
        getProcessOrderComponentByKey( final String reservation, final String reservationItem )
    {
        return new ProcessOrderComponentByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderComponent",
            reservation,
            reservationItem);
    }

    @Override
    @Nonnull
    public ProcessOrderItemFluentHelper getAllProcessOrderItem()
    {
        return new ProcessOrderItemFluentHelper(servicePath, "A_ProcessOrderItem");
    }

    @Override
    @Nonnull
    public
        ProcessOrderItemByKeyFluentHelper
        getProcessOrderItemByKey( final String manufacturingOrder, final String manufacturingOrderItem )
    {
        return new ProcessOrderItemByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderItem",
            manufacturingOrder,
            manufacturingOrderItem);
    }

    @Override
    @Nonnull
    public ProcessOrderOperationFluentHelper getAllProcessOrderOperation()
    {
        return new ProcessOrderOperationFluentHelper(servicePath, "A_ProcessOrderOperation");
    }

    @Override
    @Nonnull
    public ProcessOrderOperationByKeyFluentHelper getProcessOrderOperationByKey(
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem )
    {
        return new ProcessOrderOperationByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderOperation",
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem);
    }

    @Override
    @Nonnull
    public ProcessOrderStatusFluentHelper getAllProcessOrderStatus()
    {
        return new ProcessOrderStatusFluentHelper(servicePath, "A_ProcessOrderStatus");
    }

    @Override
    @Nonnull
    public
        ProcessOrderStatusByKeyFluentHelper
        getProcessOrderStatusByKey( final String manufacturingOrder, final String statusCode )
    {
        return new ProcessOrderStatusByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderStatus",
            manufacturingOrder,
            statusCode);
    }

    @Override
    @Nonnull
    public ReleaseOrderFluentHelper releaseOrder( @Nonnull final String manufacturingOrder )
    {
        return new ReleaseOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public
        ReleaseOperationFluentHelper
        releaseOperation( @Nonnull final String manufacturingOrder, @Nonnull final String manufacturingOrderOperation )
    {
        return new ReleaseOperationFluentHelper(servicePath, manufacturingOrder, manufacturingOrderOperation);
    }

    @Override
    @Nonnull
    public TechlyCmpltOrderFluentHelper techlyCmpltOrder( @Nonnull final String manufacturingOrder )
    {
        return new TechlyCmpltOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public CloseOrderFluentHelper closeOrder( @Nonnull final String manufacturingOrder )
    {
        return new CloseOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DeletionFlagOrderFluentHelper deletionFlagOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeletionFlagOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DeletionIndOrderFluentHelper deletionIndOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeletionIndOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DiscardOrderFluentHelper discardOrder( @Nonnull final String manufacturingOrder )
    {
        return new DiscardOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public ConvertPlndOrderFluentHelper convertPlndOrder(
        @Nonnull final String plannedOrder,
        @Nullable final String manufacturingOrderType,
        @Nullable final String manufacturingOrder )
    {
        return new ConvertPlndOrderFluentHelper(servicePath, plannedOrder, manufacturingOrderType, manufacturingOrder);
    }

    @Override
    @Nonnull
    public ScheduleProcessOrderOperationFluentHelper scheduleProcessOrderOperation(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy )
    {
        return new ScheduleProcessOrderOperationFluentHelper(
            servicePath,
            manufacturingOrder,
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem,
            opSchedldStartDate,
            opSchedldStartTime,
            opSchedldEndDate,
            opSchedldEndTime,
            opSchedulingMode,
            opSchedulingStatus,
            opSchedulingStrategy);
    }

}
