/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.CloseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ConvertPlndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.DeletionFlagOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.DeletionIndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.DeliveryCompletedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.DiscardOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.OrderReleasedByMESFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderComponent_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderItem_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderItem_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderOperation_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderProdnRsceTools_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderProdnRsceTools_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderStatus_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrderStatus_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ReleaseOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ReleaseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ScheduleProcessOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.TechlyCmpltOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.batch.DefaultProcessOrderV2ServiceBatch;

/**
 * <p>
 * In addition to create, read, and update process orders, you can also release orders and operations. Besides updating
 * header data of the order including the scheduling type, you can also update some properties of the order components.
 * This service enables you to convert planned orders to process orders, schedule process order operations, and set
 * further statuses for the order such as technically completed, closed, discarded by MES, or released by MES. In
 * addition, you can set the deletion flag, deletion indicator, and delivery completed indicator.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c4/e613a7bf9c40a39cda9ae048e5e2b7/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROCESS_ORDER_2_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROCESS_ORDER_2_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Process Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProcessOrderV2Service" )
@Deprecated
public class DefaultProcessOrderV2Service implements ProcessOrderV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProcessOrderV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProcessOrderV2Service()
    {
        servicePath = ProcessOrderV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProcessOrderV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProcessOrderV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProcessOrderV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProcessOrderV2ServiceBatch batch()
    {
        return new DefaultProcessOrderV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProcessOrderComponent_2FluentHelper getAllProcessOrderComponent_2()
    {
        return new ProcessOrderComponent_2FluentHelper(servicePath, "A_ProcessOrderComponent_2");
    }

    @Override
    @Nonnull
    public ProcessOrderComponent_2ByKeyFluentHelper getProcessOrderComponent_2ByKey(
        final String reservation,
        final String reservationItem,
        final String reservationRecordType )
    {
        return new ProcessOrderComponent_2ByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderComponent_2",
            reservation,
            reservationItem,
            reservationRecordType);
    }

    @Override
    @Nonnull
    public ProcessOrderComponent_2UpdateFluentHelper updateProcessOrderComponent_2(
        @Nonnull final ProcessOrderComponent_2 processOrderComponent_2 )
    {
        return new ProcessOrderComponent_2UpdateFluentHelper(
            servicePath,
            processOrderComponent_2,
            "A_ProcessOrderComponent_2");
    }

    @Override
    @Nonnull
    public ProcessOrderItem_2FluentHelper getAllProcessOrderItem_2()
    {
        return new ProcessOrderItem_2FluentHelper(servicePath, "A_ProcessOrderItem_2");
    }

    @Override
    @Nonnull
    public
        ProcessOrderItem_2ByKeyFluentHelper
        getProcessOrderItem_2ByKey( final String manufacturingOrder, final String manufacturingOrderItem )
    {
        return new ProcessOrderItem_2ByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderItem_2",
            manufacturingOrder,
            manufacturingOrderItem);
    }

    @Override
    @Nonnull
    public ProcessOrderOperation_2FluentHelper getAllProcessOrderOperation_2()
    {
        return new ProcessOrderOperation_2FluentHelper(servicePath, "A_ProcessOrderOperation_2");
    }

    @Override
    @Nonnull
    public ProcessOrderOperation_2ByKeyFluentHelper getProcessOrderOperation_2ByKey(
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem )
    {
        return new ProcessOrderOperation_2ByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderOperation_2",
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem);
    }

    @Override
    @Nonnull
    public ProcessOrderProdnRsceTools_2FluentHelper getAllProcessOrderProdnRsceTools_2()
    {
        return new ProcessOrderProdnRsceTools_2FluentHelper(servicePath, "A_ProcessOrderProdnRsceTools_2");
    }

    @Override
    @Nonnull
    public ProcessOrderProdnRsceTools_2ByKeyFluentHelper getProcessOrderProdnRsceTools_2ByKey(
        final String orderInternalBillOfOperations,
        final String mfgOrderOpProdnRsceToolIntID )
    {
        return new ProcessOrderProdnRsceTools_2ByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderProdnRsceTools_2",
            orderInternalBillOfOperations,
            mfgOrderOpProdnRsceToolIntID);
    }

    @Override
    @Nonnull
    public ProcessOrderStatus_2FluentHelper getAllProcessOrderStatus_2()
    {
        return new ProcessOrderStatus_2FluentHelper(servicePath, "A_ProcessOrderStatus_2");
    }

    @Override
    @Nonnull
    public
        ProcessOrderStatus_2ByKeyFluentHelper
        getProcessOrderStatus_2ByKey( final String manufacturingOrder, final String statusCode )
    {
        return new ProcessOrderStatus_2ByKeyFluentHelper(
            servicePath,
            "A_ProcessOrderStatus_2",
            manufacturingOrder,
            statusCode);
    }

    @Override
    @Nonnull
    public ProcessOrder_2FluentHelper getAllProcessOrder_2()
    {
        return new ProcessOrder_2FluentHelper(servicePath, "A_ProcessOrder_2");
    }

    @Override
    @Nonnull
    public ProcessOrder_2ByKeyFluentHelper getProcessOrder_2ByKey( final String manufacturingOrder )
    {
        return new ProcessOrder_2ByKeyFluentHelper(servicePath, "A_ProcessOrder_2", manufacturingOrder);
    }

    @Override
    @Nonnull
    public ProcessOrder_2CreateFluentHelper createProcessOrder_2( @Nonnull final ProcessOrder_2 processOrder_2 )
    {
        return new ProcessOrder_2CreateFluentHelper(servicePath, processOrder_2, "A_ProcessOrder_2");
    }

    @Override
    @Nonnull
    public ProcessOrder_2UpdateFluentHelper updateProcessOrder_2( @Nonnull final ProcessOrder_2 processOrder_2 )
    {
        return new ProcessOrder_2UpdateFluentHelper(servicePath, processOrder_2, "A_ProcessOrder_2");
    }

    @Override
    @Nonnull
    public ReleaseOrderFluentHelper releaseOrder( @Nonnull final String manufacturingOrder )
    {
        return new ReleaseOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public
        ReleaseOperationFluentHelper
        releaseOperation( @Nonnull final String manufacturingOrder, @Nonnull final String manufacturingOrderOperation )
    {
        return new ReleaseOperationFluentHelper(servicePath, manufacturingOrder, manufacturingOrderOperation);
    }

    @Override
    @Nonnull
    public TechlyCmpltOrderFluentHelper techlyCmpltOrder( @Nonnull final String manufacturingOrder )
    {
        return new TechlyCmpltOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public CloseOrderFluentHelper closeOrder( @Nonnull final String manufacturingOrder )
    {
        return new CloseOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DeletionFlagOrderFluentHelper deletionFlagOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeletionFlagOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DeletionIndOrderFluentHelper deletionIndOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeletionIndOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DiscardOrderFluentHelper discardOrder( @Nonnull final String manufacturingOrder )
    {
        return new DiscardOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public ConvertPlndOrderFluentHelper convertPlndOrder(
        @Nullable final String manufacturingOrder,
        @Nonnull final String plannedOrder,
        @Nullable final String manufacturingOrderType )
    {
        return new ConvertPlndOrderFluentHelper(servicePath, manufacturingOrder, plannedOrder, manufacturingOrderType);
    }

    @Override
    @Nonnull
    public ScheduleProcessOrderOperationFluentHelper scheduleProcessOrderOperation(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy )
    {
        return new ScheduleProcessOrderOperationFluentHelper(
            servicePath,
            manufacturingOrder,
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem,
            opSchedldStartDate,
            opSchedldStartTime,
            opSchedldEndDate,
            opSchedldEndTime,
            opSchedulingMode,
            opSchedulingStatus,
            opSchedulingStrategy);
    }

    @Override
    @Nonnull
    public DeliveryCompletedOrderFluentHelper deliveryCompletedOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeliveryCompletedOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public OrderReleasedByMESFluentHelper orderReleasedByMES( @Nonnull final String manufacturingOrder )
    {
        return new OrderReleasedByMESFluentHelper(servicePath, manufacturingOrder);
    }

}
