/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.DeleteActiveTimeSeriesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.DeleteActvCharcValCombinationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcMetaDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocCharcValCombnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeries;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocObjTimeSeriesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.ProdAllocationObjectTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.SetLifecycleStatusToActiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.SetLifecycleStatusToInactiveFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationobject.batch.DefaultProductAllocationObjectServiceBatch;

/**
 * <p>
 * You can use this service to read the data from product allocation objects as well as read, edit and delete
 * characteristic value combinations and their corresponding time series (planned allocation quantities per period).
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ac/8316e52e5347b0b5259757b7faf2e4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_ALLOCATION_OBJECT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_ALLOCATION_OBJECT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Allocation Object Integration(SAP_COM_0152)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing(1JW)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product Allocation Object</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductAllocationObjectService" )
@Deprecated
public class DefaultProductAllocationObjectService implements ProductAllocationObjectService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductAllocationObjectService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductAllocationObjectService()
    {
        servicePath = ProductAllocationObjectService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductAllocationObjectService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductAllocationObjectService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductAllocationObjectService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductAllocationObjectServiceBatch batch()
    {
        return new DefaultProductAllocationObjectServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProdAllocationObjectFluentHelper getAllProdAllocationObject()
    {
        return new ProdAllocationObjectFluentHelper(servicePath, "A_ProdAllocationObject");
    }

    @Override
    @Nonnull
    public ProdAllocationObjectByKeyFluentHelper getProdAllocationObjectByKey( final UUID productAllocationObjectUUID )
    {
        return new ProdAllocationObjectByKeyFluentHelper(
            servicePath,
            "A_ProdAllocationObject",
            productAllocationObjectUUID);
    }

    @Override
    @Nonnull
    public ProdAllocationObjectCreateFluentHelper createProdAllocationObject(
        @Nonnull final ProdAllocationObject prodAllocationObject )
    {
        return new ProdAllocationObjectCreateFluentHelper(servicePath, prodAllocationObject, "A_ProdAllocationObject");
    }

    @Override
    @Nonnull
    public ProdAllocationObjectTFluentHelper getAllProdAllocationObjectT()
    {
        return new ProdAllocationObjectTFluentHelper(servicePath, "A_ProdAllocationObjectT");
    }

    @Override
    @Nonnull
    public
        ProdAllocationObjectTByKeyFluentHelper
        getProdAllocationObjectTByKey( final UUID productAllocationObjectUUID, final String language )
    {
        return new ProdAllocationObjectTByKeyFluentHelper(
            servicePath,
            "A_ProdAllocationObjectT",
            productAllocationObjectUUID,
            language);
    }

    @Override
    @Nonnull
    public ProdAllocCharcMetaDataFluentHelper getAllProdAllocCharcMetaData()
    {
        return new ProdAllocCharcMetaDataFluentHelper(servicePath, "A_ProdAllocCharcMetaData");
    }

    @Override
    @Nonnull
    public ProdAllocCharcMetaDataByKeyFluentHelper getProdAllocCharcMetaDataByKey(
        final UUID characteristicsMetaDataUUID )
    {
        return new ProdAllocCharcMetaDataByKeyFluentHelper(
            servicePath,
            "A_ProdAllocCharcMetaData",
            characteristicsMetaDataUUID);
    }

    @Override
    @Nonnull
    public ProdAllocCharcValCombnFluentHelper getAllProdAllocCharcValCombn()
    {
        return new ProdAllocCharcValCombnFluentHelper(servicePath, "A_ProdAllocCharcValCombn");
    }

    @Override
    @Nonnull
    public ProdAllocCharcValCombnByKeyFluentHelper getProdAllocCharcValCombnByKey(
        final UUID charcValueCombinationUUID )
    {
        return new ProdAllocCharcValCombnByKeyFluentHelper(
            servicePath,
            "A_ProdAllocCharcValCombn",
            charcValueCombinationUUID);
    }

    @Override
    @Nonnull
    public ProdAllocCharcValCombnCreateFluentHelper createProdAllocCharcValCombn(
        @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn )
    {
        return new ProdAllocCharcValCombnCreateFluentHelper(
            servicePath,
            prodAllocCharcValCombn,
            "A_ProdAllocCharcValCombn");
    }

    @Override
    @Nonnull
    public ProdAllocCharcValCombnUpdateFluentHelper updateProdAllocCharcValCombn(
        @Nonnull final ProdAllocCharcValCombn prodAllocCharcValCombn )
    {
        return new ProdAllocCharcValCombnUpdateFluentHelper(
            servicePath,
            prodAllocCharcValCombn,
            "A_ProdAllocCharcValCombn");
    }

    @Override
    @Nonnull
    public ProdAllocObjTimeSeriesFluentHelper getAllProdAllocObjTimeSeries()
    {
        return new ProdAllocObjTimeSeriesFluentHelper(servicePath, "A_ProdAllocObjTimeSeries");
    }

    @Override
    @Nonnull
    public ProdAllocObjTimeSeriesByKeyFluentHelper getProdAllocObjTimeSeriesByKey(
        final UUID prodAllocationTimeSeriesUUID )
    {
        return new ProdAllocObjTimeSeriesByKeyFluentHelper(
            servicePath,
            "A_ProdAllocObjTimeSeries",
            prodAllocationTimeSeriesUUID);
    }

    @Override
    @Nonnull
    public ProdAllocObjTimeSeriesUpdateFluentHelper updateProdAllocObjTimeSeries(
        @Nonnull final ProdAllocObjTimeSeries prodAllocObjTimeSeries )
    {
        return new ProdAllocObjTimeSeriesUpdateFluentHelper(
            servicePath,
            prodAllocObjTimeSeries,
            "A_ProdAllocObjTimeSeries");
    }

    @Override
    @Nonnull
    public DeleteActvCharcValCombinationFluentHelper deleteActvCharcValCombination(
        @Nonnull final UUID charcValueCombinationUUID,
        @Nonnull final Boolean isdeleteqa )
    {
        return new DeleteActvCharcValCombinationFluentHelper(servicePath, charcValueCombinationUUID, isdeleteqa);
    }

    @Override
    @Nonnull
    public SetLifecycleStatusToActiveFluentHelper setLifecycleStatusToActive(
        @Nonnull final UUID charcValueCombinationUUID )
    {
        return new SetLifecycleStatusToActiveFluentHelper(servicePath, charcValueCombinationUUID);
    }

    @Override
    @Nonnull
    public SetLifecycleStatusToInactiveFluentHelper setLifecycleStatusToInactive(
        @Nonnull final UUID charcValueCombinationUUID )
    {
        return new SetLifecycleStatusToInactiveFluentHelper(servicePath, charcValueCombinationUUID);
    }

    @Override
    @Nonnull
    public
        DeleteActiveTimeSeriesFluentHelper
        deleteActiveTimeSeries( @Nonnull final UUID prodAllocationTimeSeriesUUID, @Nonnull final Boolean isdeleteqa )
    {
        return new DeleteActiveTimeSeriesFluentHelper(servicePath, prodAllocationTimeSeriesUUID, isdeleteqa);
    }

}
