/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.DeleteSequenceAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSequenceTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocSqncAssgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequence;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequenceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequenceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.ProdAllocationSequenceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productallocationsequence.batch.DefaultProductAllocationSequenceServiceBatch;

/**
 * <p>
 * You can use this service to read header data for a specific product allocation sequence (including its description)
 * as well as read, edit and delete any assigned product and product-location assignments.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/88/9b662a6a7f489a88e0113d1a86bb96/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_ALLOC_SEQUENCE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_ALLOC_SEQUENCE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Allocation Sequence Integration(SAP_COM_0161)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing(1JW)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product Allocation Sequence</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductAllocationSequenceService" )
@Deprecated
public class DefaultProductAllocationSequenceService implements ProductAllocationSequenceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductAllocationSequenceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductAllocationSequenceService()
    {
        servicePath = ProductAllocationSequenceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductAllocationSequenceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductAllocationSequenceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductAllocationSequenceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductAllocationSequenceServiceBatch batch()
    {
        return new DefaultProductAllocationSequenceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProdAllocationSequenceFluentHelper getAllProdAllocationSequence()
    {
        return new ProdAllocationSequenceFluentHelper(servicePath, "A_ProdAllocationSequence");
    }

    @Override
    @Nonnull
    public ProdAllocationSequenceByKeyFluentHelper getProdAllocationSequenceByKey(
        final UUID productAllocationSequenceUUID )
    {
        return new ProdAllocationSequenceByKeyFluentHelper(
            servicePath,
            "A_ProdAllocationSequence",
            productAllocationSequenceUUID);
    }

    @Override
    @Nonnull
    public ProdAllocationSequenceCreateFluentHelper createProdAllocationSequence(
        @Nonnull final ProdAllocationSequence prodAllocationSequence )
    {
        return new ProdAllocationSequenceCreateFluentHelper(
            servicePath,
            prodAllocationSequence,
            "A_ProdAllocationSequence");
    }

    @Override
    @Nonnull
    public ProdAllocSequenceTFluentHelper getAllProdAllocSequenceT()
    {
        return new ProdAllocSequenceTFluentHelper(servicePath, "A_ProdAllocSequenceT");
    }

    @Override
    @Nonnull
    public
        ProdAllocSequenceTByKeyFluentHelper
        getProdAllocSequenceTByKey( final UUID productAllocationSequenceUUID, final String language )
    {
        return new ProdAllocSequenceTByKeyFluentHelper(
            servicePath,
            "A_ProdAllocSequenceT",
            productAllocationSequenceUUID,
            language);
    }

    @Override
    @Nonnull
    public ProdAllocSqncAssgmtFluentHelper getAllProdAllocSqncAssgmt()
    {
        return new ProdAllocSqncAssgmtFluentHelper(servicePath, "A_ProdAllocSqncAssgmt");
    }

    @Override
    @Nonnull
    public ProdAllocSqncAssgmtByKeyFluentHelper getProdAllocSqncAssgmtByKey( final UUID prodAllocSqncAssignmentUUID )
    {
        return new ProdAllocSqncAssgmtByKeyFluentHelper(
            servicePath,
            "A_ProdAllocSqncAssgmt",
            prodAllocSqncAssignmentUUID);
    }

    @Override
    @Nonnull
    public ProdAllocSqncAssgmtUpdateFluentHelper updateProdAllocSqncAssgmt(
        @Nonnull final ProdAllocSqncAssgmt prodAllocSqncAssgmt )
    {
        return new ProdAllocSqncAssgmtUpdateFluentHelper(servicePath, prodAllocSqncAssgmt, "A_ProdAllocSqncAssgmt");
    }

    @Override
    @Nonnull
    public DeleteSequenceAssignmentFluentHelper deleteSequenceAssignment(
        @Nonnull final UUID prodAllocSqncAssignmentUUID )
    {
        return new DeleteSequenceAssignmentFluentHelper(servicePath, prodAllocSqncAssignmentUUID);
    }

}
