/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroupTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.ProductGroupTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productgroup.batch.DefaultProductGroupServiceBatch;

/**
 * <p>
 * The service contains product group and product group text nodes.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/9e/784f0993264356b10ae4c6897204c0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTGROUP_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTGROUP_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Excise Tax Integration(SAP_COM_0568), Procurement -
 * Supplier Quotation Management Integration(SAP_COM_0760)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product Group</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductGroupService" )
@Deprecated
public class DefaultProductGroupService implements ProductGroupService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductGroupService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductGroupService()
    {
        servicePath = ProductGroupService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductGroupService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductGroupService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductGroupService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductGroupServiceBatch batch()
    {
        return new DefaultProductGroupServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductGroupFluentHelper getAllProductGroup()
    {
        return new ProductGroupFluentHelper(servicePath, "A_ProductGroup");
    }

    @Override
    @Nonnull
    public ProductGroupByKeyFluentHelper getProductGroupByKey( final String materialGroup )
    {
        return new ProductGroupByKeyFluentHelper(servicePath, "A_ProductGroup", materialGroup);
    }

    @Override
    @Nonnull
    public ProductGroupTextFluentHelper getAllProductGroupText()
    {
        return new ProductGroupTextFluentHelper(servicePath, "A_ProductGroupText");
    }

    @Override
    @Nonnull
    public
        ProductGroupTextByKeyFluentHelper
        getProductGroupTextByKey( final String materialGroup, final String language )
    {
        return new ProductGroupTextByKeyFluentHelper(servicePath, "A_ProductGroupText", materialGroup, language);
    }

}
