/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnClassForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ClfnProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductPlantProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSalesTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductStorageLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductSupplyPlanningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkSchedulingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.ProductWorkSchedulingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmasterdataincludingclassification.batch.DefaultProductMasterDataIncludingClassificationServiceBatch;

/**
 * <p>
 * Product master is a reusable set of data describing a product or service. Using the API you can read product master
 * data, class assignment and characteristic valuation.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/34/f342df989544e3913eda5bf42c4bc3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLFN_PRODUCT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLFN_PRODUCT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Classification Integration(SAP_COM_0309)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductMasterDataIncludingClassificationService" )
@Deprecated
public class DefaultProductMasterDataIncludingClassificationService
    implements
    ProductMasterDataIncludingClassificationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductMasterDataIncludingClassificationService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultProductMasterDataIncludingClassificationService()
    {
        servicePath = ProductMasterDataIncludingClassificationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductMasterDataIncludingClassificationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductMasterDataIncludingClassificationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductMasterDataIncludingClassificationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductMasterDataIncludingClassificationServiceBatch batch()
    {
        return new DefaultProductMasterDataIncludingClassificationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductPlantProcurementFluentHelper getAllProductPlantProcurement()
    {
        return new ProductPlantProcurementFluentHelper(servicePath, "A_ProductPlantProcurement");
    }

    @Override
    @Nonnull
    public
        ProductPlantProcurementByKeyFluentHelper
        getProductPlantProcurementByKey( final String product, final String plant )
    {
        return new ProductPlantProcurementByKeyFluentHelper(servicePath, "A_ProductPlantProcurement", product, plant);
    }

    @Override
    @Nonnull
    public ProductStorageLocationFluentHelper getAllProductStorageLocation()
    {
        return new ProductStorageLocationFluentHelper(servicePath, "A_ProductStorageLocation");
    }

    @Override
    @Nonnull
    public
        ProductStorageLocationByKeyFluentHelper
        getProductStorageLocationByKey( final String product, final String plant, final String storageLocation )
    {
        return new ProductStorageLocationByKeyFluentHelper(
            servicePath,
            "A_ProductStorageLocation",
            product,
            plant,
            storageLocation);
    }

    @Override
    @Nonnull
    public ProductSupplyPlanningFluentHelper getAllProductSupplyPlanning()
    {
        return new ProductSupplyPlanningFluentHelper(servicePath, "A_ProductSupplyPlanning");
    }

    @Override
    @Nonnull
    public
        ProductSupplyPlanningByKeyFluentHelper
        getProductSupplyPlanningByKey( final String product, final String plant )
    {
        return new ProductSupplyPlanningByKeyFluentHelper(servicePath, "A_ProductSupplyPlanning", product, plant);
    }

    @Override
    @Nonnull
    public ClfnProductFluentHelper getAllClfnProduct()
    {
        return new ClfnProductFluentHelper(servicePath, "A_ClfnProduct");
    }

    @Override
    @Nonnull
    public ClfnProductByKeyFluentHelper getClfnProductByKey( final String product )
    {
        return new ClfnProductByKeyFluentHelper(servicePath, "A_ClfnProduct", product);
    }

    @Override
    @Nonnull
    public ClfnClassForKeyDateFluentHelper getAllClfnClassForKeyDate()
    {
        return new ClfnClassForKeyDateFluentHelper(servicePath, "A_ClfnClassForKeyDate");
    }

    @Override
    @Nonnull
    public ClfnClassForKeyDateByKeyFluentHelper getClfnClassForKeyDateByKey( final String classInternalID )
    {
        return new ClfnClassForKeyDateByKeyFluentHelper(servicePath, "A_ClfnClassForKeyDate", classInternalID);
    }

    @Override
    @Nonnull
    public ProductDescriptionFluentHelper getAllProductDescription()
    {
        return new ProductDescriptionFluentHelper(servicePath, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductDescriptionByKeyFluentHelper getProductDescriptionByKey( final String product, final String language )
    {
        return new ProductDescriptionByKeyFluentHelper(servicePath, "A_ProductDescription", product, language);
    }

    @Override
    @Nonnull
    public ProductPlantFluentHelper getAllProductPlant()
    {
        return new ProductPlantFluentHelper(servicePath, "A_ProductPlant");
    }

    @Override
    @Nonnull
    public ProductPlantByKeyFluentHelper getProductPlantByKey( final String product, final String plant )
    {
        return new ProductPlantByKeyFluentHelper(servicePath, "A_ProductPlant", product, plant);
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryFluentHelper getAllProductSalesDelivery()
    {
        return new ProductSalesDeliveryFluentHelper(servicePath, "A_ProductSalesDelivery");
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryByKeyFluentHelper getProductSalesDeliveryByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl )
    {
        return new ProductSalesDeliveryByKeyFluentHelper(
            servicePath,
            "A_ProductSalesDelivery",
            product,
            productSalesOrg,
            productDistributionChnl);
    }

    @Override
    @Nonnull
    public ProductSalesTaxFluentHelper getAllProductSalesTax()
    {
        return new ProductSalesTaxFluentHelper(servicePath, "A_ProductSalesTax");
    }

    @Override
    @Nonnull
    public ProductSalesTaxByKeyFluentHelper getProductSalesTaxByKey(
        final String product,
        final String country,
        final String taxCategory,
        final String taxClassification )
    {
        return new ProductSalesTaxByKeyFluentHelper(
            servicePath,
            "A_ProductSalesTax",
            product,
            country,
            taxCategory,
            taxClassification);
    }

    @Override
    @Nonnull
    public ProductWorkSchedulingFluentHelper getAllProductWorkScheduling()
    {
        return new ProductWorkSchedulingFluentHelper(servicePath, "A_ProductWorkScheduling");
    }

    @Override
    @Nonnull
    public
        ProductWorkSchedulingByKeyFluentHelper
        getProductWorkSchedulingByKey( final String product, final String plant )
    {
        return new ProductWorkSchedulingByKeyFluentHelper(servicePath, "A_ProductWorkScheduling", product, plant);
    }

    @Override
    @Nonnull
    public ProductCharcFluentHelper getAllProductCharc()
    {
        return new ProductCharcFluentHelper(servicePath, "A_ProductCharc");
    }

    @Override
    @Nonnull
    public
        ProductCharcByKeyFluentHelper
        getProductCharcByKey( final String product, final String charcInternalID, final String classType )
    {
        return new ProductCharcByKeyFluentHelper(servicePath, "A_ProductCharc", product, charcInternalID, classType);
    }

    @Override
    @Nonnull
    public ProductCharcValueFluentHelper getAllProductCharcValue()
    {
        return new ProductCharcValueFluentHelper(servicePath, "A_ProductCharcValue");
    }

    @Override
    @Nonnull
    public ProductCharcValueByKeyFluentHelper getProductCharcValueByKey(
        final String product,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber )
    {
        return new ProductCharcValueByKeyFluentHelper(
            servicePath,
            "A_ProductCharcValue",
            product,
            classType,
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public ProductClassFluentHelper getAllProductClass()
    {
        return new ProductClassFluentHelper(servicePath, "A_ProductClass");
    }

    @Override
    @Nonnull
    public ProductClassByKeyFluentHelper getProductClassByKey( final String product, final String classInternalID )
    {
        return new ProductClassByKeyFluentHelper(servicePath, "A_ProductClass", product, classInternalID);
    }

    @Override
    @Nonnull
    public ProductClassCharcFluentHelper getAllProductClassCharc()
    {
        return new ProductClassCharcFluentHelper(servicePath, "A_ProductClassCharc");
    }

    @Override
    @Nonnull
    public
        ProductClassCharcByKeyFluentHelper
        getProductClassCharcByKey( final String product, final String classInternalID, final String charcInternalID )
    {
        return new ProductClassCharcByKeyFluentHelper(
            servicePath,
            "A_ProductClassCharc",
            product,
            classInternalID,
            charcInternalID);
    }

}
