/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.batch.DefaultProductMasterServiceBatch;

/**
 * <p>
 *
 * The service supports following operations: GET, POST, PUT, PATCH, DELETE. You can create, read, update, and delete
 * product master data at the entity level..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/74/aa2b58a333a107e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Integration(SAP_COM_0009), Distributed Manufacturing Integration(SAP_COM_0077), SAP Analytics Cloud for
 * Planning Integration(SAP_COM_0087), Excise Tax Integration(SAP_COM_0568), Procurement - Supplier Quotation Management
 * Integration(SAP_COM_0760), S/4HANA QM/NCM - Supplier Problem-Solving Integration(SAP_COM_0808), S/4HANA QM/NCM -
 * Quality Issue Resolution Integration(SAP_COM_0837)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1RO'>Master Data Integration(1RO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1VP'>Opportunity-to-Order with SAP Cloud for Customer(1VP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2F9'>Quality Management for Complaints Against Suppliers(2F9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2FA'>Quality Management for Complaints from Customers(2FA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductMasterService" )
@Deprecated
public class DefaultProductMasterService implements ProductMasterService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductMasterService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductMasterService()
    {
        servicePath = ProductMasterService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductMasterService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductMasterService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductMasterService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductMasterServiceBatch batch()
    {
        return new DefaultProductMasterServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductFluentHelper getAllProduct()
    {
        return new ProductFluentHelper(servicePath, "A_Product");
    }

    @Override
    @Nonnull
    public ProductByKeyFluentHelper getProductByKey( final String product )
    {
        return new ProductByKeyFluentHelper(servicePath, "A_Product", product);
    }

    @Override
    @Nonnull
    public ProductCreateFluentHelper createProduct( @Nonnull final Product product )
    {
        return new ProductCreateFluentHelper(servicePath, product, "A_Product");
    }

    @Override
    @Nonnull
    public ProductUpdateFluentHelper updateProduct( @Nonnull final Product product )
    {
        return new ProductUpdateFluentHelper(servicePath, product, "A_Product");
    }

    @Override
    @Nonnull
    public ProductBasicTextFluentHelper getAllProductBasicText()
    {
        return new ProductBasicTextFluentHelper(servicePath, "A_ProductBasicText");
    }

    @Override
    @Nonnull
    public ProductBasicTextByKeyFluentHelper getProductBasicTextByKey( final String product, final String language )
    {
        return new ProductBasicTextByKeyFluentHelper(servicePath, "A_ProductBasicText", product, language);
    }

    @Override
    @Nonnull
    public ProductBasicTextCreateFluentHelper createProductBasicText( @Nonnull final ProductBasicText productBasicText )
    {
        return new ProductBasicTextCreateFluentHelper(servicePath, productBasicText, "A_ProductBasicText");
    }

    @Override
    @Nonnull
    public ProductBasicTextUpdateFluentHelper updateProductBasicText( @Nonnull final ProductBasicText productBasicText )
    {
        return new ProductBasicTextUpdateFluentHelper(servicePath, productBasicText, "A_ProductBasicText");
    }

    @Override
    @Nonnull
    public ProductBasicTextDeleteFluentHelper deleteProductBasicText( @Nonnull final ProductBasicText productBasicText )
    {
        return new ProductBasicTextDeleteFluentHelper(servicePath, productBasicText, "A_ProductBasicText");
    }

    @Override
    @Nonnull
    public ProductDescriptionFluentHelper getAllProductDescription()
    {
        return new ProductDescriptionFluentHelper(servicePath, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductDescriptionByKeyFluentHelper getProductDescriptionByKey( final String product, final String language )
    {
        return new ProductDescriptionByKeyFluentHelper(servicePath, "A_ProductDescription", product, language);
    }

    @Override
    @Nonnull
    public ProductDescriptionCreateFluentHelper createProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return new ProductDescriptionCreateFluentHelper(servicePath, productDescription, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductDescriptionUpdateFluentHelper updateProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return new ProductDescriptionUpdateFluentHelper(servicePath, productDescription, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductDescriptionDeleteFluentHelper deleteProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return new ProductDescriptionDeleteFluentHelper(servicePath, productDescription, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductInspectionTextFluentHelper getAllProductInspectionText()
    {
        return new ProductInspectionTextFluentHelper(servicePath, "A_ProductInspectionText");
    }

    @Override
    @Nonnull
    public
        ProductInspectionTextByKeyFluentHelper
        getProductInspectionTextByKey( final String product, final String language )
    {
        return new ProductInspectionTextByKeyFluentHelper(servicePath, "A_ProductInspectionText", product, language);
    }

    @Override
    @Nonnull
    public ProductInspectionTextCreateFluentHelper createProductInspectionText(
        @Nonnull final ProductInspectionText productInspectionText )
    {
        return new ProductInspectionTextCreateFluentHelper(
            servicePath,
            productInspectionText,
            "A_ProductInspectionText");
    }

    @Override
    @Nonnull
    public ProductInspectionTextUpdateFluentHelper updateProductInspectionText(
        @Nonnull final ProductInspectionText productInspectionText )
    {
        return new ProductInspectionTextUpdateFluentHelper(
            servicePath,
            productInspectionText,
            "A_ProductInspectionText");
    }

    @Override
    @Nonnull
    public ProductInspectionTextDeleteFluentHelper deleteProductInspectionText(
        @Nonnull final ProductInspectionText productInspectionText )
    {
        return new ProductInspectionTextDeleteFluentHelper(
            servicePath,
            productInspectionText,
            "A_ProductInspectionText");
    }

    @Override
    @Nonnull
    public ProductMLAccountFluentHelper getAllProductMLAccount()
    {
        return new ProductMLAccountFluentHelper(servicePath, "A_ProductMLAccount");
    }

    @Override
    @Nonnull
    public ProductMLAccountByKeyFluentHelper getProductMLAccountByKey(
        final String product,
        final String valuationArea,
        final String valuationType,
        final String currencyRole )
    {
        return new ProductMLAccountByKeyFluentHelper(
            servicePath,
            "A_ProductMLAccount",
            product,
            valuationArea,
            valuationType,
            currencyRole);
    }

    @Override
    @Nonnull
    public ProductMLAccountCreateFluentHelper createProductMLAccount( @Nonnull final ProductMLAccount productMLAccount )
    {
        return new ProductMLAccountCreateFluentHelper(servicePath, productMLAccount, "A_ProductMLAccount");
    }

    @Override
    @Nonnull
    public ProductMLAccountUpdateFluentHelper updateProductMLAccount( @Nonnull final ProductMLAccount productMLAccount )
    {
        return new ProductMLAccountUpdateFluentHelper(servicePath, productMLAccount, "A_ProductMLAccount");
    }

    @Override
    @Nonnull
    public ProductMLPricesFluentHelper getAllProductMLPrices()
    {
        return new ProductMLPricesFluentHelper(servicePath, "A_ProductMLPrices");
    }

    @Override
    @Nonnull
    public ProductMLPricesByKeyFluentHelper getProductMLPricesByKey(
        final String product,
        final String valuationArea,
        final String valuationType,
        final String currencyRole )
    {
        return new ProductMLPricesByKeyFluentHelper(
            servicePath,
            "A_ProductMLPrices",
            product,
            valuationArea,
            valuationType,
            currencyRole);
    }

    @Override
    @Nonnull
    public ProductMLPricesCreateFluentHelper createProductMLPrices( @Nonnull final ProductMLPrices productMLPrices )
    {
        return new ProductMLPricesCreateFluentHelper(servicePath, productMLPrices, "A_ProductMLPrices");
    }

    @Override
    @Nonnull
    public ProductMLPricesUpdateFluentHelper updateProductMLPrices( @Nonnull final ProductMLPrices productMLPrices )
    {
        return new ProductMLPricesUpdateFluentHelper(servicePath, productMLPrices, "A_ProductMLPrices");
    }

    @Override
    @Nonnull
    public ProductPlantFluentHelper getAllProductPlant()
    {
        return new ProductPlantFluentHelper(servicePath, "A_ProductPlant");
    }

    @Override
    @Nonnull
    public ProductPlantByKeyFluentHelper getProductPlantByKey( final String product, final String plant )
    {
        return new ProductPlantByKeyFluentHelper(servicePath, "A_ProductPlant", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantCreateFluentHelper createProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return new ProductPlantCreateFluentHelper(servicePath, productPlant, "A_ProductPlant");
    }

    @Override
    @Nonnull
    public ProductPlantUpdateFluentHelper updateProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return new ProductPlantUpdateFluentHelper(servicePath, productPlant, "A_ProductPlant");
    }

    @Override
    @Nonnull
    public ProductPlantCostingFluentHelper getAllProductPlantCosting()
    {
        return new ProductPlantCostingFluentHelper(servicePath, "A_ProductPlantCosting");
    }

    @Override
    @Nonnull
    public ProductPlantCostingByKeyFluentHelper getProductPlantCostingByKey( final String product, final String plant )
    {
        return new ProductPlantCostingByKeyFluentHelper(servicePath, "A_ProductPlantCosting", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantCostingCreateFluentHelper createProductPlantCosting(
        @Nonnull final ProductPlantCosting productPlantCosting )
    {
        return new ProductPlantCostingCreateFluentHelper(servicePath, productPlantCosting, "A_ProductPlantCosting");
    }

    @Override
    @Nonnull
    public ProductPlantCostingUpdateFluentHelper updateProductPlantCosting(
        @Nonnull final ProductPlantCosting productPlantCosting )
    {
        return new ProductPlantCostingUpdateFluentHelper(servicePath, productPlantCosting, "A_ProductPlantCosting");
    }

    @Override
    @Nonnull
    public ProductPlantForecastingFluentHelper getAllProductPlantForecasting()
    {
        return new ProductPlantForecastingFluentHelper(servicePath, "A_ProductPlantForecasting");
    }

    @Override
    @Nonnull
    public
        ProductPlantForecastingByKeyFluentHelper
        getProductPlantForecastingByKey( final String product, final String plant )
    {
        return new ProductPlantForecastingByKeyFluentHelper(servicePath, "A_ProductPlantForecasting", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantForecastingCreateFluentHelper createProductPlantForecasting(
        @Nonnull final ProductPlantForecasting productPlantForecasting )
    {
        return new ProductPlantForecastingCreateFluentHelper(
            servicePath,
            productPlantForecasting,
            "A_ProductPlantForecasting");
    }

    @Override
    @Nonnull
    public ProductPlantForecastingUpdateFluentHelper updateProductPlantForecasting(
        @Nonnull final ProductPlantForecasting productPlantForecasting )
    {
        return new ProductPlantForecastingUpdateFluentHelper(
            servicePath,
            productPlantForecasting,
            "A_ProductPlantForecasting");
    }

    @Override
    @Nonnull
    public ProductPlantIntlTrdFluentHelper getAllProductPlantIntlTrd()
    {
        return new ProductPlantIntlTrdFluentHelper(servicePath, "A_ProductPlantIntlTrd");
    }

    @Override
    @Nonnull
    public ProductPlantIntlTrdByKeyFluentHelper getProductPlantIntlTrdByKey( final String product, final String plant )
    {
        return new ProductPlantIntlTrdByKeyFluentHelper(servicePath, "A_ProductPlantIntlTrd", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantIntlTrdCreateFluentHelper createProductPlantIntlTrd(
        @Nonnull final ProductPlantIntlTrd productPlantIntlTrd )
    {
        return new ProductPlantIntlTrdCreateFluentHelper(servicePath, productPlantIntlTrd, "A_ProductPlantIntlTrd");
    }

    @Override
    @Nonnull
    public ProductPlantIntlTrdUpdateFluentHelper updateProductPlantIntlTrd(
        @Nonnull final ProductPlantIntlTrd productPlantIntlTrd )
    {
        return new ProductPlantIntlTrdUpdateFluentHelper(servicePath, productPlantIntlTrd, "A_ProductPlantIntlTrd");
    }

    @Override
    @Nonnull
    public ProductPlantMRPAreaFluentHelper getAllProductPlantMRPArea()
    {
        return new ProductPlantMRPAreaFluentHelper(servicePath, "A_ProductPlantMRPArea");
    }

    @Override
    @Nonnull
    public
        ProductPlantMRPAreaByKeyFluentHelper
        getProductPlantMRPAreaByKey( final String product, final String plant, final String mRPArea )
    {
        return new ProductPlantMRPAreaByKeyFluentHelper(servicePath, "A_ProductPlantMRPArea", product, plant, mRPArea);
    }

    @Override
    @Nonnull
    public ProductPlantMRPAreaCreateFluentHelper createProductPlantMRPArea(
        @Nonnull final ProductPlantMRPArea productPlantMRPArea )
    {
        return new ProductPlantMRPAreaCreateFluentHelper(servicePath, productPlantMRPArea, "A_ProductPlantMRPArea");
    }

    @Override
    @Nonnull
    public ProductPlantMRPAreaUpdateFluentHelper updateProductPlantMRPArea(
        @Nonnull final ProductPlantMRPArea productPlantMRPArea )
    {
        return new ProductPlantMRPAreaUpdateFluentHelper(servicePath, productPlantMRPArea, "A_ProductPlantMRPArea");
    }

    @Override
    @Nonnull
    public ProductPlantProcurementFluentHelper getAllProductPlantProcurement()
    {
        return new ProductPlantProcurementFluentHelper(servicePath, "A_ProductPlantProcurement");
    }

    @Override
    @Nonnull
    public
        ProductPlantProcurementByKeyFluentHelper
        getProductPlantProcurementByKey( final String product, final String plant )
    {
        return new ProductPlantProcurementByKeyFluentHelper(servicePath, "A_ProductPlantProcurement", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantProcurementCreateFluentHelper createProductPlantProcurement(
        @Nonnull final ProductPlantProcurement productPlantProcurement )
    {
        return new ProductPlantProcurementCreateFluentHelper(
            servicePath,
            productPlantProcurement,
            "A_ProductPlantProcurement");
    }

    @Override
    @Nonnull
    public ProductPlantProcurementUpdateFluentHelper updateProductPlantProcurement(
        @Nonnull final ProductPlantProcurement productPlantProcurement )
    {
        return new ProductPlantProcurementUpdateFluentHelper(
            servicePath,
            productPlantProcurement,
            "A_ProductPlantProcurement");
    }

    @Override
    @Nonnull
    public ProductPlantQualityMgmtFluentHelper getAllProductPlantQualityMgmt()
    {
        return new ProductPlantQualityMgmtFluentHelper(servicePath, "A_ProductPlantQualityMgmt");
    }

    @Override
    @Nonnull
    public
        ProductPlantQualityMgmtByKeyFluentHelper
        getProductPlantQualityMgmtByKey( final String product, final String plant )
    {
        return new ProductPlantQualityMgmtByKeyFluentHelper(servicePath, "A_ProductPlantQualityMgmt", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantQualityMgmtCreateFluentHelper createProductPlantQualityMgmt(
        @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt )
    {
        return new ProductPlantQualityMgmtCreateFluentHelper(
            servicePath,
            productPlantQualityMgmt,
            "A_ProductPlantQualityMgmt");
    }

    @Override
    @Nonnull
    public ProductPlantQualityMgmtUpdateFluentHelper updateProductPlantQualityMgmt(
        @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt )
    {
        return new ProductPlantQualityMgmtUpdateFluentHelper(
            servicePath,
            productPlantQualityMgmt,
            "A_ProductPlantQualityMgmt");
    }

    @Override
    @Nonnull
    public ProductPlantSalesFluentHelper getAllProductPlantSales()
    {
        return new ProductPlantSalesFluentHelper(servicePath, "A_ProductPlantSales");
    }

    @Override
    @Nonnull
    public ProductPlantSalesByKeyFluentHelper getProductPlantSalesByKey( final String product, final String plant )
    {
        return new ProductPlantSalesByKeyFluentHelper(servicePath, "A_ProductPlantSales", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantSalesCreateFluentHelper createProductPlantSales(
        @Nonnull final ProductPlantSales productPlantSales )
    {
        return new ProductPlantSalesCreateFluentHelper(servicePath, productPlantSales, "A_ProductPlantSales");
    }

    @Override
    @Nonnull
    public ProductPlantSalesUpdateFluentHelper updateProductPlantSales(
        @Nonnull final ProductPlantSales productPlantSales )
    {
        return new ProductPlantSalesUpdateFluentHelper(servicePath, productPlantSales, "A_ProductPlantSales");
    }

    @Override
    @Nonnull
    public ProductPlantStorageFluentHelper getAllProductPlantStorage()
    {
        return new ProductPlantStorageFluentHelper(servicePath, "A_ProductPlantStorage");
    }

    @Override
    @Nonnull
    public ProductPlantStorageByKeyFluentHelper getProductPlantStorageByKey( final String product, final String plant )
    {
        return new ProductPlantStorageByKeyFluentHelper(servicePath, "A_ProductPlantStorage", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantStorageCreateFluentHelper createProductPlantStorage(
        @Nonnull final ProductPlantStorage productPlantStorage )
    {
        return new ProductPlantStorageCreateFluentHelper(servicePath, productPlantStorage, "A_ProductPlantStorage");
    }

    @Override
    @Nonnull
    public ProductPlantStorageUpdateFluentHelper updateProductPlantStorage(
        @Nonnull final ProductPlantStorage productPlantStorage )
    {
        return new ProductPlantStorageUpdateFluentHelper(servicePath, productPlantStorage, "A_ProductPlantStorage");
    }

    @Override
    @Nonnull
    public ProductPlantTextFluentHelper getAllProductPlantText()
    {
        return new ProductPlantTextFluentHelper(servicePath, "A_ProductPlantText");
    }

    @Override
    @Nonnull
    public ProductPlantTextByKeyFluentHelper getProductPlantTextByKey( final String product, final String plant )
    {
        return new ProductPlantTextByKeyFluentHelper(servicePath, "A_ProductPlantText", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantTextCreateFluentHelper createProductPlantText( @Nonnull final ProductPlantText productPlantText )
    {
        return new ProductPlantTextCreateFluentHelper(servicePath, productPlantText, "A_ProductPlantText");
    }

    @Override
    @Nonnull
    public ProductPlantTextUpdateFluentHelper updateProductPlantText( @Nonnull final ProductPlantText productPlantText )
    {
        return new ProductPlantTextUpdateFluentHelper(servicePath, productPlantText, "A_ProductPlantText");
    }

    @Override
    @Nonnull
    public ProductPlantTextDeleteFluentHelper deleteProductPlantText( @Nonnull final ProductPlantText productPlantText )
    {
        return new ProductPlantTextDeleteFluentHelper(servicePath, productPlantText, "A_ProductPlantText");
    }

    @Override
    @Nonnull
    public ProductProcurementFluentHelper getAllProductProcurement()
    {
        return new ProductProcurementFluentHelper(servicePath, "A_ProductProcurement");
    }

    @Override
    @Nonnull
    public ProductProcurementByKeyFluentHelper getProductProcurementByKey( final String product )
    {
        return new ProductProcurementByKeyFluentHelper(servicePath, "A_ProductProcurement", product);
    }

    @Override
    @Nonnull
    public ProductProcurementCreateFluentHelper createProductProcurement(
        @Nonnull final ProductProcurement productProcurement )
    {
        return new ProductProcurementCreateFluentHelper(servicePath, productProcurement, "A_ProductProcurement");
    }

    @Override
    @Nonnull
    public ProductProcurementUpdateFluentHelper updateProductProcurement(
        @Nonnull final ProductProcurement productProcurement )
    {
        return new ProductProcurementUpdateFluentHelper(servicePath, productProcurement, "A_ProductProcurement");
    }

    @Override
    @Nonnull
    public ProductPurchaseTextFluentHelper getAllProductPurchaseText()
    {
        return new ProductPurchaseTextFluentHelper(servicePath, "A_ProductPurchaseText");
    }

    @Override
    @Nonnull
    public
        ProductPurchaseTextByKeyFluentHelper
        getProductPurchaseTextByKey( final String product, final String language )
    {
        return new ProductPurchaseTextByKeyFluentHelper(servicePath, "A_ProductPurchaseText", product, language);
    }

    @Override
    @Nonnull
    public ProductPurchaseTextCreateFluentHelper createProductPurchaseText(
        @Nonnull final ProductPurchaseText productPurchaseText )
    {
        return new ProductPurchaseTextCreateFluentHelper(servicePath, productPurchaseText, "A_ProductPurchaseText");
    }

    @Override
    @Nonnull
    public ProductPurchaseTextUpdateFluentHelper updateProductPurchaseText(
        @Nonnull final ProductPurchaseText productPurchaseText )
    {
        return new ProductPurchaseTextUpdateFluentHelper(servicePath, productPurchaseText, "A_ProductPurchaseText");
    }

    @Override
    @Nonnull
    public ProductPurchaseTextDeleteFluentHelper deleteProductPurchaseText(
        @Nonnull final ProductPurchaseText productPurchaseText )
    {
        return new ProductPurchaseTextDeleteFluentHelper(servicePath, productPurchaseText, "A_ProductPurchaseText");
    }

    @Override
    @Nonnull
    public ProductQualityMgmtFluentHelper getAllProductQualityMgmt()
    {
        return new ProductQualityMgmtFluentHelper(servicePath, "A_ProductQualityMgmt");
    }

    @Override
    @Nonnull
    public ProductQualityMgmtByKeyFluentHelper getProductQualityMgmtByKey( final String product )
    {
        return new ProductQualityMgmtByKeyFluentHelper(servicePath, "A_ProductQualityMgmt", product);
    }

    @Override
    @Nonnull
    public ProductQualityMgmtCreateFluentHelper createProductQualityMgmt(
        @Nonnull final ProductQualityMgmt productQualityMgmt )
    {
        return new ProductQualityMgmtCreateFluentHelper(servicePath, productQualityMgmt, "A_ProductQualityMgmt");
    }

    @Override
    @Nonnull
    public ProductQualityMgmtUpdateFluentHelper updateProductQualityMgmt(
        @Nonnull final ProductQualityMgmt productQualityMgmt )
    {
        return new ProductQualityMgmtUpdateFluentHelper(servicePath, productQualityMgmt, "A_ProductQualityMgmt");
    }

    @Override
    @Nonnull
    public ProductSalesFluentHelper getAllProductSales()
    {
        return new ProductSalesFluentHelper(servicePath, "A_ProductSales");
    }

    @Override
    @Nonnull
    public ProductSalesByKeyFluentHelper getProductSalesByKey( final String product )
    {
        return new ProductSalesByKeyFluentHelper(servicePath, "A_ProductSales", product);
    }

    @Override
    @Nonnull
    public ProductSalesCreateFluentHelper createProductSales( @Nonnull final ProductSales productSales )
    {
        return new ProductSalesCreateFluentHelper(servicePath, productSales, "A_ProductSales");
    }

    @Override
    @Nonnull
    public ProductSalesUpdateFluentHelper updateProductSales( @Nonnull final ProductSales productSales )
    {
        return new ProductSalesUpdateFluentHelper(servicePath, productSales, "A_ProductSales");
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryFluentHelper getAllProductSalesDelivery()
    {
        return new ProductSalesDeliveryFluentHelper(servicePath, "A_ProductSalesDelivery");
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryByKeyFluentHelper getProductSalesDeliveryByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl )
    {
        return new ProductSalesDeliveryByKeyFluentHelper(
            servicePath,
            "A_ProductSalesDelivery",
            product,
            productSalesOrg,
            productDistributionChnl);
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryCreateFluentHelper createProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return new ProductSalesDeliveryCreateFluentHelper(servicePath, productSalesDelivery, "A_ProductSalesDelivery");
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryUpdateFluentHelper updateProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return new ProductSalesDeliveryUpdateFluentHelper(servicePath, productSalesDelivery, "A_ProductSalesDelivery");
    }

    @Override
    @Nonnull
    public ProductSalesTaxFluentHelper getAllProductSalesTax()
    {
        return new ProductSalesTaxFluentHelper(servicePath, "A_ProductSalesTax");
    }

    @Override
    @Nonnull
    public ProductSalesTaxByKeyFluentHelper getProductSalesTaxByKey(
        final String product,
        final String country,
        final String taxCategory,
        final String taxClassification )
    {
        return new ProductSalesTaxByKeyFluentHelper(
            servicePath,
            "A_ProductSalesTax",
            product,
            country,
            taxCategory,
            taxClassification);
    }

    @Override
    @Nonnull
    public ProductSalesTaxCreateFluentHelper createProductSalesTax( @Nonnull final ProductSalesTax productSalesTax )
    {
        return new ProductSalesTaxCreateFluentHelper(servicePath, productSalesTax, "A_ProductSalesTax");
    }

    @Override
    @Nonnull
    public ProductSalesTaxUpdateFluentHelper updateProductSalesTax( @Nonnull final ProductSalesTax productSalesTax )
    {
        return new ProductSalesTaxUpdateFluentHelper(servicePath, productSalesTax, "A_ProductSalesTax");
    }

    @Override
    @Nonnull
    public ProductSalesTaxDeleteFluentHelper deleteProductSalesTax( @Nonnull final ProductSalesTax productSalesTax )
    {
        return new ProductSalesTaxDeleteFluentHelper(servicePath, productSalesTax, "A_ProductSalesTax");
    }

    @Override
    @Nonnull
    public ProductSalesTextFluentHelper getAllProductSalesText()
    {
        return new ProductSalesTextFluentHelper(servicePath, "A_ProductSalesText");
    }

    @Override
    @Nonnull
    public ProductSalesTextByKeyFluentHelper getProductSalesTextByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl,
        final String language )
    {
        return new ProductSalesTextByKeyFluentHelper(
            servicePath,
            "A_ProductSalesText",
            product,
            productSalesOrg,
            productDistributionChnl,
            language);
    }

    @Override
    @Nonnull
    public ProductSalesTextCreateFluentHelper createProductSalesText( @Nonnull final ProductSalesText productSalesText )
    {
        return new ProductSalesTextCreateFluentHelper(servicePath, productSalesText, "A_ProductSalesText");
    }

    @Override
    @Nonnull
    public ProductSalesTextUpdateFluentHelper updateProductSalesText( @Nonnull final ProductSalesText productSalesText )
    {
        return new ProductSalesTextUpdateFluentHelper(servicePath, productSalesText, "A_ProductSalesText");
    }

    @Override
    @Nonnull
    public ProductSalesTextDeleteFluentHelper deleteProductSalesText( @Nonnull final ProductSalesText productSalesText )
    {
        return new ProductSalesTextDeleteFluentHelper(servicePath, productSalesText, "A_ProductSalesText");
    }

    @Override
    @Nonnull
    public ProductStorageFluentHelper getAllProductStorage()
    {
        return new ProductStorageFluentHelper(servicePath, "A_ProductStorage");
    }

    @Override
    @Nonnull
    public ProductStorageByKeyFluentHelper getProductStorageByKey( final String product )
    {
        return new ProductStorageByKeyFluentHelper(servicePath, "A_ProductStorage", product);
    }

    @Override
    @Nonnull
    public ProductStorageCreateFluentHelper createProductStorage( @Nonnull final ProductStorage productStorage )
    {
        return new ProductStorageCreateFluentHelper(servicePath, productStorage, "A_ProductStorage");
    }

    @Override
    @Nonnull
    public ProductStorageUpdateFluentHelper updateProductStorage( @Nonnull final ProductStorage productStorage )
    {
        return new ProductStorageUpdateFluentHelper(servicePath, productStorage, "A_ProductStorage");
    }

    @Override
    @Nonnull
    public ProductStorageLocationFluentHelper getAllProductStorageLocation()
    {
        return new ProductStorageLocationFluentHelper(servicePath, "A_ProductStorageLocation");
    }

    @Override
    @Nonnull
    public
        ProductStorageLocationByKeyFluentHelper
        getProductStorageLocationByKey( final String product, final String plant, final String storageLocation )
    {
        return new ProductStorageLocationByKeyFluentHelper(
            servicePath,
            "A_ProductStorageLocation",
            product,
            plant,
            storageLocation);
    }

    @Override
    @Nonnull
    public ProductStorageLocationCreateFluentHelper createProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return new ProductStorageLocationCreateFluentHelper(
            servicePath,
            productStorageLocation,
            "A_ProductStorageLocation");
    }

    @Override
    @Nonnull
    public ProductStorageLocationUpdateFluentHelper updateProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return new ProductStorageLocationUpdateFluentHelper(
            servicePath,
            productStorageLocation,
            "A_ProductStorageLocation");
    }

    @Override
    @Nonnull
    public ProductSupplyPlanningFluentHelper getAllProductSupplyPlanning()
    {
        return new ProductSupplyPlanningFluentHelper(servicePath, "A_ProductSupplyPlanning");
    }

    @Override
    @Nonnull
    public
        ProductSupplyPlanningByKeyFluentHelper
        getProductSupplyPlanningByKey( final String product, final String plant )
    {
        return new ProductSupplyPlanningByKeyFluentHelper(servicePath, "A_ProductSupplyPlanning", product, plant);
    }

    @Override
    @Nonnull
    public ProductSupplyPlanningCreateFluentHelper createProductSupplyPlanning(
        @Nonnull final ProductSupplyPlanning productSupplyPlanning )
    {
        return new ProductSupplyPlanningCreateFluentHelper(
            servicePath,
            productSupplyPlanning,
            "A_ProductSupplyPlanning");
    }

    @Override
    @Nonnull
    public ProductSupplyPlanningUpdateFluentHelper updateProductSupplyPlanning(
        @Nonnull final ProductSupplyPlanning productSupplyPlanning )
    {
        return new ProductSupplyPlanningUpdateFluentHelper(
            servicePath,
            productSupplyPlanning,
            "A_ProductSupplyPlanning");
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureFluentHelper getAllProductUnitsOfMeasure()
    {
        return new ProductUnitsOfMeasureFluentHelper(servicePath, "A_ProductUnitsOfMeasure");
    }

    @Override
    @Nonnull
    public
        ProductUnitsOfMeasureByKeyFluentHelper
        getProductUnitsOfMeasureByKey( final String product, final String alternativeUnit )
    {
        return new ProductUnitsOfMeasureByKeyFluentHelper(
            servicePath,
            "A_ProductUnitsOfMeasure",
            product,
            alternativeUnit);
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureCreateFluentHelper createProductUnitsOfMeasure(
        @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure )
    {
        return new ProductUnitsOfMeasureCreateFluentHelper(
            servicePath,
            productUnitsOfMeasure,
            "A_ProductUnitsOfMeasure");
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureUpdateFluentHelper updateProductUnitsOfMeasure(
        @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure )
    {
        return new ProductUnitsOfMeasureUpdateFluentHelper(
            servicePath,
            productUnitsOfMeasure,
            "A_ProductUnitsOfMeasure");
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureDeleteFluentHelper deleteProductUnitsOfMeasure(
        @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure )
    {
        return new ProductUnitsOfMeasureDeleteFluentHelper(
            servicePath,
            productUnitsOfMeasure,
            "A_ProductUnitsOfMeasure");
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureEANFluentHelper getAllProductUnitsOfMeasureEAN()
    {
        return new ProductUnitsOfMeasureEANFluentHelper(servicePath, "A_ProductUnitsOfMeasureEAN");
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureEANByKeyFluentHelper getProductUnitsOfMeasureEANByKey(
        final String product,
        final String alternativeUnit,
        final String consecutiveNumber )
    {
        return new ProductUnitsOfMeasureEANByKeyFluentHelper(
            servicePath,
            "A_ProductUnitsOfMeasureEAN",
            product,
            alternativeUnit,
            consecutiveNumber);
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureEANCreateFluentHelper createProductUnitsOfMeasureEAN(
        @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN )
    {
        return new ProductUnitsOfMeasureEANCreateFluentHelper(
            servicePath,
            productUnitsOfMeasureEAN,
            "A_ProductUnitsOfMeasureEAN");
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureEANUpdateFluentHelper updateProductUnitsOfMeasureEAN(
        @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN )
    {
        return new ProductUnitsOfMeasureEANUpdateFluentHelper(
            servicePath,
            productUnitsOfMeasureEAN,
            "A_ProductUnitsOfMeasureEAN");
    }

    @Override
    @Nonnull
    public ProductUnitsOfMeasureEANDeleteFluentHelper deleteProductUnitsOfMeasureEAN(
        @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN )
    {
        return new ProductUnitsOfMeasureEANDeleteFluentHelper(
            servicePath,
            productUnitsOfMeasureEAN,
            "A_ProductUnitsOfMeasureEAN");
    }

    @Override
    @Nonnull
    public ProductValuationFluentHelper getAllProductValuation()
    {
        return new ProductValuationFluentHelper(servicePath, "A_ProductValuation");
    }

    @Override
    @Nonnull
    public
        ProductValuationByKeyFluentHelper
        getProductValuationByKey( final String product, final String valuationArea, final String valuationType )
    {
        return new ProductValuationByKeyFluentHelper(
            servicePath,
            "A_ProductValuation",
            product,
            valuationArea,
            valuationType);
    }

    @Override
    @Nonnull
    public ProductValuationCreateFluentHelper createProductValuation( @Nonnull final ProductValuation productValuation )
    {
        return new ProductValuationCreateFluentHelper(servicePath, productValuation, "A_ProductValuation");
    }

    @Override
    @Nonnull
    public ProductValuationUpdateFluentHelper updateProductValuation( @Nonnull final ProductValuation productValuation )
    {
        return new ProductValuationUpdateFluentHelper(servicePath, productValuation, "A_ProductValuation");
    }

    @Override
    @Nonnull
    public ProductValuationAccountFluentHelper getAllProductValuationAccount()
    {
        return new ProductValuationAccountFluentHelper(servicePath, "A_ProductValuationAccount");
    }

    @Override
    @Nonnull
    public
        ProductValuationAccountByKeyFluentHelper
        getProductValuationAccountByKey( final String product, final String valuationArea, final String valuationType )
    {
        return new ProductValuationAccountByKeyFluentHelper(
            servicePath,
            "A_ProductValuationAccount",
            product,
            valuationArea,
            valuationType);
    }

    @Override
    @Nonnull
    public ProductValuationAccountCreateFluentHelper createProductValuationAccount(
        @Nonnull final ProductValuationAccount productValuationAccount )
    {
        return new ProductValuationAccountCreateFluentHelper(
            servicePath,
            productValuationAccount,
            "A_ProductValuationAccount");
    }

    @Override
    @Nonnull
    public ProductValuationAccountUpdateFluentHelper updateProductValuationAccount(
        @Nonnull final ProductValuationAccount productValuationAccount )
    {
        return new ProductValuationAccountUpdateFluentHelper(
            servicePath,
            productValuationAccount,
            "A_ProductValuationAccount");
    }

    @Override
    @Nonnull
    public ProductValuationCostingFluentHelper getAllProductValuationCosting()
    {
        return new ProductValuationCostingFluentHelper(servicePath, "A_ProductValuationCosting");
    }

    @Override
    @Nonnull
    public
        ProductValuationCostingByKeyFluentHelper
        getProductValuationCostingByKey( final String product, final String valuationArea, final String valuationType )
    {
        return new ProductValuationCostingByKeyFluentHelper(
            servicePath,
            "A_ProductValuationCosting",
            product,
            valuationArea,
            valuationType);
    }

    @Override
    @Nonnull
    public ProductValuationCostingCreateFluentHelper createProductValuationCosting(
        @Nonnull final ProductValuationCosting productValuationCosting )
    {
        return new ProductValuationCostingCreateFluentHelper(
            servicePath,
            productValuationCosting,
            "A_ProductValuationCosting");
    }

    @Override
    @Nonnull
    public ProductValuationCostingUpdateFluentHelper updateProductValuationCosting(
        @Nonnull final ProductValuationCosting productValuationCosting )
    {
        return new ProductValuationCostingUpdateFluentHelper(
            servicePath,
            productValuationCosting,
            "A_ProductValuationCosting");
    }

    @Override
    @Nonnull
    public ProductWorkSchedulingFluentHelper getAllProductWorkScheduling()
    {
        return new ProductWorkSchedulingFluentHelper(servicePath, "A_ProductWorkScheduling");
    }

    @Override
    @Nonnull
    public
        ProductWorkSchedulingByKeyFluentHelper
        getProductWorkSchedulingByKey( final String product, final String plant )
    {
        return new ProductWorkSchedulingByKeyFluentHelper(servicePath, "A_ProductWorkScheduling", product, plant);
    }

    @Override
    @Nonnull
    public ProductWorkSchedulingCreateFluentHelper createProductWorkScheduling(
        @Nonnull final ProductWorkScheduling productWorkScheduling )
    {
        return new ProductWorkSchedulingCreateFluentHelper(
            servicePath,
            productWorkScheduling,
            "A_ProductWorkScheduling");
    }

    @Override
    @Nonnull
    public ProductWorkSchedulingUpdateFluentHelper updateProductWorkScheduling(
        @Nonnull final ProductWorkScheduling productWorkScheduling )
    {
        return new ProductWorkSchedulingUpdateFluentHelper(
            servicePath,
            productWorkScheduling,
            "A_ProductWorkScheduling");
    }

}
