/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.batch.DefaultProductStructureServiceBatch;

/**
 * <p>
 *
 * The service enables you to read the product structure information including the product structure nodes and product
 * structure variants. The service contains two filters, one for node and one for variant..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/10/398dac8fd1480185cdf55ab2a85fc1/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_STRUCTURE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_STRUCTURE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>(Deprecated) Product Lifecycle Management - Product Structure Integration(SAP_COM_0346)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3ND'>Product Structure Management(3ND)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product Structure</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2008 (Aug 2020). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductStructureService" )
@Deprecated
public class DefaultProductStructureService implements ProductStructureService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductStructureService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductStructureService()
    {
        servicePath = ProductStructureService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductStructureService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductStructureService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductStructureService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductStructureServiceBatch batch()
    {
        return new DefaultProductStructureServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductStructureNodeFluentHelper getAllProductStructureNode()
    {
        return new ProductStructureNodeFluentHelper(servicePath, "A_ProductStructureNode");
    }

    @Override
    @Nonnull
    public ProductStructureNodeByKeyFluentHelper getProductStructureNodeByKey( final UUID productStructureNodeUUID )
    {
        return new ProductStructureNodeByKeyFluentHelper(
            servicePath,
            "A_ProductStructureNode",
            productStructureNodeUUID);
    }

    @Override
    @Nonnull
    public ProductStructureVariantFluentHelper getAllProductStructureVariant()
    {
        return new ProductStructureVariantFluentHelper(servicePath, "A_ProductStructureVariant");
    }

    @Override
    @Nonnull
    public ProductStructureVariantByKeyFluentHelper getProductStructureVariantByKey(
        final UUID productStructureVariantUUID,
        final String prodStrucVariantChgStateIntID )
    {
        return new ProductStructureVariantByKeyFluentHelper(
            servicePath,
            "A_ProductStructureVariant",
            productStructureVariantUUID,
            prodStrucVariantChgStateIntID);
    }

}
