/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.CancelProdnOrdConfFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.GetConfProposalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.GetGdsMvtProposalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConf2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItm;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItmCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrdConfMatlDocItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrderConfBatchCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.ProdnOrderConfBatchCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderconfirmationv2.batch.DefaultProductionOrderConfirmationV2ServiceBatch;

/**
 * <p>
 * You can create time ticket and time event confirmations as well as confirmations on order level, read them, and
 * cancel the confirmations on time ticket, time event, or order level. Before creating a confirmation, you can fetch
 * the proposed data for quantities, work activities, dates and times, personnel data, and goods movements depending on
 * the type of confirmation.
 *
 * Note
 *
 * The following operations are available on the API Reference tab but are not supported by this API: - POST
 * /ProdnOrdConf2(ConfirmationGroup=&#39;{ConfirmationGroup}&#39;,ConfirmationCount=&#39;{ConfirmationCount}&#39;,/to_ProdnOrdConfMatlDocItm
 * - POST
 * /ProdnOrdConfMatlDocItm(ConfirmationGroup=&#39;{ConfirmationGroup}&#39;,ConfirmationCount=&#39;{ConfirmationCount}&#39;,MaterialDocument=&#39;{MaterialDocument}&#39;,MaterialDocumentItem=&#39;{MaterialDocumentItem}&#39;,MaterialDocumentYear=&#39;{MaterialDocumentYear}&#39;,/to_ProdnOrderConfBatchCharc
 * .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e7/7b762e243b4045ad1f1f048f6aab87/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROD_ORDER_CONFIRMATION_2_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROD_ORDER_CONFIRMATION_2_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Order Confirmation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductionOrderConfirmationV2Service" )
@Deprecated
public class DefaultProductionOrderConfirmationV2Service implements ProductionOrderConfirmationV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductionOrderConfirmationV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductionOrderConfirmationV2Service()
    {
        servicePath = ProductionOrderConfirmationV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductionOrderConfirmationV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductionOrderConfirmationV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductionOrderConfirmationV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductionOrderConfirmationV2ServiceBatch batch()
    {
        return new DefaultProductionOrderConfirmationV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProdnOrdConfMatlDocItmFluentHelper getAllProdnOrdConfMatlDocItm()
    {
        return new ProdnOrdConfMatlDocItmFluentHelper(servicePath, "ProdnOrdConfMatlDocItm");
    }

    @Override
    @Nonnull
    public ProdnOrdConfMatlDocItmByKeyFluentHelper getProdnOrdConfMatlDocItmByKey(
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear )
    {
        return new ProdnOrdConfMatlDocItmByKeyFluentHelper(
            servicePath,
            "ProdnOrdConfMatlDocItm",
            confirmationGroup,
            confirmationCount,
            materialDocument,
            materialDocumentItem,
            materialDocumentYear);
    }

    @Override
    @Nonnull
    public ProdnOrdConfMatlDocItmCreateFluentHelper createProdnOrdConfMatlDocItm(
        @Nonnull final ProdnOrdConfMatlDocItm prodnOrdConfMatlDocItm )
    {
        return new ProdnOrdConfMatlDocItmCreateFluentHelper(
            servicePath,
            prodnOrdConfMatlDocItm,
            "ProdnOrdConfMatlDocItm");
    }

    @Override
    @Nonnull
    public ProdnOrderConfBatchCharcFluentHelper getAllProdnOrderConfBatchCharc()
    {
        return new ProdnOrderConfBatchCharcFluentHelper(servicePath, "ProdnOrderConfBatchCharc");
    }

    @Override
    @Nonnull
    public ProdnOrderConfBatchCharcByKeyFluentHelper getProdnOrderConfBatchCharcByKey(
        final String confirmationGroup,
        final String confirmationCount,
        final String materialDocument,
        final String materialDocumentItem,
        final String materialDocumentYear,
        final String plant,
        final String material,
        final String batch,
        final String charcInternalID )
    {
        return new ProdnOrderConfBatchCharcByKeyFluentHelper(
            servicePath,
            "ProdnOrderConfBatchCharc",
            confirmationGroup,
            confirmationCount,
            materialDocument,
            materialDocumentItem,
            materialDocumentYear,
            plant,
            material,
            batch,
            charcInternalID);
    }

    @Override
    @Nonnull
    public ProdnOrdConf2FluentHelper getAllProdnOrdConf2()
    {
        return new ProdnOrdConf2FluentHelper(servicePath, "ProdnOrdConf2");
    }

    @Override
    @Nonnull
    public
        ProdnOrdConf2ByKeyFluentHelper
        getProdnOrdConf2ByKey( final String confirmationGroup, final String confirmationCount )
    {
        return new ProdnOrdConf2ByKeyFluentHelper(servicePath, "ProdnOrdConf2", confirmationGroup, confirmationCount);
    }

    @Override
    @Nonnull
    public ProdnOrdConf2CreateFluentHelper createProdnOrdConf2( @Nonnull final ProdnOrdConf2 prodnOrdConf2 )
    {
        return new ProdnOrdConf2CreateFluentHelper(servicePath, prodnOrdConf2, "ProdnOrdConf2");
    }

    @Override
    @Nonnull
    public CancelProdnOrdConfFluentHelper cancelProdnOrdConf(
        @Nonnull final String confirmationGroup,
        @Nonnull final String confirmationCount,
        @Nullable final LocalDateTime postingDate,
        @Nullable final String confirmationText,
        @Nullable final UUID externalSystemConfirmation )
    {
        return new CancelProdnOrdConfFluentHelper(
            servicePath,
            confirmationGroup,
            confirmationCount,
            postingDate,
            confirmationText,
            externalSystemConfirmation);
    }

    @Override
    @Nonnull
    public GetConfProposalFluentHelper getConfProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String sequence,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final BigDecimal confirmationReworkQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed )
    {
        return new GetConfProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            sequence,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            confirmationReworkQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed);
    }

    @Override
    @Nonnull
    public GetConfProposalFluentHelper getConfProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String sequence,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final BigDecimal confirmationReworkQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed,
        @Nullable final String confirmationUnitSAPCode )
    {
        return new GetConfProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            sequence,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            confirmationReworkQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed,
            confirmationUnitSAPCode);
    }

    @Override
    @Nonnull
    public GetGdsMvtProposalFluentHelper getGdsMvtProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String sequence,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final BigDecimal confirmationReworkQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed )
    {
        return new GetGdsMvtProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            sequence,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            confirmationReworkQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed);
    }

    @Override
    @Nonnull
    public GetGdsMvtProposalFluentHelper getGdsMvtProposal(
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String sequence,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final BigDecimal confirmationReworkQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed,
        @Nullable final String confirmationUnitSAPCode )
    {
        return new GetGdsMvtProposalFluentHelper(
            servicePath,
            confirmationGroup,
            orderID,
            orderOperation,
            sequence,
            orderSuboperation,
            orderConfirmationRecordType,
            confirmationUnit,
            confirmationUnitISOCode,
            confirmationYieldQuantity,
            confirmationScrapQuantity,
            confirmationReworkQuantity,
            quantityIsToBeProposed,
            activityIsToBeProposed,
            dateAndTimeIsToBeProposed,
            personnelIsToBeProposed,
            confirmationUnitSAPCode);
    }

}
