/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.CloseProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.CompleteTechnicallyProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ConvertPlannedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.DiscardOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceToolsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceToolsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseProductionOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseProductionOrderOprFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ScheduleProductionOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.SetDeltnFlagProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.SetDeltnIndProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.batch.DefaultProductionOrderServiceBatch;

/**
 * <p>
 * In addition to create, read, and update, you can also release production orders and operations. This service also
 * enables you to schedule production order operations, technically complete and close production orders as well as set
 * the deletion flag and deletion indicator.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/32/b13458b222a107e10000000a441470/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTION_ORDERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTION_ORDERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2002 (Feb 2020). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductionOrderService" )
@Deprecated
public class DefaultProductionOrderService implements ProductionOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductionOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductionOrderService()
    {
        servicePath = ProductionOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductionOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductionOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductionOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductionOrderServiceBatch batch()
    {
        return new DefaultProductionOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductionOrderFluentHelper getAllProductionOrder()
    {
        return new ProductionOrderFluentHelper(servicePath, "A_ProductionOrder");
    }

    @Override
    @Nonnull
    public ProductionOrderByKeyFluentHelper getProductionOrderByKey( final String productionOrder )
    {
        return new ProductionOrderByKeyFluentHelper(servicePath, "A_ProductionOrder", productionOrder);
    }

    @Override
    @Nonnull
    public ProductionOrderCreateFluentHelper createProductionOrder( @Nonnull final ProductionOrder productionOrder )
    {
        return new ProductionOrderCreateFluentHelper(servicePath, productionOrder, "A_ProductionOrder");
    }

    @Override
    @Nonnull
    public ProductionOrderUpdateFluentHelper updateProductionOrder( @Nonnull final ProductionOrder productionOrder )
    {
        return new ProductionOrderUpdateFluentHelper(servicePath, productionOrder, "A_ProductionOrder");
    }

    @Override
    @Nonnull
    public ProductionOrderComponentFluentHelper getAllProductionOrderComponent()
    {
        return new ProductionOrderComponentFluentHelper(servicePath, "A_ProductionOrderComponent");
    }

    @Override
    @Nonnull
    public
        ProductionOrderComponentByKeyFluentHelper
        getProductionOrderComponentByKey( final String reservation, final String reservationItem )
    {
        return new ProductionOrderComponentByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderComponent",
            reservation,
            reservationItem);
    }

    @Override
    @Nonnull
    public ProductionOrderItemFluentHelper getAllProductionOrderItem()
    {
        return new ProductionOrderItemFluentHelper(servicePath, "A_ProductionOrderItem");
    }

    @Override
    @Nonnull
    public
        ProductionOrderItemByKeyFluentHelper
        getProductionOrderItemByKey( final String manufacturingOrder, final String manufacturingOrderItem )
    {
        return new ProductionOrderItemByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderItem",
            manufacturingOrder,
            manufacturingOrderItem);
    }

    @Override
    @Nonnull
    public ProductionOrderOperationFluentHelper getAllProductionOrderOperation()
    {
        return new ProductionOrderOperationFluentHelper(servicePath, "A_ProductionOrderOperation");
    }

    @Override
    @Nonnull
    public ProductionOrderOperationByKeyFluentHelper getProductionOrderOperationByKey(
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem )
    {
        return new ProductionOrderOperationByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderOperation",
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem);
    }

    @Override
    @Nonnull
    public ProductionOrderStatusFluentHelper getAllProductionOrderStatus()
    {
        return new ProductionOrderStatusFluentHelper(servicePath, "A_ProductionOrderStatus");
    }

    @Override
    @Nonnull
    public
        ProductionOrderStatusByKeyFluentHelper
        getProductionOrderStatusByKey( final String manufacturingOrder, final String statusCode )
    {
        return new ProductionOrderStatusByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderStatus",
            manufacturingOrder,
            statusCode);
    }

    @Override
    @Nonnull
    public ProductionRsceToolsFluentHelper getAllProductionRsceTools()
    {
        return new ProductionRsceToolsFluentHelper(servicePath, "A_ProductionRsceTools");
    }

    @Override
    @Nonnull
    public ProductionRsceToolsByKeyFluentHelper getProductionRsceToolsByKey(
        final String orderInternalBillOfOperations,
        final String mfgOrderOpProdnRsceToolIntID )
    {
        return new ProductionRsceToolsByKeyFluentHelper(
            servicePath,
            "A_ProductionRsceTools",
            orderInternalBillOfOperations,
            mfgOrderOpProdnRsceToolIntID);
    }

    @Override
    @Nonnull
    public ReleaseProductionOrderFluentHelper releaseProductionOrder( @Nonnull final String manufacturingOrder )
    {
        return new ReleaseProductionOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public ReleaseProductionOrderOprFluentHelper releaseProductionOrderOpr(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String manufacturingOrderOperation )
    {
        return new ReleaseProductionOrderOprFluentHelper(servicePath, manufacturingOrder, manufacturingOrderOperation);
    }

    @Override
    @Nonnull
    public CompleteTechnicallyProdnOrdFluentHelper completeTechnicallyProdnOrd(
        @Nonnull final String manufacturingOrder )
    {
        return new CompleteTechnicallyProdnOrdFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public CloseProdnOrdFluentHelper closeProdnOrd( @Nonnull final String manufacturingOrder )
    {
        return new CloseProdnOrdFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public SetDeltnFlagProdnOrdFluentHelper setDeltnFlagProdnOrd( @Nonnull final String manufacturingOrder )
    {
        return new SetDeltnFlagProdnOrdFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public SetDeltnIndProdnOrdFluentHelper setDeltnIndProdnOrd( @Nonnull final String manufacturingOrder )
    {
        return new SetDeltnIndProdnOrdFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DiscardOrderFluentHelper discardOrder( @Nonnull final String manufacturingOrder )
    {
        return new DiscardOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public ConvertPlannedOrderFluentHelper convertPlannedOrder(
        @Nonnull final String plannedOrder,
        @Nullable final String manufacturingOrderType,
        @Nullable final String manufacturingOrder )
    {
        return new ConvertPlannedOrderFluentHelper(
            servicePath,
            plannedOrder,
            manufacturingOrderType,
            manufacturingOrder);
    }

    @Override
    @Nonnull
    public ScheduleProductionOrderOperationFluentHelper scheduleProductionOrderOperation(
        @Nonnull final String productionOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy )
    {
        return new ScheduleProductionOrderOperationFluentHelper(
            servicePath,
            productionOrder,
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem,
            opSchedldStartDate,
            opSchedldStartTime,
            opSchedldEndDate,
            opSchedldEndTime,
            opSchedulingMode,
            opSchedulingStatus,
            opSchedulingStrategy);
    }

}
