/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.CloseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ConvertPlndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeletionFlagOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeletionIndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeliveryCompletedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DiscardOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.OrderReleasedByMESFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ReleaseOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ReleaseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ScheduleProductionOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.TechlyCmpltOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.batch.DefaultProductionOrderV2ServiceBatch;

/**
 * <p>
 * In addition to create, read, and update production orders, you can also release orders and operations. Besides
 * updating header data of the order including the scheduling type, you can also update some properties of the order
 * components. This service enables you to convert planned orders to production orders, schedule production order
 * operations, and set further statuses for the order such as technically completed, closed, discarded by MES, or
 * released by MES. In addition, you can set the deletion flag, deletion indicator, and delivery completed indicator.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/0a/4262096d2e43258df27c594bdd1468/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTION_ORDER_2_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTION_ORDER_2_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductionOrderV2Service" )
@Deprecated
public class DefaultProductionOrderV2Service implements ProductionOrderV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductionOrderV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductionOrderV2Service()
    {
        servicePath = ProductionOrderV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductionOrderV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductionOrderV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductionOrderV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductionOrderV2ServiceBatch batch()
    {
        return new DefaultProductionOrderV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductionOrderComponent_2FluentHelper getAllProductionOrderComponent_2()
    {
        return new ProductionOrderComponent_2FluentHelper(servicePath, "A_ProductionOrderComponent_2");
    }

    @Override
    @Nonnull
    public
        ProductionOrderComponent_2ByKeyFluentHelper
        getProductionOrderComponent_2ByKey( final String reservation, final String reservationItem )
    {
        return new ProductionOrderComponent_2ByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderComponent_2",
            reservation,
            reservationItem);
    }

    @Override
    @Nonnull
    public ProductionOrderComponent_3FluentHelper getAllProductionOrderComponent_3()
    {
        return new ProductionOrderComponent_3FluentHelper(servicePath, "A_ProductionOrderComponent_3");
    }

    @Override
    @Nonnull
    public ProductionOrderComponent_3ByKeyFluentHelper getProductionOrderComponent_3ByKey(
        final String reservation,
        final String reservationItem,
        final String reservationRecordType )
    {
        return new ProductionOrderComponent_3ByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderComponent_3",
            reservation,
            reservationItem,
            reservationRecordType);
    }

    @Override
    @Nonnull
    public ProductionOrderComponent_3UpdateFluentHelper updateProductionOrderComponent_3(
        @Nonnull final ProductionOrderComponent_3 productionOrderComponent_3 )
    {
        return new ProductionOrderComponent_3UpdateFluentHelper(
            servicePath,
            productionOrderComponent_3,
            "A_ProductionOrderComponent_3");
    }

    @Override
    @Nonnull
    public ProductionOrderComponent_4FluentHelper getAllProductionOrderComponent_4()
    {
        return new ProductionOrderComponent_4FluentHelper(servicePath, "A_ProductionOrderComponent_4");
    }

    @Override
    @Nonnull
    public ProductionOrderComponent_4ByKeyFluentHelper getProductionOrderComponent_4ByKey(
        final String reservation,
        final String reservationItem,
        final String reservationRecordType )
    {
        return new ProductionOrderComponent_4ByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderComponent_4",
            reservation,
            reservationItem,
            reservationRecordType);
    }

    @Override
    @Nonnull
    public ProductionOrderComponent_4UpdateFluentHelper updateProductionOrderComponent_4(
        @Nonnull final ProductionOrderComponent_4 productionOrderComponent_4 )
    {
        return new ProductionOrderComponent_4UpdateFluentHelper(
            servicePath,
            productionOrderComponent_4,
            "A_ProductionOrderComponent_4");
    }

    @Override
    @Nonnull
    public ProductionOrderItem_2FluentHelper getAllProductionOrderItem_2()
    {
        return new ProductionOrderItem_2FluentHelper(servicePath, "A_ProductionOrderItem_2");
    }

    @Override
    @Nonnull
    public
        ProductionOrderItem_2ByKeyFluentHelper
        getProductionOrderItem_2ByKey( final String manufacturingOrder, final String manufacturingOrderItem )
    {
        return new ProductionOrderItem_2ByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderItem_2",
            manufacturingOrder,
            manufacturingOrderItem);
    }

    @Override
    @Nonnull
    public ProductionOrderOperation_2FluentHelper getAllProductionOrderOperation_2()
    {
        return new ProductionOrderOperation_2FluentHelper(servicePath, "A_ProductionOrderOperation_2");
    }

    @Override
    @Nonnull
    public ProductionOrderOperation_2ByKeyFluentHelper getProductionOrderOperation_2ByKey(
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem )
    {
        return new ProductionOrderOperation_2ByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderOperation_2",
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem);
    }

    @Override
    @Nonnull
    public ProductionOrderStatus_2FluentHelper getAllProductionOrderStatus_2()
    {
        return new ProductionOrderStatus_2FluentHelper(servicePath, "A_ProductionOrderStatus_2");
    }

    @Override
    @Nonnull
    public
        ProductionOrderStatus_2ByKeyFluentHelper
        getProductionOrderStatus_2ByKey( final String manufacturingOrder, final String statusCode )
    {
        return new ProductionOrderStatus_2ByKeyFluentHelper(
            servicePath,
            "A_ProductionOrderStatus_2",
            manufacturingOrder,
            statusCode);
    }

    @Override
    @Nonnull
    public ProductionOrder_2FluentHelper getAllProductionOrder_2()
    {
        return new ProductionOrder_2FluentHelper(servicePath, "A_ProductionOrder_2");
    }

    @Override
    @Nonnull
    public ProductionOrder_2ByKeyFluentHelper getProductionOrder_2ByKey( final String manufacturingOrder )
    {
        return new ProductionOrder_2ByKeyFluentHelper(servicePath, "A_ProductionOrder_2", manufacturingOrder);
    }

    @Override
    @Nonnull
    public ProductionOrder_2CreateFluentHelper createProductionOrder_2(
        @Nonnull final ProductionOrder_2 productionOrder_2 )
    {
        return new ProductionOrder_2CreateFluentHelper(servicePath, productionOrder_2, "A_ProductionOrder_2");
    }

    @Override
    @Nonnull
    public ProductionOrder_2UpdateFluentHelper updateProductionOrder_2(
        @Nonnull final ProductionOrder_2 productionOrder_2 )
    {
        return new ProductionOrder_2UpdateFluentHelper(servicePath, productionOrder_2, "A_ProductionOrder_2");
    }

    @Override
    @Nonnull
    public ProductionRsceTools_2FluentHelper getAllProductionRsceTools_2()
    {
        return new ProductionRsceTools_2FluentHelper(servicePath, "A_ProductionRsceTools_2");
    }

    @Override
    @Nonnull
    public ProductionRsceTools_2ByKeyFluentHelper getProductionRsceTools_2ByKey(
        final String orderInternalBillOfOperations,
        final String mfgOrderOpProdnRsceToolIntID )
    {
        return new ProductionRsceTools_2ByKeyFluentHelper(
            servicePath,
            "A_ProductionRsceTools_2",
            orderInternalBillOfOperations,
            mfgOrderOpProdnRsceToolIntID);
    }

    @Override
    @Nonnull
    public ReleaseOrderFluentHelper releaseOrder( @Nonnull final String manufacturingOrder )
    {
        return new ReleaseOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public ReleaseOperationFluentHelper releaseOperation(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String manufacturingOrderOperation,
        @Nonnull final String manufacturingOrderSequence )
    {
        return new ReleaseOperationFluentHelper(
            servicePath,
            manufacturingOrder,
            manufacturingOrderOperation,
            manufacturingOrderSequence);
    }

    @Override
    @Nonnull
    public TechlyCmpltOrderFluentHelper techlyCmpltOrder( @Nonnull final String manufacturingOrder )
    {
        return new TechlyCmpltOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public CloseOrderFluentHelper closeOrder( @Nonnull final String manufacturingOrder )
    {
        return new CloseOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DeletionFlagOrderFluentHelper deletionFlagOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeletionFlagOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DeletionIndOrderFluentHelper deletionIndOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeletionIndOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public DiscardOrderFluentHelper discardOrder( @Nonnull final String manufacturingOrder )
    {
        return new DiscardOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public ConvertPlndOrderFluentHelper convertPlndOrder(
        @Nullable final String manufacturingOrder,
        @Nonnull final String plannedOrder,
        @Nullable final String manufacturingOrderType )
    {
        return new ConvertPlndOrderFluentHelper(servicePath, manufacturingOrder, plannedOrder, manufacturingOrderType);
    }

    @Override
    @Nonnull
    public ScheduleProductionOrderOperationFluentHelper scheduleProductionOrderOperation(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy )
    {
        return new ScheduleProductionOrderOperationFluentHelper(
            servicePath,
            manufacturingOrder,
            orderInternalBillOfOperations,
            orderIntBillOfOperationsItem,
            opSchedldStartDate,
            opSchedldStartTime,
            opSchedldEndDate,
            opSchedldEndTime,
            opSchedulingMode,
            opSchedulingStatus,
            opSchedulingStrategy);
    }

    @Override
    @Nonnull
    public DeliveryCompletedOrderFluentHelper deliveryCompletedOrder( @Nonnull final String manufacturingOrder )
    {
        return new DeliveryCompletedOrderFluentHelper(servicePath, manufacturingOrder);
    }

    @Override
    @Nonnull
    public OrderReleasedByMESFluentHelper orderReleasedByMES( @Nonnull final String manufacturingOrder )
    {
        return new OrderReleasedByMESFluentHelper(servicePath, manufacturingOrder);
    }

}
