/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.batch.DefaultProductionRoutingServiceBatch;

/**
 * <p>
 *
 * A routing is a description of the operations (or steps in a process) that are performed to manufacture a product (or
 * material). It is used as a reference for production orders, to run schedules and in calculating the costs of
 * products..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2d/d233df3bc947d6b402d246ed887b5a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTION_ROUTING?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTION_ROUTING</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.2</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Master Data Integration(SAP_COM_0519)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Routing</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductionRoutingService" )
@Deprecated
public class DefaultProductionRoutingService implements ProductionRoutingService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductionRoutingService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductionRoutingService()
    {
        servicePath = ProductionRoutingService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductionRoutingService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductionRoutingService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductionRoutingService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductionRoutingServiceBatch batch()
    {
        return new DefaultProductionRoutingServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public OperationDocumentPRTAssignmentFluentHelper getAllOperationDocumentPRTAssignment()
    {
        return new OperationDocumentPRTAssignmentFluentHelper(servicePath, "OpDocumentPRTAssgmt");
    }

    @Override
    @Nonnull
    public OperationDocumentPRTAssignmentByKeyFluentHelper getOperationDocumentPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter )
    {
        return new OperationDocumentPRTAssignmentByKeyFluentHelper(
            servicePath,
            "OpDocumentPRTAssgmt",
            productionRoutingGroup,
            productionRouting,
            productionRoutingSequence,
            productionRoutingOpIntID,
            bOOOperationPRTInternalID,
            bOOOperationPRTIntVersCounter);
    }

    @Override
    @Nonnull
    public OperationEquipmentPRTAssignmentFluentHelper getAllOperationEquipmentPRTAssignment()
    {
        return new OperationEquipmentPRTAssignmentFluentHelper(servicePath, "OpEquipmentPRTAssgmt");
    }

    @Override
    @Nonnull
    public OperationEquipmentPRTAssignmentByKeyFluentHelper getOperationEquipmentPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter )
    {
        return new OperationEquipmentPRTAssignmentByKeyFluentHelper(
            servicePath,
            "OpEquipmentPRTAssgmt",
            productionRoutingGroup,
            productionRouting,
            productionRoutingSequence,
            productionRoutingOpIntID,
            bOOOperationPRTInternalID,
            bOOOperationPRTIntVersCounter);
    }

    @Override
    @Nonnull
    public OperationMaterialPRTAssignmentFluentHelper getAllOperationMaterialPRTAssignment()
    {
        return new OperationMaterialPRTAssignmentFluentHelper(servicePath, "OpMaterialPRTAssgmt");
    }

    @Override
    @Nonnull
    public OperationMaterialPRTAssignmentByKeyFluentHelper getOperationMaterialPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter )
    {
        return new OperationMaterialPRTAssignmentByKeyFluentHelper(
            servicePath,
            "OpMaterialPRTAssgmt",
            productionRoutingGroup,
            productionRouting,
            productionRoutingSequence,
            productionRoutingOpIntID,
            bOOOperationPRTInternalID,
            bOOOperationPRTIntVersCounter);
    }

    @Override
    @Nonnull
    public OperationMiscellaneousPRTAssignmentFluentHelper getAllOperationMiscellaneousPRTAssignment()
    {
        return new OperationMiscellaneousPRTAssignmentFluentHelper(servicePath, "OpMiscellaneousPRTAssgmt");
    }

    @Override
    @Nonnull
    public OperationMiscellaneousPRTAssignmentByKeyFluentHelper getOperationMiscellaneousPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter )
    {
        return new OperationMiscellaneousPRTAssignmentByKeyFluentHelper(
            servicePath,
            "OpMiscellaneousPRTAssgmt",
            productionRoutingGroup,
            productionRouting,
            productionRoutingSequence,
            productionRoutingOpIntID,
            bOOOperationPRTInternalID,
            bOOOperationPRTIntVersCounter);
    }

    @Override
    @Nonnull
    public ProductionRoutingHeaderFluentHelper getAllProductionRoutingHeader()
    {
        return new ProductionRoutingHeaderFluentHelper(servicePath, "ProductionRoutingHeader");
    }

    @Override
    @Nonnull
    public ProductionRoutingHeaderByKeyFluentHelper getProductionRoutingHeaderByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingInternalVers )
    {
        return new ProductionRoutingHeaderByKeyFluentHelper(
            servicePath,
            "ProductionRoutingHeader",
            productionRoutingGroup,
            productionRouting,
            productionRoutingInternalVers);
    }

    @Override
    @Nonnull
    public ProductionRoutingHeaderCreateFluentHelper createProductionRoutingHeader(
        @Nonnull final ProductionRoutingHeader productionRoutingHeader )
    {
        return new ProductionRoutingHeaderCreateFluentHelper(
            servicePath,
            productionRoutingHeader,
            "ProductionRoutingHeader");
    }

    @Override
    @Nonnull
    public ProductionRoutingHeaderUpdateFluentHelper updateProductionRoutingHeader(
        @Nonnull final ProductionRoutingHeader productionRoutingHeader )
    {
        return new ProductionRoutingHeaderUpdateFluentHelper(
            servicePath,
            productionRoutingHeader,
            "ProductionRoutingHeader");
    }

    @Override
    @Nonnull
    public ProductionRoutingMatlAssgmtFluentHelper getAllProductionRoutingMatlAssgmt()
    {
        return new ProductionRoutingMatlAssgmtFluentHelper(servicePath, "ProductionRoutingMatlAssgmt");
    }

    @Override
    @Nonnull
    public ProductionRoutingMatlAssgmtByKeyFluentHelper getProductionRoutingMatlAssgmtByKey(
        final String product,
        final String plant,
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingMatlAssgmt,
        final String productionRtgMatlAssgmtIntVers )
    {
        return new ProductionRoutingMatlAssgmtByKeyFluentHelper(
            servicePath,
            "ProductionRoutingMatlAssgmt",
            product,
            plant,
            productionRoutingGroup,
            productionRouting,
            productionRoutingMatlAssgmt,
            productionRtgMatlAssgmtIntVers);
    }

    @Override
    @Nonnull
    public ProductionRoutingOpCompAllocFluentHelper getAllProductionRoutingOpCompAlloc()
    {
        return new ProductionRoutingOpCompAllocFluentHelper(servicePath, "ProductionRoutingOpCompAlloc");
    }

    @Override
    @Nonnull
    public ProductionRoutingOpCompAllocByKeyFluentHelper getProductionRoutingOpCompAllocByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String prodnRtgOpBOMItemInternalID,
        final String prodnRtgOpBOMItemIntVersion )
    {
        return new ProductionRoutingOpCompAllocByKeyFluentHelper(
            servicePath,
            "ProductionRoutingOpCompAlloc",
            productionRoutingGroup,
            productionRouting,
            productionRoutingSequence,
            productionRoutingOpIntID,
            prodnRtgOpBOMItemInternalID,
            prodnRtgOpBOMItemIntVersion);
    }

    @Override
    @Nonnull
    public ProductionRoutingOpCompAllocCreateFluentHelper createProductionRoutingOpCompAlloc(
        @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc )
    {
        return new ProductionRoutingOpCompAllocCreateFluentHelper(
            servicePath,
            productionRoutingOpCompAlloc,
            "ProductionRoutingOpCompAlloc");
    }

    @Override
    @Nonnull
    public ProductionRoutingOpCompAllocUpdateFluentHelper updateProductionRoutingOpCompAlloc(
        @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc )
    {
        return new ProductionRoutingOpCompAllocUpdateFluentHelper(
            servicePath,
            productionRoutingOpCompAlloc,
            "ProductionRoutingOpCompAlloc");
    }

    @Override
    @Nonnull
    public ProductionRoutingOperationFluentHelper getAllProductionRoutingOperation()
    {
        return new ProductionRoutingOperationFluentHelper(servicePath, "ProductionRoutingOperation");
    }

    @Override
    @Nonnull
    public ProductionRoutingOperationByKeyFluentHelper getProductionRoutingOperationByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String productionRoutingOpIntVersion )
    {
        return new ProductionRoutingOperationByKeyFluentHelper(
            servicePath,
            "ProductionRoutingOperation",
            productionRoutingGroup,
            productionRouting,
            productionRoutingSequence,
            productionRoutingOpIntID,
            productionRoutingOpIntVersion);
    }

    @Override
    @Nonnull
    public ProductionRoutingOperationCreateFluentHelper createProductionRoutingOperation(
        @Nonnull final ProductionRoutingOperation productionRoutingOperation )
    {
        return new ProductionRoutingOperationCreateFluentHelper(
            servicePath,
            productionRoutingOperation,
            "ProductionRoutingOperation");
    }

    @Override
    @Nonnull
    public ProductionRoutingOperationUpdateFluentHelper updateProductionRoutingOperation(
        @Nonnull final ProductionRoutingOperation productionRoutingOperation )
    {
        return new ProductionRoutingOperationUpdateFluentHelper(
            servicePath,
            productionRoutingOperation,
            "ProductionRoutingOperation");
    }

    @Override
    @Nonnull
    public ProductionRoutingSequenceFluentHelper getAllProductionRoutingSequence()
    {
        return new ProductionRoutingSequenceFluentHelper(servicePath, "ProductionRoutingSequence");
    }

    @Override
    @Nonnull
    public ProductionRoutingSequenceByKeyFluentHelper getProductionRoutingSequenceByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingSqncIntVers )
    {
        return new ProductionRoutingSequenceByKeyFluentHelper(
            servicePath,
            "ProductionRoutingSequence",
            productionRoutingGroup,
            productionRouting,
            productionRoutingSequence,
            productionRoutingSqncIntVers);
    }

    @Override
    @Nonnull
    public ProductionRoutingSequenceCreateFluentHelper createProductionRoutingSequence(
        @Nonnull final ProductionRoutingSequence productionRoutingSequence )
    {
        return new ProductionRoutingSequenceCreateFluentHelper(
            servicePath,
            productionRoutingSequence,
            "ProductionRoutingSequence");
    }

    @Override
    @Nonnull
    public ProductionRoutingSequenceUpdateFluentHelper updateProductionRoutingSequence(
        @Nonnull final ProductionRoutingSequence productionRoutingSequence )
    {
        return new ProductionRoutingSequenceUpdateFluentHelper(
            servicePath,
            productionRoutingSequence,
            "ProductionRoutingSequence");
    }

    @Override
    @Nonnull
    public ProductionRoutingSubOperationFluentHelper getAllProductionRoutingSubOperation()
    {
        return new ProductionRoutingSubOperationFluentHelper(servicePath, "ProductionRoutingSubOperation");
    }

    @Override
    @Nonnull
    public ProductionRoutingSubOperationByKeyFluentHelper getProductionRoutingSubOperationByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingOpIntID,
        final String productionRoutingSequence,
        final String productionRoutingOpIntVersion )
    {
        return new ProductionRoutingSubOperationByKeyFluentHelper(
            servicePath,
            "ProductionRoutingSubOperation",
            productionRoutingGroup,
            productionRouting,
            productionRoutingOpIntID,
            productionRoutingSequence,
            productionRoutingOpIntVersion);
    }

    @Override
    @Nonnull
    public ProductionRoutingSubOperationCreateFluentHelper createProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation )
    {
        return new ProductionRoutingSubOperationCreateFluentHelper(
            servicePath,
            productionRoutingSubOperation,
            "ProductionRoutingSubOperation");
    }

    @Override
    @Nonnull
    public ProductionRoutingSubOperationUpdateFluentHelper updateProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation )
    {
        return new ProductionRoutingSubOperationUpdateFluentHelper(
            servicePath,
            productionRoutingSubOperation,
            "ProductionRoutingSubOperation");
    }

}
