/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddressDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.ProductionSupplyAreaUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionsupplyarea.batch.DefaultProductionSupplyAreaServiceBatch;

/**
 * <p>
 *
 * The OData API for production supply areas enables you to create, update, delete, and retrieve production supply
 * areas.
 *
 * The service is based on the OData protocol and can be consumed by external systems and user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/df/5c6b2792ec49a7b10c75fd5989f7ab/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTIONSUPPLYAREA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTIONSUPPLYAREA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Supply Area Integration(SAP_COM_0328)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E3'>Material Replenishment with Kanban - External
 * Procurement(1E3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4B3'>Material Replenishment with Kanban -
 * In-House Production(4B3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4B4'>Material Replenishment with Kanban
 * - Stock Transfer(4B4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Supply Area</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductionSupplyAreaService" )
@Deprecated
public class DefaultProductionSupplyAreaService implements ProductionSupplyAreaService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductionSupplyAreaService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductionSupplyAreaService()
    {
        servicePath = ProductionSupplyAreaService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductionSupplyAreaService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductionSupplyAreaService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductionSupplyAreaService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductionSupplyAreaServiceBatch batch()
    {
        return new DefaultProductionSupplyAreaServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaFluentHelper getAllProductionSupplyArea()
    {
        return new ProductionSupplyAreaFluentHelper(servicePath, "A_ProductionSupplyArea");
    }

    @Override
    @Nonnull
    public
        ProductionSupplyAreaByKeyFluentHelper
        getProductionSupplyAreaByKey( final String productionSupplyArea, final String plant )
    {
        return new ProductionSupplyAreaByKeyFluentHelper(
            servicePath,
            "A_ProductionSupplyArea",
            productionSupplyArea,
            plant);
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaCreateFluentHelper createProductionSupplyArea(
        @Nonnull final ProductionSupplyArea productionSupplyArea )
    {
        return new ProductionSupplyAreaCreateFluentHelper(servicePath, productionSupplyArea, "A_ProductionSupplyArea");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaUpdateFluentHelper updateProductionSupplyArea(
        @Nonnull final ProductionSupplyArea productionSupplyArea )
    {
        return new ProductionSupplyAreaUpdateFluentHelper(servicePath, productionSupplyArea, "A_ProductionSupplyArea");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaDeleteFluentHelper deleteProductionSupplyArea(
        @Nonnull final ProductionSupplyArea productionSupplyArea )
    {
        return new ProductionSupplyAreaDeleteFluentHelper(servicePath, productionSupplyArea, "A_ProductionSupplyArea");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaAddressFluentHelper getAllProductionSupplyAreaAddress()
    {
        return new ProductionSupplyAreaAddressFluentHelper(servicePath, "A_ProductionSupplyAreaAddress");
    }

    @Override
    @Nonnull
    public
        ProductionSupplyAreaAddressByKeyFluentHelper
        getProductionSupplyAreaAddressByKey( final String productionSupplyArea, final String plant )
    {
        return new ProductionSupplyAreaAddressByKeyFluentHelper(
            servicePath,
            "A_ProductionSupplyAreaAddress",
            productionSupplyArea,
            plant);
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaAddressCreateFluentHelper createProductionSupplyAreaAddress(
        @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress )
    {
        return new ProductionSupplyAreaAddressCreateFluentHelper(
            servicePath,
            productionSupplyAreaAddress,
            "A_ProductionSupplyAreaAddress");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaAddressUpdateFluentHelper updateProductionSupplyAreaAddress(
        @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress )
    {
        return new ProductionSupplyAreaAddressUpdateFluentHelper(
            servicePath,
            productionSupplyAreaAddress,
            "A_ProductionSupplyAreaAddress");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaAddressDeleteFluentHelper deleteProductionSupplyAreaAddress(
        @Nonnull final ProductionSupplyAreaAddress productionSupplyAreaAddress )
    {
        return new ProductionSupplyAreaAddressDeleteFluentHelper(
            servicePath,
            productionSupplyAreaAddress,
            "A_ProductionSupplyAreaAddress");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaTextFluentHelper getAllProductionSupplyAreaText()
    {
        return new ProductionSupplyAreaTextFluentHelper(servicePath, "A_ProductionSupplyAreaText");
    }

    @Override
    @Nonnull
    public
        ProductionSupplyAreaTextByKeyFluentHelper
        getProductionSupplyAreaTextByKey( final String productionSupplyArea, final String plant, final String language )
    {
        return new ProductionSupplyAreaTextByKeyFluentHelper(
            servicePath,
            "A_ProductionSupplyAreaText",
            productionSupplyArea,
            plant,
            language);
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaTextCreateFluentHelper createProductionSupplyAreaText(
        @Nonnull final ProductionSupplyAreaText productionSupplyAreaText )
    {
        return new ProductionSupplyAreaTextCreateFluentHelper(
            servicePath,
            productionSupplyAreaText,
            "A_ProductionSupplyAreaText");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaTextUpdateFluentHelper updateProductionSupplyAreaText(
        @Nonnull final ProductionSupplyAreaText productionSupplyAreaText )
    {
        return new ProductionSupplyAreaTextUpdateFluentHelper(
            servicePath,
            productionSupplyAreaText,
            "A_ProductionSupplyAreaText");
    }

    @Override
    @Nonnull
    public ProductionSupplyAreaTextDeleteFluentHelper deleteProductionSupplyAreaText(
        @Nonnull final ProductionSupplyAreaText productionSupplyAreaText )
    {
        return new ProductionSupplyAreaTextDeleteFluentHelper(
            servicePath,
            productionSupplyAreaText,
            "A_ProductionSupplyAreaText");
    }

}
