/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.batch.DefaultProductionVolumeCaptureServiceBatch;

/**
 * <p>
 * You can use the service to read and create production volumes for wells or combination of well and well completions.
 * The service is based on the OData protocol and can be consumed by external systems.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/9e/39877d13dd42cca8166ac6075dbfcc/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODVOLCAPTURE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODVOLCAPTURE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Volume Management Integration(SAP_COM_0704)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4AG'>Production Volume Capture(4AG)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProductionVolumeCaptureService" )
@Deprecated
public class DefaultProductionVolumeCaptureService implements ProductionVolumeCaptureService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProductionVolumeCaptureService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProductionVolumeCaptureService()
    {
        servicePath = ProductionVolumeCaptureService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProductionVolumeCaptureService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductionVolumeCaptureService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProductionVolumeCaptureService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProductionVolumeCaptureServiceBatch batch()
    {
        return new DefaultProductionVolumeCaptureServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductionVolumeFluentHelper getAllProductionVolume()
    {
        return new ProductionVolumeFluentHelper(servicePath, "ProductionVolume");
    }

    @Override
    @Nonnull
    public ProductionVolumeByKeyFluentHelper getProductionVolumeByKey(
        final String well,
        final String wellCompletion,
        final LocalDateTime productionDate,
        final ZonedDateTime oilAllocAtWellCompltnDateTime )
    {
        return new ProductionVolumeByKeyFluentHelper(
            servicePath,
            "ProductionVolume",
            well,
            wellCompletion,
            productionDate,
            oilAllocAtWellCompltnDateTime);
    }

    @Override
    @Nonnull
    public ProductionVolumeCreateFluentHelper createProductionVolume( @Nonnull final ProductionVolume productionVolume )
    {
        return new ProductionVolumeCreateFluentHelper(servicePath, productionVolume, "ProductionVolume");
    }

}
