/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.batch.DefaultProfitCenterServiceBatch;

/**
 * <p>
 *
 * This service enables you to read profit center master data in an API call. It is based on the OData protocol and can
 * be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/04/bb2efc2e9444cba9547a99d77ec61c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROFITCENTER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROFITCENTER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Profit Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProfitCenterService" )
@Deprecated
public class DefaultProfitCenterService implements ProfitCenterService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProfitCenterService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProfitCenterService()
    {
        servicePath = ProfitCenterService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProfitCenterService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProfitCenterService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProfitCenterService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProfitCenterServiceBatch batch()
    {
        return new DefaultProfitCenterServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PrftCtrCompanyCodeAssignmentFluentHelper getAllPrftCtrCompanyCodeAssignment()
    {
        return new PrftCtrCompanyCodeAssignmentFluentHelper(servicePath, "A_PrftCtrCompanyCodeAssignment");
    }

    @Override
    @Nonnull
    public PrftCtrCompanyCodeAssignmentByKeyFluentHelper getPrftCtrCompanyCodeAssignmentByKey(
        final String controllingArea,
        final String profitCenter,
        final String companyCode )
    {
        return new PrftCtrCompanyCodeAssignmentByKeyFluentHelper(
            servicePath,
            "A_PrftCtrCompanyCodeAssignment",
            controllingArea,
            profitCenter,
            companyCode);
    }

    @Override
    @Nonnull
    public ProfitCenterFluentHelper getAllProfitCenter()
    {
        return new ProfitCenterFluentHelper(servicePath, "A_ProfitCenter");
    }

    @Override
    @Nonnull
    public ProfitCenterByKeyFluentHelper getProfitCenterByKey(
        final String controllingArea,
        final String profitCenter,
        final LocalDateTime validityEndDate )
    {
        return new ProfitCenterByKeyFluentHelper(
            servicePath,
            "A_ProfitCenter",
            controllingArea,
            profitCenter,
            validityEndDate);
    }

    @Override
    @Nonnull
    public ProfitCenterTextFluentHelper getAllProfitCenterText()
    {
        return new ProfitCenterTextFluentHelper(servicePath, "A_ProfitCenterText");
    }

    @Override
    @Nonnull
    public ProfitCenterTextByKeyFluentHelper getProfitCenterTextByKey(
        final String language,
        final String controllingArea,
        final String profitCenter,
        final LocalDateTime validityEndDate )
    {
        return new ProfitCenterTextByKeyFluentHelper(
            servicePath,
            "A_ProfitCenterText",
            language,
            controllingArea,
            profitCenter,
            validityEndDate);
    }

}
