/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ResetDemandStatusToRequestedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDemandStatusToClosedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDemandStatusToRequestedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDmndStsToRequestOnReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.batch.DefaultProjectDemandServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, update, and delete project demands of enterprise projects and professional
 * services projects. A project demand represents a need for a material, service, resource, or expense that is related
 * to a project or a project element. With this service, you can process the following: - Service and material demands
 * of enterprise projects including the related supply information - Resource demands of enterprise projects including
 * the related resource assignments - Resource demands of professional services projects including the related resource
 * requests and resource assignments with their respective distributions - Demands for expenses of professional services
 * projects including the related demand distribution
 *
 * This service is based on the OData protocol and can be consumed by apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c8/b1ad2902384b46b8ab6f991f48cf68/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROJECTDEMAND_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROJECTDEMAND_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Project Demand Integration(SAP_COM_0783)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4RF'>Project Control - Resourcing and Procurement(4RF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PRF'>Project Control - Resourcing and Procurement(PRF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Project Demand</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultProjectDemandService" )
@Deprecated
public class DefaultProjectDemandService
    implements
    com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ProjectDemandService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultProjectDemandService()
    {
        servicePath = com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProjectDemandService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultProjectDemandService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProjectDemandService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultProjectDemandService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultProjectDemandServiceBatch batch()
    {
        return new DefaultProjectDemandServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProjDmndExpenseDistrFluentHelper getAllProjDmndExpenseDistr()
    {
        return new ProjDmndExpenseDistrFluentHelper(servicePath, "A_ProjDmndExpenseDistr");
    }

    @Override
    @Nonnull
    public ProjDmndExpenseDistrByKeyFluentHelper getProjDmndExpenseDistrByKey( final UUID projDmndExpnDistributionUUID )
    {
        return new ProjDmndExpenseDistrByKeyFluentHelper(
            servicePath,
            "A_ProjDmndExpenseDistr",
            projDmndExpnDistributionUUID);
    }

    @Override
    @Nonnull
    public ProjDmndExpenseDistrUpdateFluentHelper updateProjDmndExpenseDistr(
        @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr )
    {
        return new ProjDmndExpenseDistrUpdateFluentHelper(servicePath, projDmndExpenseDistr, "A_ProjDmndExpenseDistr");
    }

    @Override
    @Nonnull
    public ProjDmndExpenseDistrDeleteFluentHelper deleteProjDmndExpenseDistr(
        @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr )
    {
        return new ProjDmndExpenseDistrDeleteFluentHelper(servicePath, projDmndExpenseDistr, "A_ProjDmndExpenseDistr");
    }

    @Override
    @Nonnull
    public ProjDmndResourceAssignmentFluentHelper getAllProjDmndResourceAssignment()
    {
        return new ProjDmndResourceAssignmentFluentHelper(servicePath, "A_ProjDmndResourceAssignment");
    }

    @Override
    @Nonnull
    public ProjDmndResourceAssignmentByKeyFluentHelper getProjDmndResourceAssignmentByKey(
        final UUID projDmndRsceAssgmtUUID )
    {
        return new ProjDmndResourceAssignmentByKeyFluentHelper(
            servicePath,
            "A_ProjDmndResourceAssignment",
            projDmndRsceAssgmtUUID);
    }

    @Override
    @Nonnull
    public ProjDmndResourceAssignmentCreateFluentHelper createProjDmndResourceAssignment(
        @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment )
    {
        return new ProjDmndResourceAssignmentCreateFluentHelper(
            servicePath,
            projDmndResourceAssignment,
            "A_ProjDmndResourceAssignment");
    }

    @Override
    @Nonnull
    public ProjDmndResourceAssignmentUpdateFluentHelper updateProjDmndResourceAssignment(
        @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment )
    {
        return new ProjDmndResourceAssignmentUpdateFluentHelper(
            servicePath,
            projDmndResourceAssignment,
            "A_ProjDmndResourceAssignment");
    }

    @Override
    @Nonnull
    public ProjDmndResourceAssignmentDeleteFluentHelper deleteProjDmndResourceAssignment(
        @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment )
    {
        return new ProjDmndResourceAssignmentDeleteFluentHelper(
            servicePath,
            projDmndResourceAssignment,
            "A_ProjDmndResourceAssignment");
    }

    @Override
    @Nonnull
    public ProjDmndRsceAssgmtDistrFluentHelper getAllProjDmndRsceAssgmtDistr()
    {
        return new ProjDmndRsceAssgmtDistrFluentHelper(servicePath, "A_ProjDmndRsceAssgmtDistr");
    }

    @Override
    @Nonnull
    public ProjDmndRsceAssgmtDistrByKeyFluentHelper getProjDmndRsceAssgmtDistrByKey(
        final UUID projDmndRsceAssgmtDistrUUID )
    {
        return new ProjDmndRsceAssgmtDistrByKeyFluentHelper(
            servicePath,
            "A_ProjDmndRsceAssgmtDistr",
            projDmndRsceAssgmtDistrUUID);
    }

    @Override
    @Nonnull
    public ProjDmndRsceAssgmtDistrUpdateFluentHelper updateProjDmndRsceAssgmtDistr(
        @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr )
    {
        return new ProjDmndRsceAssgmtDistrUpdateFluentHelper(
            servicePath,
            projDmndRsceAssgmtDistr,
            "A_ProjDmndRsceAssgmtDistr");
    }

    @Override
    @Nonnull
    public ProjDmndRsceAssgmtDistrDeleteFluentHelper deleteProjDmndRsceAssgmtDistr(
        @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr )
    {
        return new ProjDmndRsceAssgmtDistrDeleteFluentHelper(
            servicePath,
            projDmndRsceAssgmtDistr,
            "A_ProjDmndRsceAssgmtDistr");
    }

    @Override
    @Nonnull
    public ProjDmndRsceReqDistributionFluentHelper getAllProjDmndRsceReqDistribution()
    {
        return new ProjDmndRsceReqDistributionFluentHelper(servicePath, "A_ProjDmndRsceReqDistribution");
    }

    @Override
    @Nonnull
    public ProjDmndRsceReqDistributionByKeyFluentHelper getProjDmndRsceReqDistributionByKey(
        final UUID projDmndRsceReqDistrUUID )
    {
        return new ProjDmndRsceReqDistributionByKeyFluentHelper(
            servicePath,
            "A_ProjDmndRsceReqDistribution",
            projDmndRsceReqDistrUUID);
    }

    @Override
    @Nonnull
    public ProjDmndRsceReqDistributionUpdateFluentHelper updateProjDmndRsceReqDistribution(
        @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution )
    {
        return new ProjDmndRsceReqDistributionUpdateFluentHelper(
            servicePath,
            projDmndRsceReqDistribution,
            "A_ProjDmndRsceReqDistribution");
    }

    @Override
    @Nonnull
    public ProjDmndRsceReqDistributionDeleteFluentHelper deleteProjDmndRsceReqDistribution(
        @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution )
    {
        return new ProjDmndRsceReqDistributionDeleteFluentHelper(
            servicePath,
            projDmndRsceReqDistribution,
            "A_ProjDmndRsceReqDistribution");
    }

    @Override
    @Nonnull
    public ProjectDemandFluentHelper getAllProjectDemand()
    {
        return new ProjectDemandFluentHelper(servicePath, "A_ProjectDemand");
    }

    @Override
    @Nonnull
    public ProjectDemandByKeyFluentHelper getProjectDemandByKey( final UUID projectDemandUUID )
    {
        return new ProjectDemandByKeyFluentHelper(servicePath, "A_ProjectDemand", projectDemandUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandCreateFluentHelper createProjectDemand( @Nonnull final ProjectDemand projectDemand )
    {
        return new ProjectDemandCreateFluentHelper(servicePath, projectDemand, "A_ProjectDemand");
    }

    @Override
    @Nonnull
    public ProjectDemandUpdateFluentHelper updateProjectDemand( @Nonnull final ProjectDemand projectDemand )
    {
        return new ProjectDemandUpdateFluentHelper(servicePath, projectDemand, "A_ProjectDemand");
    }

    @Override
    @Nonnull
    public ProjectDemandDeleteFluentHelper deleteProjectDemand( @Nonnull final ProjectDemand projectDemand )
    {
        return new ProjectDemandDeleteFluentHelper(servicePath, projectDemand, "A_ProjectDemand");
    }

    @Override
    @Nonnull
    public ProjectDemandExpenseFluentHelper getAllProjectDemandExpense()
    {
        return new ProjectDemandExpenseFluentHelper(servicePath, "A_ProjectDemandExpense");
    }

    @Override
    @Nonnull
    public ProjectDemandExpenseByKeyFluentHelper getProjectDemandExpenseByKey( final UUID projectDemandExpenseUUID )
    {
        return new ProjectDemandExpenseByKeyFluentHelper(
            servicePath,
            "A_ProjectDemandExpense",
            projectDemandExpenseUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandExpenseCreateFluentHelper createProjectDemandExpense(
        @Nonnull final ProjectDemandExpense projectDemandExpense )
    {
        return new ProjectDemandExpenseCreateFluentHelper(servicePath, projectDemandExpense, "A_ProjectDemandExpense");
    }

    @Override
    @Nonnull
    public ProjectDemandExpenseUpdateFluentHelper updateProjectDemandExpense(
        @Nonnull final ProjectDemandExpense projectDemandExpense )
    {
        return new ProjectDemandExpenseUpdateFluentHelper(servicePath, projectDemandExpense, "A_ProjectDemandExpense");
    }

    @Override
    @Nonnull
    public ProjectDemandMaterialFluentHelper getAllProjectDemandMaterial()
    {
        return new ProjectDemandMaterialFluentHelper(servicePath, "A_ProjectDemandMaterial");
    }

    @Override
    @Nonnull
    public ProjectDemandMaterialByKeyFluentHelper getProjectDemandMaterialByKey( final UUID projectDemandMaterialUUID )
    {
        return new ProjectDemandMaterialByKeyFluentHelper(
            servicePath,
            "A_ProjectDemandMaterial",
            projectDemandMaterialUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandMaterialUpdateFluentHelper updateProjectDemandMaterial(
        @Nonnull final ProjectDemandMaterial projectDemandMaterial )
    {
        return new ProjectDemandMaterialUpdateFluentHelper(
            servicePath,
            projectDemandMaterial,
            "A_ProjectDemandMaterial");
    }

    @Override
    @Nonnull
    public ProjectDemandMaterialSupplyFluentHelper getAllProjectDemandMaterialSupply()
    {
        return new ProjectDemandMaterialSupplyFluentHelper(servicePath, "A_ProjectDemandMaterialSupply");
    }

    @Override
    @Nonnull
    public ProjectDemandMaterialSupplyByKeyFluentHelper getProjectDemandMaterialSupplyByKey(
        final UUID projDemandMaterialSupplyUUID )
    {
        return new ProjectDemandMaterialSupplyByKeyFluentHelper(
            servicePath,
            "A_ProjectDemandMaterialSupply",
            projDemandMaterialSupplyUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandMaterialSupplyUpdateFluentHelper updateProjectDemandMaterialSupply(
        @Nonnull final ProjectDemandMaterialSupply projectDemandMaterialSupply )
    {
        return new ProjectDemandMaterialSupplyUpdateFluentHelper(
            servicePath,
            projectDemandMaterialSupply,
            "A_ProjectDemandMaterialSupply");
    }

    @Override
    @Nonnull
    public ProjectDemandResourceFluentHelper getAllProjectDemandResource()
    {
        return new ProjectDemandResourceFluentHelper(servicePath, "A_ProjectDemandResource");
    }

    @Override
    @Nonnull
    public ProjectDemandResourceByKeyFluentHelper getProjectDemandResourceByKey( final UUID projectDemandWorkUUID )
    {
        return new ProjectDemandResourceByKeyFluentHelper(
            servicePath,
            "A_ProjectDemandResource",
            projectDemandWorkUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandResourceCreateFluentHelper createProjectDemandResource(
        @Nonnull final ProjectDemandResource projectDemandResource )
    {
        return new ProjectDemandResourceCreateFluentHelper(
            servicePath,
            projectDemandResource,
            "A_ProjectDemandResource");
    }

    @Override
    @Nonnull
    public ProjectDemandResourceUpdateFluentHelper updateProjectDemandResource(
        @Nonnull final ProjectDemandResource projectDemandResource )
    {
        return new ProjectDemandResourceUpdateFluentHelper(
            servicePath,
            projectDemandResource,
            "A_ProjectDemandResource");
    }

    @Override
    @Nonnull
    public ProjectDemandResourceRequestFluentHelper getAllProjectDemandResourceRequest()
    {
        return new ProjectDemandResourceRequestFluentHelper(servicePath, "A_ProjectDemandResourceRequest");
    }

    @Override
    @Nonnull
    public ProjectDemandResourceRequestByKeyFluentHelper getProjectDemandResourceRequestByKey(
        final UUID projDmndResourceRequestUUID )
    {
        return new ProjectDemandResourceRequestByKeyFluentHelper(
            servicePath,
            "A_ProjectDemandResourceRequest",
            projDmndResourceRequestUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandResourceRequestCreateFluentHelper createProjectDemandResourceRequest(
        @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest )
    {
        return new ProjectDemandResourceRequestCreateFluentHelper(
            servicePath,
            projectDemandResourceRequest,
            "A_ProjectDemandResourceRequest");
    }

    @Override
    @Nonnull
    public ProjectDemandResourceRequestUpdateFluentHelper updateProjectDemandResourceRequest(
        @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest )
    {
        return new ProjectDemandResourceRequestUpdateFluentHelper(
            servicePath,
            projectDemandResourceRequest,
            "A_ProjectDemandResourceRequest");
    }

    @Override
    @Nonnull
    public ProjectDemandResourceRequestDeleteFluentHelper deleteProjectDemandResourceRequest(
        @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest )
    {
        return new ProjectDemandResourceRequestDeleteFluentHelper(
            servicePath,
            projectDemandResourceRequest,
            "A_ProjectDemandResourceRequest");
    }

    @Override
    @Nonnull
    public ProjectDemandServiceFluentHelper getAllProjectDemandService()
    {
        return new ProjectDemandServiceFluentHelper(servicePath, "A_ProjectDemandService");
    }

    @Override
    @Nonnull
    public ProjectDemandServiceByKeyFluentHelper getProjectDemandServiceByKey( final UUID projectDemandServiceUUID )
    {
        return new ProjectDemandServiceByKeyFluentHelper(
            servicePath,
            "A_ProjectDemandService",
            projectDemandServiceUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandServiceUpdateFluentHelper updateProjectDemandService(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService projectDemandService )
    {
        return new ProjectDemandServiceUpdateFluentHelper(servicePath, projectDemandService, "A_ProjectDemandService");
    }

    @Override
    @Nonnull
    public ProjectDemandServiceSupplyFluentHelper getAllProjectDemandServiceSupply()
    {
        return new ProjectDemandServiceSupplyFluentHelper(servicePath, "A_ProjectDemandServiceSupply");
    }

    @Override
    @Nonnull
    public ProjectDemandServiceSupplyByKeyFluentHelper getProjectDemandServiceSupplyByKey(
        final UUID projectDemandServiceSupplyUUID )
    {
        return new ProjectDemandServiceSupplyByKeyFluentHelper(
            servicePath,
            "A_ProjectDemandServiceSupply",
            projectDemandServiceSupplyUUID);
    }

    @Override
    @Nonnull
    public ProjectDemandServiceSupplyUpdateFluentHelper updateProjectDemandServiceSupply(
        @Nonnull final ProjectDemandServiceSupply projectDemandServiceSupply )
    {
        return new ProjectDemandServiceSupplyUpdateFluentHelper(
            servicePath,
            projectDemandServiceSupply,
            "A_ProjectDemandServiceSupply");
    }

    @Override
    @Nonnull
    public ResetDemandStatusToRequestedFluentHelper resetDemandStatusToRequested(
        @Nonnull final UUID projectDemandUUID )
    {
        return new ResetDemandStatusToRequestedFluentHelper(servicePath, projectDemandUUID);
    }

    @Override
    @Nonnull
    public SetDemandStatusToClosedFluentHelper setDemandStatusToClosed( @Nonnull final UUID projectDemandUUID )
    {
        return new SetDemandStatusToClosedFluentHelper(servicePath, projectDemandUUID);
    }

    @Override
    @Nonnull
    public SetDemandStatusToRequestedFluentHelper setDemandStatusToRequested( @Nonnull final UUID projectDemandUUID )
    {
        return new SetDemandStatusToRequestedFluentHelper(servicePath, projectDemandUUID);
    }

    @Override
    @Nonnull
    public SetDmndStsToRequestOnReleaseFluentHelper setDmndStsToRequestOnRelease(
        @Nonnull final UUID projectDemandUUID )
    {
        return new SetDmndStsToRequestOnReleaseFluentHelper(servicePath, projectDemandUUID);
    }

}
