/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.ApproveDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemConditionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemConditionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.RejectDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.batch.DefaultPurchaseContractServiceBatch;

/**
 * <p>
 *
 * This service is based on the OData protocol. It enables you to read, create, and update purchase contracts through an
 * API call from a source system outside SAP S/4HANA Cloud. The service contains header, item, item conditions, account
 * assignment, address and partner nodes. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/34/3b465833a40846e10000000a441470/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASECONTRACT_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASECONTRACT_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Distributed Manufacturing Integration(SAP_COM_0077), Purchase Contract Integration(SAP_COM_0101)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/JC1'>Dynamic Customer Profiling(JC1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BMD'>Purchase Contract(BMD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMD'>Purchase Contract(OMD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2202 (Feb 2022). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchaseContractService" )
@Deprecated
public class DefaultPurchaseContractService implements PurchaseContractService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchaseContractService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchaseContractService()
    {
        servicePath = PurchaseContractService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchaseContractService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchaseContractService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchaseContractService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchaseContractServiceBatch batch()
    {
        return new DefaultPurchaseContractServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PurchaseContractFluentHelper getAllPurchaseContract()
    {
        return new PurchaseContractFluentHelper(servicePath, "A_PurchaseContract");
    }

    @Override
    @Nonnull
    public PurchaseContractByKeyFluentHelper getPurchaseContractByKey( final String purchaseContract )
    {
        return new PurchaseContractByKeyFluentHelper(servicePath, "A_PurchaseContract", purchaseContract);
    }

    @Override
    @Nonnull
    public PurchaseContractCreateFluentHelper createPurchaseContract( @Nonnull final PurchaseContract purchaseContract )
    {
        return new PurchaseContractCreateFluentHelper(servicePath, purchaseContract, "A_PurchaseContract");
    }

    @Override
    @Nonnull
    public PurchaseContractUpdateFluentHelper updatePurchaseContract( @Nonnull final PurchaseContract purchaseContract )
    {
        return new PurchaseContractUpdateFluentHelper(servicePath, purchaseContract, "A_PurchaseContract");
    }

    @Override
    @Nonnull
    public PurchaseContractItemFluentHelper getAllPurchaseContractItem()
    {
        return new PurchaseContractItemFluentHelper(servicePath, "A_PurchaseContractItem");
    }

    @Override
    @Nonnull
    public
        PurchaseContractItemByKeyFluentHelper
        getPurchaseContractItemByKey( final String purchaseContract, final String purchaseContractItem )
    {
        return new PurchaseContractItemByKeyFluentHelper(
            servicePath,
            "A_PurchaseContractItem",
            purchaseContract,
            purchaseContractItem);
    }

    @Override
    @Nonnull
    public PurchaseContractItemCreateFluentHelper createPurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return new PurchaseContractItemCreateFluentHelper(servicePath, purchaseContractItem, "A_PurchaseContractItem");
    }

    @Override
    @Nonnull
    public PurchaseContractItemUpdateFluentHelper updatePurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return new PurchaseContractItemUpdateFluentHelper(servicePath, purchaseContractItem, "A_PurchaseContractItem");
    }

    @Override
    @Nonnull
    public PurContrItemConditionFluentHelper getAllPurContrItemCondition()
    {
        return new PurContrItemConditionFluentHelper(servicePath, "A_PurContrItemCondition");
    }

    @Override
    @Nonnull
    public PurContrItemConditionByKeyFluentHelper getPurContrItemConditionByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final LocalDateTime conditionValidityEndDate,
        final String conditionType,
        final String conditionRecord,
        final String conditionSequentialNumber )
    {
        return new PurContrItemConditionByKeyFluentHelper(
            servicePath,
            "A_PurContrItemCondition",
            purchaseContract,
            purchaseContractItem,
            conditionValidityEndDate,
            conditionType,
            conditionRecord,
            conditionSequentialNumber);
    }

    @Override
    @Nonnull
    public PurCtrAccountFluentHelper getAllPurCtrAccount()
    {
        return new PurCtrAccountFluentHelper(servicePath, "A_PurCtrAccount");
    }

    @Override
    @Nonnull
    public PurCtrAccountByKeyFluentHelper getPurCtrAccountByKey(
        final String accountAssignment,
        final String purchaseContractItem,
        final String purchaseContract )
    {
        return new PurCtrAccountByKeyFluentHelper(
            servicePath,
            "A_PurCtrAccount",
            accountAssignment,
            purchaseContractItem,
            purchaseContract);
    }

    @Override
    @Nonnull
    public PurCtrAccountCreateFluentHelper createPurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return new PurCtrAccountCreateFluentHelper(servicePath, purCtrAccount, "A_PurCtrAccount");
    }

    @Override
    @Nonnull
    public PurCtrAccountUpdateFluentHelper updatePurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return new PurCtrAccountUpdateFluentHelper(servicePath, purCtrAccount, "A_PurCtrAccount");
    }

    @Override
    @Nonnull
    public PurCtrAddressFluentHelper getAllPurCtrAddress()
    {
        return new PurCtrAddressFluentHelper(servicePath, "A_PurCtrAddress");
    }

    @Override
    @Nonnull
    public PurCtrAddressByKeyFluentHelper getPurCtrAddressByKey(
        final String purchaseContract,
        final String addressID,
        final String purchaseContractItem )
    {
        return new PurCtrAddressByKeyFluentHelper(
            servicePath,
            "A_PurCtrAddress",
            purchaseContract,
            addressID,
            purchaseContractItem);
    }

    @Override
    @Nonnull
    public PurCtrAddressCreateFluentHelper createPurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return new PurCtrAddressCreateFluentHelper(servicePath, purCtrAddress, "A_PurCtrAddress");
    }

    @Override
    @Nonnull
    public PurCtrAddressUpdateFluentHelper updatePurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return new PurCtrAddressUpdateFluentHelper(servicePath, purCtrAddress, "A_PurCtrAddress");
    }

    @Override
    @Nonnull
    public PurCtrPartnersFluentHelper getAllPurCtrPartners()
    {
        return new PurCtrPartnersFluentHelper(servicePath, "A_PurCtrPartners");
    }

    @Override
    @Nonnull
    public PurCtrPartnersByKeyFluentHelper getPurCtrPartnersByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final String purchasingOrganization,
        final String partnerFunction,
        final String plant,
        final String supplierSubrange,
        final String partnerCounter )
    {
        return new PurCtrPartnersByKeyFluentHelper(
            servicePath,
            "A_PurCtrPartners",
            purchaseContract,
            purchaseContractItem,
            purchasingOrganization,
            partnerFunction,
            plant,
            supplierSubrange,
            partnerCounter);
    }

    @Override
    @Nonnull
    public PurCtrPartnersCreateFluentHelper createPurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return new PurCtrPartnersCreateFluentHelper(servicePath, purCtrPartners, "A_PurCtrPartners");
    }

    @Override
    @Nonnull
    public PurCtrPartnersUpdateFluentHelper updatePurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return new PurCtrPartnersUpdateFluentHelper(servicePath, purCtrPartners, "A_PurCtrPartners");
    }

    @Override
    @Nonnull
    public WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String purchaseContract )
    {
        return new WithdrawFromApprovalFluentHelper(servicePath, purchaseContract);
    }

    @Override
    @Nonnull
    public RejectDocumentFluentHelper rejectDocument( @Nonnull final String purchaseContract )
    {
        return new RejectDocumentFluentHelper(servicePath, purchaseContract);
    }

    @Override
    @Nonnull
    public ApproveDocumentFluentHelper approveDocument( @Nonnull final String purchaseContract )
    {
        return new ApproveDocumentFluentHelper(servicePath, purchaseContract);
    }

}
