/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.ApproveDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnAmountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnAmountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnScaleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnScaleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnValdtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnValdtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnScalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnScalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnValdtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnValdtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartners;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartnersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartnersCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartnersFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartnersUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.RejectDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.batch.DefaultPurchaseContractV2ServiceBatch;

/**
 * <p>
 *
 * This service enables you to read, create, and update purchase contracts through an API call from a source system
 * outside SAP S/4HANA Cloud. The service contains header, item, item conditions, account assignment, address, Header
 * notes, Item notes and partner nodes..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1e/7ae14775154b65939267d6fa4d9535/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASECONTRACT_PROCESS_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASECONTRACT_PROCESS_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Distributed Manufacturing Integration(SAP_COM_0077), Purchase Contract Integration(SAP_COM_0101)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/JC1'>Dynamic Customer Profiling(JC1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4R2'>Service Procurement with Ariba Network and SAP
 * Fieldglass(4R2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BMD'>Purchase Contract(BMD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMD'>Purchase Contract(OMD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchaseContractV2Service" )
@Deprecated
public class DefaultPurchaseContractV2Service implements PurchaseContractV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchaseContractV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchaseContractV2Service()
    {
        servicePath = PurchaseContractV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchaseContractV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchaseContractV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchaseContractV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchaseContractV2ServiceBatch batch()
    {
        return new DefaultPurchaseContractV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PurCtrAccountFluentHelper getAllPurCtrAccount()
    {
        return new PurCtrAccountFluentHelper(servicePath, "A_PurCtrAccount");
    }

    @Override
    @Nonnull
    public PurCtrAccountByKeyFluentHelper getPurCtrAccountByKey(
        final String accountAssignment,
        final String purchaseContractItem,
        final String purchaseContract )
    {
        return new PurCtrAccountByKeyFluentHelper(
            servicePath,
            "A_PurCtrAccount",
            accountAssignment,
            purchaseContractItem,
            purchaseContract);
    }

    @Override
    @Nonnull
    public PurCtrAccountCreateFluentHelper createPurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return new PurCtrAccountCreateFluentHelper(servicePath, purCtrAccount, "A_PurCtrAccount");
    }

    @Override
    @Nonnull
    public PurCtrAccountUpdateFluentHelper updatePurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return new PurCtrAccountUpdateFluentHelper(servicePath, purCtrAccount, "A_PurCtrAccount");
    }

    @Override
    @Nonnull
    public PurCtrAddressFluentHelper getAllPurCtrAddress()
    {
        return new PurCtrAddressFluentHelper(servicePath, "A_PurCtrAddress");
    }

    @Override
    @Nonnull
    public PurCtrAddressByKeyFluentHelper getPurCtrAddressByKey(
        final String purchaseContract,
        final String addressID,
        final String purchaseContractItem )
    {
        return new PurCtrAddressByKeyFluentHelper(
            servicePath,
            "A_PurCtrAddress",
            purchaseContract,
            addressID,
            purchaseContractItem);
    }

    @Override
    @Nonnull
    public PurCtrAddressCreateFluentHelper createPurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return new PurCtrAddressCreateFluentHelper(servicePath, purCtrAddress, "A_PurCtrAddress");
    }

    @Override
    @Nonnull
    public PurCtrAddressUpdateFluentHelper updatePurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return new PurCtrAddressUpdateFluentHelper(servicePath, purCtrAddress, "A_PurCtrAddress");
    }

    @Override
    @Nonnull
    public PurchaseContractItemNotesFluentHelper getAllPurchaseContractItemNotes()
    {
        return new PurchaseContractItemNotesFluentHelper(servicePath, "A_PurchaseContractItemNotes");
    }

    @Override
    @Nonnull
    public PurchaseContractItemNotesByKeyFluentHelper getPurchaseContractItemNotesByKey(
        final String language,
        final String textObjectType,
        final String architecturalObjectNumber,
        final String technicalObjectType,
        final String purchaseContractItem,
        final String purchaseContract )
    {
        return new PurchaseContractItemNotesByKeyFluentHelper(
            servicePath,
            "A_PurchaseContractItemNotes",
            language,
            textObjectType,
            architecturalObjectNumber,
            technicalObjectType,
            purchaseContractItem,
            purchaseContract);
    }

    @Override
    @Nonnull
    public PurchaseContractItemNotesCreateFluentHelper createPurchaseContractItemNotes(
        @Nonnull final PurchaseContractItemNotes purchaseContractItemNotes )
    {
        return new PurchaseContractItemNotesCreateFluentHelper(
            servicePath,
            purchaseContractItemNotes,
            "A_PurchaseContractItemNotes");
    }

    @Override
    @Nonnull
    public PurchaseContractItemNotesUpdateFluentHelper updatePurchaseContractItemNotes(
        @Nonnull final PurchaseContractItemNotes purchaseContractItemNotes )
    {
        return new PurchaseContractItemNotesUpdateFluentHelper(
            servicePath,
            purchaseContractItemNotes,
            "A_PurchaseContractItemNotes");
    }

    @Override
    @Nonnull
    public PurchaseContractItemFluentHelper getAllPurchaseContractItem()
    {
        return new PurchaseContractItemFluentHelper(servicePath, "A_PurchaseContractItem");
    }

    @Override
    @Nonnull
    public
        PurchaseContractItemByKeyFluentHelper
        getPurchaseContractItemByKey( final String purchaseContract, final String purchaseContractItem )
    {
        return new PurchaseContractItemByKeyFluentHelper(
            servicePath,
            "A_PurchaseContractItem",
            purchaseContract,
            purchaseContractItem);
    }

    @Override
    @Nonnull
    public PurchaseContractItemCreateFluentHelper createPurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return new PurchaseContractItemCreateFluentHelper(servicePath, purchaseContractItem, "A_PurchaseContractItem");
    }

    @Override
    @Nonnull
    public PurchaseContractItemUpdateFluentHelper updatePurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return new PurchaseContractItemUpdateFluentHelper(servicePath, purchaseContractItem, "A_PurchaseContractItem");
    }

    @Override
    @Nonnull
    public PurchaseContractNotesFluentHelper getAllPurchaseContractNotes()
    {
        return new PurchaseContractNotesFluentHelper(servicePath, "A_PurchaseContractNotes");
    }

    @Override
    @Nonnull
    public PurchaseContractNotesByKeyFluentHelper getPurchaseContractNotesByKey(
        final String language,
        final String textObjectType,
        final String technicalObjectType,
        final String architecturalObjectNumber,
        final String purchaseContract )
    {
        return new PurchaseContractNotesByKeyFluentHelper(
            servicePath,
            "A_PurchaseContractNotes",
            language,
            textObjectType,
            technicalObjectType,
            architecturalObjectNumber,
            purchaseContract);
    }

    @Override
    @Nonnull
    public PurchaseContractNotesCreateFluentHelper createPurchaseContractNotes(
        @Nonnull final PurchaseContractNotes purchaseContractNotes )
    {
        return new PurchaseContractNotesCreateFluentHelper(
            servicePath,
            purchaseContractNotes,
            "A_PurchaseContractNotes");
    }

    @Override
    @Nonnull
    public PurchaseContractNotesUpdateFluentHelper updatePurchaseContractNotes(
        @Nonnull final PurchaseContractNotes purchaseContractNotes )
    {
        return new PurchaseContractNotesUpdateFluentHelper(
            servicePath,
            purchaseContractNotes,
            "A_PurchaseContractNotes");
    }

    @Override
    @Nonnull
    public PurCtrPartnersFluentHelper getAllPurCtrPartners()
    {
        return new PurCtrPartnersFluentHelper(servicePath, "A_PurCtrPartners");
    }

    @Override
    @Nonnull
    public PurCtrPartnersByKeyFluentHelper getPurCtrPartnersByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final String purchasingOrganization,
        final String partnerFunction,
        final String plant,
        final String supplierSubrange,
        final String partnerCounter )
    {
        return new PurCtrPartnersByKeyFluentHelper(
            servicePath,
            "A_PurCtrPartners",
            purchaseContract,
            purchaseContractItem,
            purchasingOrganization,
            partnerFunction,
            plant,
            supplierSubrange,
            partnerCounter);
    }

    @Override
    @Nonnull
    public PurCtrPartnersCreateFluentHelper createPurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return new PurCtrPartnersCreateFluentHelper(servicePath, purCtrPartners, "A_PurCtrPartners");
    }

    @Override
    @Nonnull
    public PurCtrPartnersUpdateFluentHelper updatePurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return new PurCtrPartnersUpdateFluentHelper(servicePath, purCtrPartners, "A_PurCtrPartners");
    }

    @Override
    @Nonnull
    public PurchaseContractFluentHelper getAllPurchaseContract()
    {
        return new PurchaseContractFluentHelper(servicePath, "A_PurchaseContract");
    }

    @Override
    @Nonnull
    public PurchaseContractByKeyFluentHelper getPurchaseContractByKey( final String purchaseContract )
    {
        return new PurchaseContractByKeyFluentHelper(servicePath, "A_PurchaseContract", purchaseContract);
    }

    @Override
    @Nonnull
    public PurchaseContractCreateFluentHelper createPurchaseContract( @Nonnull final PurchaseContract purchaseContract )
    {
        return new PurchaseContractCreateFluentHelper(servicePath, purchaseContract, "A_PurchaseContract");
    }

    @Override
    @Nonnull
    public PurchaseContractUpdateFluentHelper updatePurchaseContract( @Nonnull final PurchaseContract purchaseContract )
    {
        return new PurchaseContractUpdateFluentHelper(servicePath, purchaseContract, "A_PurchaseContract");
    }

    @Override
    @Nonnull
    public PurContrHdrCndnAmountFluentHelper getAllPurContrHdrCndnAmount()
    {
        return new PurContrHdrCndnAmountFluentHelper(servicePath, "A_PurContrHdrCndnAmount");
    }

    @Override
    @Nonnull
    public PurContrHdrCndnAmountByKeyFluentHelper getPurContrHdrCndnAmountByKey(
        final String purchaseContract,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate,
        final String conditionSequentialNumber )
    {
        return new PurContrHdrCndnAmountByKeyFluentHelper(
            servicePath,
            "A_PurContrHdrCndnAmount",
            purchaseContract,
            conditionRecord,
            conditionValidityEndDate,
            conditionSequentialNumber);
    }

    @Override
    @Nonnull
    public PurContrHdrCndnScaleFluentHelper getAllPurContrHdrCndnScale()
    {
        return new PurContrHdrCndnScaleFluentHelper(servicePath, "A_PurContrHdrCndnScale");
    }

    @Override
    @Nonnull
    public PurContrHdrCndnScaleByKeyFluentHelper getPurContrHdrCndnScaleByKey(
        final String purchaseContract,
        final String conditionRecord,
        final String conditionSequentialNumber,
        final LocalDateTime conditionValidityEndDate,
        final String conditionScaleLine )
    {
        return new PurContrHdrCndnScaleByKeyFluentHelper(
            servicePath,
            "A_PurContrHdrCndnScale",
            purchaseContract,
            conditionRecord,
            conditionSequentialNumber,
            conditionValidityEndDate,
            conditionScaleLine);
    }

    @Override
    @Nonnull
    public PurContrHdrCndnValdtyFluentHelper getAllPurContrHdrCndnValdty()
    {
        return new PurContrHdrCndnValdtyFluentHelper(servicePath, "A_PurContrHdrCndnValdty");
    }

    @Override
    @Nonnull
    public PurContrHdrCndnValdtyByKeyFluentHelper getPurContrHdrCndnValdtyByKey(
        final String purchaseContract,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate )
    {
        return new PurContrHdrCndnValdtyByKeyFluentHelper(
            servicePath,
            "A_PurContrHdrCndnValdty",
            purchaseContract,
            conditionRecord,
            conditionValidityEndDate);
    }

    @Override
    @Nonnull
    public PurContrItmCndnAmountFluentHelper getAllPurContrItmCndnAmount()
    {
        return new PurContrItmCndnAmountFluentHelper(servicePath, "A_PurContrItmCndnAmount");
    }

    @Override
    @Nonnull
    public PurContrItmCndnAmountByKeyFluentHelper getPurContrItmCndnAmountByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate,
        final String conditionSequentialNumber )
    {
        return new PurContrItmCndnAmountByKeyFluentHelper(
            servicePath,
            "A_PurContrItmCndnAmount",
            purchaseContract,
            purchaseContractItem,
            conditionRecord,
            conditionValidityEndDate,
            conditionSequentialNumber);
    }

    @Override
    @Nonnull
    public PurContrItmCndnScalesFluentHelper getAllPurContrItmCndnScales()
    {
        return new PurContrItmCndnScalesFluentHelper(servicePath, "A_PurContrItmCndnScales");
    }

    @Override
    @Nonnull
    public PurContrItmCndnScalesByKeyFluentHelper getPurContrItmCndnScalesByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final String conditionRecord,
        final String conditionSequentialNumber,
        final LocalDateTime conditionValidityEndDate,
        final String conditionScaleLine )
    {
        return new PurContrItmCndnScalesByKeyFluentHelper(
            servicePath,
            "A_PurContrItmCndnScales",
            purchaseContract,
            purchaseContractItem,
            conditionRecord,
            conditionSequentialNumber,
            conditionValidityEndDate,
            conditionScaleLine);
    }

    @Override
    @Nonnull
    public PurContrItmCndnValdtyFluentHelper getAllPurContrItmCndnValdty()
    {
        return new PurContrItmCndnValdtyFluentHelper(servicePath, "A_PurContrItmCndnValdty");
    }

    @Override
    @Nonnull
    public PurContrItmCndnValdtyByKeyFluentHelper getPurContrItmCndnValdtyByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate )
    {
        return new PurContrItmCndnValdtyByKeyFluentHelper(
            servicePath,
            "A_PurContrItmCndnValdty",
            purchaseContract,
            purchaseContractItem,
            conditionRecord,
            conditionValidityEndDate);
    }

    @Override
    @Nonnull
    public ApproveDocumentFluentHelper approveDocument( @Nonnull final String purchaseContract )
    {
        return new ApproveDocumentFluentHelper(servicePath, purchaseContract);
    }

    @Override
    @Nonnull
    public RejectDocumentFluentHelper rejectDocument( @Nonnull final String purchaseContract )
    {
        return new RejectDocumentFluentHelper(servicePath, purchaseContract);
    }

    @Override
    @Nonnull
    public WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String purchaseContract )
    {
        return new WithdrawFromApprovalFluentHelper(servicePath, purchaseContract);
    }

}
