/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.GetOutputBinaryDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.GetPDFFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.batch.DefaultPurchaseOrderServiceBatch;

/**
 * <p>
 *
 * This service enables you to create purchase orders through an API call from a source system outside SAP S/4HANA
 * Cloud. Furthermore, the service enables you to read, update or delete existing purchase orders from the SAP S/4HANA
 * Cloud system. The service is based on the OData protocol..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ac/d2da57df6cc525e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASEORDER_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASEORDER_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchase Order Integration(SAP_COM_0053), Distributed Manufacturing Integration(SAP_COM_0077)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4R2'>Service Procurement with Ariba Network and SAP
 * Fieldglass(4R2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital
 * Manufacturing Cloud(1NX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchaseOrderService" )
@Deprecated
public class DefaultPurchaseOrderService implements PurchaseOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchaseOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchaseOrderService()
    {
        servicePath = PurchaseOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchaseOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchaseOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchaseOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchaseOrderServiceBatch batch()
    {
        return new DefaultPurchaseOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public POSubcontractingComponentFluentHelper getAllPOSubcontractingComponent()
    {
        return new POSubcontractingComponentFluentHelper(servicePath, "A_POSubcontractingComponent");
    }

    @Override
    @Nonnull
    public POSubcontractingComponentByKeyFluentHelper getPOSubcontractingComponentByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String scheduleLine,
        final String reservationItem,
        final String recordType )
    {
        return new POSubcontractingComponentByKeyFluentHelper(
            servicePath,
            "A_POSubcontractingComponent",
            purchaseOrder,
            purchaseOrderItem,
            scheduleLine,
            reservationItem,
            recordType);
    }

    @Override
    @Nonnull
    public POSubcontractingComponentCreateFluentHelper createPOSubcontractingComponent(
        @Nonnull final POSubcontractingComponent pOSubcontractingComponent )
    {
        return new POSubcontractingComponentCreateFluentHelper(
            servicePath,
            pOSubcontractingComponent,
            "A_POSubcontractingComponent");
    }

    @Override
    @Nonnull
    public POSubcontractingComponentUpdateFluentHelper updatePOSubcontractingComponent(
        @Nonnull final POSubcontractingComponent pOSubcontractingComponent )
    {
        return new POSubcontractingComponentUpdateFluentHelper(
            servicePath,
            pOSubcontractingComponent,
            "A_POSubcontractingComponent");
    }

    @Override
    @Nonnull
    public POSubcontractingComponentDeleteFluentHelper deletePOSubcontractingComponent(
        @Nonnull final POSubcontractingComponent pOSubcontractingComponent )
    {
        return new POSubcontractingComponentDeleteFluentHelper(
            servicePath,
            pOSubcontractingComponent,
            "A_POSubcontractingComponent");
    }

    @Override
    @Nonnull
    public PurchaseOrderFluentHelper getAllPurchaseOrder()
    {
        return new PurchaseOrderFluentHelper(servicePath, "A_PurchaseOrder");
    }

    @Override
    @Nonnull
    public PurchaseOrderByKeyFluentHelper getPurchaseOrderByKey( final String purchaseOrder )
    {
        return new PurchaseOrderByKeyFluentHelper(servicePath, "A_PurchaseOrder", purchaseOrder);
    }

    @Override
    @Nonnull
    public PurchaseOrderCreateFluentHelper createPurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder )
    {
        return new PurchaseOrderCreateFluentHelper(servicePath, purchaseOrder, "A_PurchaseOrder");
    }

    @Override
    @Nonnull
    public PurchaseOrderUpdateFluentHelper updatePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder )
    {
        return new PurchaseOrderUpdateFluentHelper(servicePath, purchaseOrder, "A_PurchaseOrder");
    }

    @Override
    @Nonnull
    public PurchaseOrderDeleteFluentHelper deletePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder )
    {
        return new PurchaseOrderDeleteFluentHelper(servicePath, purchaseOrder, "A_PurchaseOrder");
    }

    @Override
    @Nonnull
    public PurchaseOrderItemFluentHelper getAllPurchaseOrderItem()
    {
        return new PurchaseOrderItemFluentHelper(servicePath, "A_PurchaseOrderItem");
    }

    @Override
    @Nonnull
    public
        PurchaseOrderItemByKeyFluentHelper
        getPurchaseOrderItemByKey( final String purchaseOrder, final String purchaseOrderItem )
    {
        return new PurchaseOrderItemByKeyFluentHelper(
            servicePath,
            "A_PurchaseOrderItem",
            purchaseOrder,
            purchaseOrderItem);
    }

    @Override
    @Nonnull
    public PurchaseOrderItemCreateFluentHelper createPurchaseOrderItem(
        @Nonnull final PurchaseOrderItem purchaseOrderItem )
    {
        return new PurchaseOrderItemCreateFluentHelper(servicePath, purchaseOrderItem, "A_PurchaseOrderItem");
    }

    @Override
    @Nonnull
    public PurchaseOrderItemUpdateFluentHelper updatePurchaseOrderItem(
        @Nonnull final PurchaseOrderItem purchaseOrderItem )
    {
        return new PurchaseOrderItemUpdateFluentHelper(servicePath, purchaseOrderItem, "A_PurchaseOrderItem");
    }

    @Override
    @Nonnull
    public PurchaseOrderItemDeleteFluentHelper deletePurchaseOrderItem(
        @Nonnull final PurchaseOrderItem purchaseOrderItem )
    {
        return new PurchaseOrderItemDeleteFluentHelper(servicePath, purchaseOrderItem, "A_PurchaseOrderItem");
    }

    @Override
    @Nonnull
    public PurchaseOrderItemNoteFluentHelper getAllPurchaseOrderItemNote()
    {
        return new PurchaseOrderItemNoteFluentHelper(servicePath, "A_PurchaseOrderItemNote");
    }

    @Override
    @Nonnull
    public PurchaseOrderItemNoteByKeyFluentHelper getPurchaseOrderItemNoteByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String textObjectType,
        final String language )
    {
        return new PurchaseOrderItemNoteByKeyFluentHelper(
            servicePath,
            "A_PurchaseOrderItemNote",
            purchaseOrder,
            purchaseOrderItem,
            textObjectType,
            language);
    }

    @Override
    @Nonnull
    public PurchaseOrderItemNoteCreateFluentHelper createPurchaseOrderItemNote(
        @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote )
    {
        return new PurchaseOrderItemNoteCreateFluentHelper(
            servicePath,
            purchaseOrderItemNote,
            "A_PurchaseOrderItemNote");
    }

    @Override
    @Nonnull
    public PurchaseOrderItemNoteUpdateFluentHelper updatePurchaseOrderItemNote(
        @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote )
    {
        return new PurchaseOrderItemNoteUpdateFluentHelper(
            servicePath,
            purchaseOrderItemNote,
            "A_PurchaseOrderItemNote");
    }

    @Override
    @Nonnull
    public PurchaseOrderItemNoteDeleteFluentHelper deletePurchaseOrderItemNote(
        @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote )
    {
        return new PurchaseOrderItemNoteDeleteFluentHelper(
            servicePath,
            purchaseOrderItemNote,
            "A_PurchaseOrderItemNote");
    }

    @Override
    @Nonnull
    public PurchaseOrderNoteFluentHelper getAllPurchaseOrderNote()
    {
        return new PurchaseOrderNoteFluentHelper(servicePath, "A_PurchaseOrderNote");
    }

    @Override
    @Nonnull
    public
        PurchaseOrderNoteByKeyFluentHelper
        getPurchaseOrderNoteByKey( final String purchaseOrder, final String textObjectType, final String language )
    {
        return new PurchaseOrderNoteByKeyFluentHelper(
            servicePath,
            "A_PurchaseOrderNote",
            purchaseOrder,
            textObjectType,
            language);
    }

    @Override
    @Nonnull
    public PurchaseOrderNoteCreateFluentHelper createPurchaseOrderNote(
        @Nonnull final PurchaseOrderNote purchaseOrderNote )
    {
        return new PurchaseOrderNoteCreateFluentHelper(servicePath, purchaseOrderNote, "A_PurchaseOrderNote");
    }

    @Override
    @Nonnull
    public PurchaseOrderNoteUpdateFluentHelper updatePurchaseOrderNote(
        @Nonnull final PurchaseOrderNote purchaseOrderNote )
    {
        return new PurchaseOrderNoteUpdateFluentHelper(servicePath, purchaseOrderNote, "A_PurchaseOrderNote");
    }

    @Override
    @Nonnull
    public PurchaseOrderNoteDeleteFluentHelper deletePurchaseOrderNote(
        @Nonnull final PurchaseOrderNote purchaseOrderNote )
    {
        return new PurchaseOrderNoteDeleteFluentHelper(servicePath, purchaseOrderNote, "A_PurchaseOrderNote");
    }

    @Override
    @Nonnull
    public PurchaseOrderScheduleLineFluentHelper getAllPurchaseOrderScheduleLine()
    {
        return new PurchaseOrderScheduleLineFluentHelper(servicePath, "A_PurchaseOrderScheduleLine");
    }

    @Override
    @Nonnull
    public PurchaseOrderScheduleLineByKeyFluentHelper getPurchaseOrderScheduleLineByKey(
        final String purchasingDocument,
        final String purchasingDocumentItem,
        final String scheduleLine )
    {
        return new PurchaseOrderScheduleLineByKeyFluentHelper(
            servicePath,
            "A_PurchaseOrderScheduleLine",
            purchasingDocument,
            purchasingDocumentItem,
            scheduleLine);
    }

    @Override
    @Nonnull
    public PurchaseOrderScheduleLineCreateFluentHelper createPurchaseOrderScheduleLine(
        @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine )
    {
        return new PurchaseOrderScheduleLineCreateFluentHelper(
            servicePath,
            purchaseOrderScheduleLine,
            "A_PurchaseOrderScheduleLine");
    }

    @Override
    @Nonnull
    public PurchaseOrderScheduleLineUpdateFluentHelper updatePurchaseOrderScheduleLine(
        @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine )
    {
        return new PurchaseOrderScheduleLineUpdateFluentHelper(
            servicePath,
            purchaseOrderScheduleLine,
            "A_PurchaseOrderScheduleLine");
    }

    @Override
    @Nonnull
    public PurchaseOrderScheduleLineDeleteFluentHelper deletePurchaseOrderScheduleLine(
        @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine )
    {
        return new PurchaseOrderScheduleLineDeleteFluentHelper(
            servicePath,
            purchaseOrderScheduleLine,
            "A_PurchaseOrderScheduleLine");
    }

    @Override
    @Nonnull
    public PurOrdAccountAssignmentFluentHelper getAllPurOrdAccountAssignment()
    {
        return new PurOrdAccountAssignmentFluentHelper(servicePath, "A_PurOrdAccountAssignment");
    }

    @Override
    @Nonnull
    public PurOrdAccountAssignmentByKeyFluentHelper getPurOrdAccountAssignmentByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String accountAssignmentNumber )
    {
        return new PurOrdAccountAssignmentByKeyFluentHelper(
            servicePath,
            "A_PurOrdAccountAssignment",
            purchaseOrder,
            purchaseOrderItem,
            accountAssignmentNumber);
    }

    @Override
    @Nonnull
    public PurOrdAccountAssignmentCreateFluentHelper createPurOrdAccountAssignment(
        @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment )
    {
        return new PurOrdAccountAssignmentCreateFluentHelper(
            servicePath,
            purOrdAccountAssignment,
            "A_PurOrdAccountAssignment");
    }

    @Override
    @Nonnull
    public PurOrdAccountAssignmentUpdateFluentHelper updatePurOrdAccountAssignment(
        @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment )
    {
        return new PurOrdAccountAssignmentUpdateFluentHelper(
            servicePath,
            purOrdAccountAssignment,
            "A_PurOrdAccountAssignment");
    }

    @Override
    @Nonnull
    public PurOrdAccountAssignmentDeleteFluentHelper deletePurOrdAccountAssignment(
        @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment )
    {
        return new PurOrdAccountAssignmentDeleteFluentHelper(
            servicePath,
            purOrdAccountAssignment,
            "A_PurOrdAccountAssignment");
    }

    @Override
    @Nonnull
    public PurOrdPricingElementFluentHelper getAllPurOrdPricingElement()
    {
        return new PurOrdPricingElementFluentHelper(servicePath, "A_PurOrdPricingElement");
    }

    @Override
    @Nonnull
    public PurOrdPricingElementByKeyFluentHelper getPurOrdPricingElementByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String pricingDocument,
        final String pricingDocumentItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new PurOrdPricingElementByKeyFluentHelper(
            servicePath,
            "A_PurOrdPricingElement",
            purchaseOrder,
            purchaseOrderItem,
            pricingDocument,
            pricingDocumentItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public PurOrdPricingElementCreateFluentHelper createPurOrdPricingElement(
        @Nonnull final PurOrdPricingElement purOrdPricingElement )
    {
        return new PurOrdPricingElementCreateFluentHelper(servicePath, purOrdPricingElement, "A_PurOrdPricingElement");
    }

    @Override
    @Nonnull
    public PurOrdPricingElementUpdateFluentHelper updatePurOrdPricingElement(
        @Nonnull final PurOrdPricingElement purOrdPricingElement )
    {
        return new PurOrdPricingElementUpdateFluentHelper(servicePath, purOrdPricingElement, "A_PurOrdPricingElement");
    }

    @Override
    @Nonnull
    public PurOrdPricingElementDeleteFluentHelper deletePurOrdPricingElement(
        @Nonnull final PurOrdPricingElement purOrdPricingElement )
    {
        return new PurOrdPricingElementDeleteFluentHelper(servicePath, purOrdPricingElement, "A_PurOrdPricingElement");
    }

    @Override
    @Nonnull
    public GetOutputBinaryDataFluentHelper getOutputBinaryData( @Nullable final String purchaseOrder )
    {
        return new GetOutputBinaryDataFluentHelper(servicePath, purchaseOrder);
    }

    @Override
    @Nonnull
    public GetPDFFluentHelper getPDF( @Nonnull final String purchaseOrder )
    {
        return new GetPDFFluentHelper(servicePath, purchaseOrder);
    }

}
