/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.DiscardFromPurchasingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.EnableForPurchasingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.ValidateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.batch.DefaultPurchaseRequisitionServiceBatch;

/**
 * <p>
 * This service helps you to create, read, update and delete purchase requisitions through an API call from a source
 * system outside SAP S/4HANA Cloud. The service contains header, item, account assignment, delivery address, and item
 * text nodes. The information is sent in the request as a payload. The information is used when creating, reading or
 * updating a purchase requisition, with appropriate checks for restricted values and authorizations.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/43/c43f584eff2160e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASEREQ_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASEREQ_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchase Requisition Integration(SAP_COM_0102), SAP S/4HANA Procurement Hub - Ariba GB - Hub to Ariba GB
 * Integration(SAP_COM_0292), Next-Generation Buying Experience Integration(SAP_COM_0545)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2NV'>Guided Buying Capability with SAP Ariba Buying(2NV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O8J'>Requisitioning(O8J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OML'>Physical Inventory - Inventory Count and Adjustment(OML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONV'>Guided Buying Capability with SAP Ariba Buying(ONV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/18J'>Requisitioning(18J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AI'>Next-Generation Buying Experience(4AI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3EN'>Guided Buying for Central Procurement with SAP Ariba
 * Buying(3EN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Requisition</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchaseRequisitionService" )
@Deprecated
public class DefaultPurchaseRequisitionService implements PurchaseRequisitionService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchaseRequisitionService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchaseRequisitionService()
    {
        servicePath = PurchaseRequisitionService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchaseRequisitionService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchaseRequisitionService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchaseRequisitionService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchaseRequisitionServiceBatch batch()
    {
        return new DefaultPurchaseRequisitionServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PurchaseReqnItemTextFluentHelper getAllPurchaseReqnItemText()
    {
        return new PurchaseReqnItemTextFluentHelper(servicePath, "A_PurchaseReqnItemText");
    }

    @Override
    @Nonnull
    public PurchaseReqnItemTextByKeyFluentHelper getPurchaseReqnItemTextByKey(
        final String purchaseRequisition,
        final String purchaseRequisitionItem,
        final String documentText,
        final String technicalObjectType,
        final String language )
    {
        return new PurchaseReqnItemTextByKeyFluentHelper(
            servicePath,
            "A_PurchaseReqnItemText",
            purchaseRequisition,
            purchaseRequisitionItem,
            documentText,
            technicalObjectType,
            language);
    }

    @Override
    @Nonnull
    public PurchaseReqnItemTextCreateFluentHelper createPurchaseReqnItemText(
        @Nonnull final PurchaseReqnItemText purchaseReqnItemText )
    {
        return new PurchaseReqnItemTextCreateFluentHelper(servicePath, purchaseReqnItemText, "A_PurchaseReqnItemText");
    }

    @Override
    @Nonnull
    public PurchaseReqnItemTextUpdateFluentHelper updatePurchaseReqnItemText(
        @Nonnull final PurchaseReqnItemText purchaseReqnItemText )
    {
        return new PurchaseReqnItemTextUpdateFluentHelper(servicePath, purchaseReqnItemText, "A_PurchaseReqnItemText");
    }

    @Override
    @Nonnull
    public PurchaseReqnItemTextDeleteFluentHelper deletePurchaseReqnItemText(
        @Nonnull final PurchaseReqnItemText purchaseReqnItemText )
    {
        return new PurchaseReqnItemTextDeleteFluentHelper(servicePath, purchaseReqnItemText, "A_PurchaseReqnItemText");
    }

    @Override
    @Nonnull
    public PurchaseRequisitionHeaderFluentHelper getAllPurchaseRequisitionHeader()
    {
        return new PurchaseRequisitionHeaderFluentHelper(servicePath, "A_PurchaseRequisitionHeader");
    }

    @Override
    @Nonnull
    public PurchaseRequisitionHeaderByKeyFluentHelper getPurchaseRequisitionHeaderByKey(
        final String purchaseRequisition )
    {
        return new PurchaseRequisitionHeaderByKeyFluentHelper(
            servicePath,
            "A_PurchaseRequisitionHeader",
            purchaseRequisition);
    }

    @Override
    @Nonnull
    public PurchaseRequisitionHeaderCreateFluentHelper createPurchaseRequisitionHeader(
        @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader )
    {
        return new PurchaseRequisitionHeaderCreateFluentHelper(
            servicePath,
            purchaseRequisitionHeader,
            "A_PurchaseRequisitionHeader");
    }

    @Override
    @Nonnull
    public PurchaseRequisitionHeaderUpdateFluentHelper updatePurchaseRequisitionHeader(
        @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader )
    {
        return new PurchaseRequisitionHeaderUpdateFluentHelper(
            servicePath,
            purchaseRequisitionHeader,
            "A_PurchaseRequisitionHeader");
    }

    @Override
    @Nonnull
    public PurchaseRequisitionItemFluentHelper getAllPurchaseRequisitionItem()
    {
        return new PurchaseRequisitionItemFluentHelper(servicePath, "A_PurchaseRequisitionItem");
    }

    @Override
    @Nonnull
    public
        PurchaseRequisitionItemByKeyFluentHelper
        getPurchaseRequisitionItemByKey( final String purchaseRequisition, final String purchaseRequisitionItem )
    {
        return new PurchaseRequisitionItemByKeyFluentHelper(
            servicePath,
            "A_PurchaseRequisitionItem",
            purchaseRequisition,
            purchaseRequisitionItem);
    }

    @Override
    @Nonnull
    public PurchaseRequisitionItemCreateFluentHelper createPurchaseRequisitionItem(
        @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem )
    {
        return new PurchaseRequisitionItemCreateFluentHelper(
            servicePath,
            purchaseRequisitionItem,
            "A_PurchaseRequisitionItem");
    }

    @Override
    @Nonnull
    public PurchaseRequisitionItemUpdateFluentHelper updatePurchaseRequisitionItem(
        @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem )
    {
        return new PurchaseRequisitionItemUpdateFluentHelper(
            servicePath,
            purchaseRequisitionItem,
            "A_PurchaseRequisitionItem");
    }

    @Override
    @Nonnull
    public PurReqAddDeliveryFluentHelper getAllPurReqAddDelivery()
    {
        return new PurReqAddDeliveryFluentHelper(servicePath, "A_PurReqAddDelivery");
    }

    @Override
    @Nonnull
    public
        PurReqAddDeliveryByKeyFluentHelper
        getPurReqAddDeliveryByKey( final String purchaseRequisition, final String purchaseRequisitionItem )
    {
        return new PurReqAddDeliveryByKeyFluentHelper(
            servicePath,
            "A_PurReqAddDelivery",
            purchaseRequisition,
            purchaseRequisitionItem);
    }

    @Override
    @Nonnull
    public PurReqAddDeliveryUpdateFluentHelper updatePurReqAddDelivery(
        @Nonnull final PurReqAddDelivery purReqAddDelivery )
    {
        return new PurReqAddDeliveryUpdateFluentHelper(servicePath, purReqAddDelivery, "A_PurReqAddDelivery");
    }

    @Override
    @Nonnull
    public PurReqnAcctAssgmtFluentHelper getAllPurReqnAcctAssgmt()
    {
        return new PurReqnAcctAssgmtFluentHelper(servicePath, "A_PurReqnAcctAssgmt");
    }

    @Override
    @Nonnull
    public PurReqnAcctAssgmtByKeyFluentHelper getPurReqnAcctAssgmtByKey(
        final String purchaseRequisition,
        final String purchaseRequisitionItem,
        final String purchaseReqnAcctAssgmtNumber )
    {
        return new PurReqnAcctAssgmtByKeyFluentHelper(
            servicePath,
            "A_PurReqnAcctAssgmt",
            purchaseRequisition,
            purchaseRequisitionItem,
            purchaseReqnAcctAssgmtNumber);
    }

    @Override
    @Nonnull
    public PurReqnAcctAssgmtCreateFluentHelper createPurReqnAcctAssgmt(
        @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt )
    {
        return new PurReqnAcctAssgmtCreateFluentHelper(servicePath, purReqnAcctAssgmt, "A_PurReqnAcctAssgmt");
    }

    @Override
    @Nonnull
    public PurReqnAcctAssgmtUpdateFluentHelper updatePurReqnAcctAssgmt(
        @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt )
    {
        return new PurReqnAcctAssgmtUpdateFluentHelper(servicePath, purReqnAcctAssgmt, "A_PurReqnAcctAssgmt");
    }

    @Override
    @Nonnull
    public ValidateFluentHelper validate( @Nonnull final String purchaseRequisition )
    {
        return new ValidateFluentHelper(servicePath, purchaseRequisition);
    }

    @Override
    @Nonnull
    public DiscardFromPurchasingFluentHelper discardFromPurchasing(
        @Nonnull final String purchaseRequisitionItem,
        @Nonnull final String purchaseRequisition )
    {
        return new DiscardFromPurchasingFluentHelper(servicePath, purchaseRequisitionItem, purchaseRequisition);
    }

    @Override
    @Nonnull
    public
        EnableForPurchasingFluentHelper
        enableForPurchasing( @Nonnull final String purchaseRequisitionItem, @Nonnull final String purchaseRequisition )
    {
        return new EnableForPurchasingFluentHelper(servicePath, purchaseRequisitionItem, purchaseRequisition);
    }

}
