/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCat;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroupCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroupDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroupUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMemberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMemberCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMemberDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMemberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMemberUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpendByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpendCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpendDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpendFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpendUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsibleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsibleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsibleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplierCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplierDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplierUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatusUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.batch.DefaultPurchasingCategoryServiceBatch;

/**
 * <p>
 * This service enables you to create, read, and update purchasing categories through an API call.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/6f/c0e604c28749af90ee61d86e58d7c6/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASING_CATEGORY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASING_CATEGORY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchasing Category Integration(SAP_COM_0123)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/19E'>Supplier Classification and Segmentation(19E)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchasing Category</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchasingCategoryService" )
@Deprecated
public class DefaultPurchasingCategoryService implements PurchasingCategoryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchasingCategoryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchasingCategoryService()
    {
        servicePath = PurchasingCategoryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchasingCategoryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchasingCategoryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchasingCategoryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchasingCategoryServiceBatch batch()
    {
        return new DefaultPurchasingCategoryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PurgCatFluentHelper getAllPurgCat()
    {
        return new PurgCatFluentHelper(servicePath, "A_PurgCat");
    }

    @Override
    @Nonnull
    public PurgCatByKeyFluentHelper getPurgCatByKey( final UUID purgCatUUID )
    {
        return new PurgCatByKeyFluentHelper(servicePath, "A_PurgCat", purgCatUUID);
    }

    @Override
    @Nonnull
    public PurgCatCreateFluentHelper createPurgCat( @Nonnull final PurgCat purgCat )
    {
        return new PurgCatCreateFluentHelper(servicePath, purgCat, "A_PurgCat");
    }

    @Override
    @Nonnull
    public PurgCatUpdateFluentHelper updatePurgCat( @Nonnull final PurgCat purgCat )
    {
        return new PurgCatUpdateFluentHelper(servicePath, purgCat, "A_PurgCat");
    }

    @Override
    @Nonnull
    public PurgCatDescriptionFluentHelper getAllPurgCatDescription()
    {
        return new PurgCatDescriptionFluentHelper(servicePath, "A_PurgCatDescription");
    }

    @Override
    @Nonnull
    public PurgCatDescriptionByKeyFluentHelper getPurgCatDescriptionByKey( final UUID purgCatDescriptionUUID )
    {
        return new PurgCatDescriptionByKeyFluentHelper(servicePath, "A_PurgCatDescription", purgCatDescriptionUUID);
    }

    @Override
    @Nonnull
    public PurgCatDescriptionCreateFluentHelper createPurgCatDescription(
        @Nonnull final PurgCatDescription purgCatDescription )
    {
        return new PurgCatDescriptionCreateFluentHelper(servicePath, purgCatDescription, "A_PurgCatDescription");
    }

    @Override
    @Nonnull
    public PurgCatDescriptionUpdateFluentHelper updatePurgCatDescription(
        @Nonnull final PurgCatDescription purgCatDescription )
    {
        return new PurgCatDescriptionUpdateFluentHelper(servicePath, purgCatDescription, "A_PurgCatDescription");
    }

    @Override
    @Nonnull
    public PurgCatDescriptionDeleteFluentHelper deletePurgCatDescription(
        @Nonnull final PurgCatDescription purgCatDescription )
    {
        return new PurgCatDescriptionDeleteFluentHelper(servicePath, purgCatDescription, "A_PurgCatDescription");
    }

    @Override
    @Nonnull
    public PurgCatMaterialGroupFluentHelper getAllPurgCatMaterialGroup()
    {
        return new PurgCatMaterialGroupFluentHelper(servicePath, "A_PurgCatMaterialGroup");
    }

    @Override
    @Nonnull
    public PurgCatMaterialGroupByKeyFluentHelper getPurgCatMaterialGroupByKey( final UUID purCatMaterialGroupUUID )
    {
        return new PurgCatMaterialGroupByKeyFluentHelper(
            servicePath,
            "A_PurgCatMaterialGroup",
            purCatMaterialGroupUUID);
    }

    @Override
    @Nonnull
    public PurgCatMaterialGroupCreateFluentHelper createPurgCatMaterialGroup(
        @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup )
    {
        return new PurgCatMaterialGroupCreateFluentHelper(servicePath, purgCatMaterialGroup, "A_PurgCatMaterialGroup");
    }

    @Override
    @Nonnull
    public PurgCatMaterialGroupUpdateFluentHelper updatePurgCatMaterialGroup(
        @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup )
    {
        return new PurgCatMaterialGroupUpdateFluentHelper(servicePath, purgCatMaterialGroup, "A_PurgCatMaterialGroup");
    }

    @Override
    @Nonnull
    public PurgCatMaterialGroupDeleteFluentHelper deletePurgCatMaterialGroup(
        @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup )
    {
        return new PurgCatMaterialGroupDeleteFluentHelper(servicePath, purgCatMaterialGroup, "A_PurgCatMaterialGroup");
    }

    @Override
    @Nonnull
    public PurgCatMemberFluentHelper getAllPurgCatMember()
    {
        return new PurgCatMemberFluentHelper(servicePath, "A_PurgCatMember");
    }

    @Override
    @Nonnull
    public PurgCatMemberByKeyFluentHelper getPurgCatMemberByKey( final UUID purgCatPartyUUID )
    {
        return new PurgCatMemberByKeyFluentHelper(servicePath, "A_PurgCatMember", purgCatPartyUUID);
    }

    @Override
    @Nonnull
    public PurgCatMemberCreateFluentHelper createPurgCatMember( @Nonnull final PurgCatMember purgCatMember )
    {
        return new PurgCatMemberCreateFluentHelper(servicePath, purgCatMember, "A_PurgCatMember");
    }

    @Override
    @Nonnull
    public PurgCatMemberUpdateFluentHelper updatePurgCatMember( @Nonnull final PurgCatMember purgCatMember )
    {
        return new PurgCatMemberUpdateFluentHelper(servicePath, purgCatMember, "A_PurgCatMember");
    }

    @Override
    @Nonnull
    public PurgCatMemberDeleteFluentHelper deletePurgCatMember( @Nonnull final PurgCatMember purgCatMember )
    {
        return new PurgCatMemberDeleteFluentHelper(servicePath, purgCatMember, "A_PurgCatMember");
    }

    @Override
    @Nonnull
    public PurgCatPlannedSpendFluentHelper getAllPurgCatPlannedSpend()
    {
        return new PurgCatPlannedSpendFluentHelper(servicePath, "A_PurgCatPlannedSpend");
    }

    @Override
    @Nonnull
    public PurgCatPlannedSpendByKeyFluentHelper getPurgCatPlannedSpendByKey( final UUID purgCatPlndSpendUUID )
    {
        return new PurgCatPlannedSpendByKeyFluentHelper(servicePath, "A_PurgCatPlannedSpend", purgCatPlndSpendUUID);
    }

    @Override
    @Nonnull
    public PurgCatPlannedSpendCreateFluentHelper createPurgCatPlannedSpend(
        @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend )
    {
        return new PurgCatPlannedSpendCreateFluentHelper(servicePath, purgCatPlannedSpend, "A_PurgCatPlannedSpend");
    }

    @Override
    @Nonnull
    public PurgCatPlannedSpendUpdateFluentHelper updatePurgCatPlannedSpend(
        @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend )
    {
        return new PurgCatPlannedSpendUpdateFluentHelper(servicePath, purgCatPlannedSpend, "A_PurgCatPlannedSpend");
    }

    @Override
    @Nonnull
    public PurgCatPlannedSpendDeleteFluentHelper deletePurgCatPlannedSpend(
        @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend )
    {
        return new PurgCatPlannedSpendDeleteFluentHelper(servicePath, purgCatPlannedSpend, "A_PurgCatPlannedSpend");
    }

    @Override
    @Nonnull
    public PurgCatPurchaserResponsibleFluentHelper getAllPurgCatPurchaserResponsible()
    {
        return new PurgCatPurchaserResponsibleFluentHelper(servicePath, "A_PurgCatPurchaserResponsible");
    }

    @Override
    @Nonnull
    public PurgCatPurchaserResponsibleByKeyFluentHelper getPurgCatPurchaserResponsibleByKey(
        final UUID purgCatPartyUUID )
    {
        return new PurgCatPurchaserResponsibleByKeyFluentHelper(
            servicePath,
            "A_PurgCatPurchaserResponsible",
            purgCatPartyUUID);
    }

    @Override
    @Nonnull
    public PurgCatPurchaserResponsibleUpdateFluentHelper updatePurgCatPurchaserResponsible(
        @Nonnull final PurgCatPurchaserResponsible purgCatPurchaserResponsible )
    {
        return new PurgCatPurchaserResponsibleUpdateFluentHelper(
            servicePath,
            purgCatPurchaserResponsible,
            "A_PurgCatPurchaserResponsible");
    }

    @Override
    @Nonnull
    public PurgCatSupplierFluentHelper getAllPurgCatSupplier()
    {
        return new PurgCatSupplierFluentHelper(servicePath, "A_PurgCatSupplier");
    }

    @Override
    @Nonnull
    public PurgCatSupplierByKeyFluentHelper getPurgCatSupplierByKey( final UUID purgCatPartyUUID )
    {
        return new PurgCatSupplierByKeyFluentHelper(servicePath, "A_PurgCatSupplier", purgCatPartyUUID);
    }

    @Override
    @Nonnull
    public PurgCatSupplierCreateFluentHelper createPurgCatSupplier( @Nonnull final PurgCatSupplier purgCatSupplier )
    {
        return new PurgCatSupplierCreateFluentHelper(servicePath, purgCatSupplier, "A_PurgCatSupplier");
    }

    @Override
    @Nonnull
    public PurgCatSupplierUpdateFluentHelper updatePurgCatSupplier( @Nonnull final PurgCatSupplier purgCatSupplier )
    {
        return new PurgCatSupplierUpdateFluentHelper(servicePath, purgCatSupplier, "A_PurgCatSupplier");
    }

    @Override
    @Nonnull
    public PurgCatSupplierDeleteFluentHelper deletePurgCatSupplier( @Nonnull final PurgCatSupplier purgCatSupplier )
    {
        return new PurgCatSupplierDeleteFluentHelper(servicePath, purgCatSupplier, "A_PurgCatSupplier");
    }

    @Override
    @Nonnull
    public PurgCatTranslationStatusFluentHelper getAllPurgCatTranslationStatus()
    {
        return new PurgCatTranslationStatusFluentHelper(servicePath, "A_PurgCatTranslationStatus");
    }

    @Override
    @Nonnull
    public PurgCatTranslationStatusByKeyFluentHelper getPurgCatTranslationStatusByKey(
        final UUID purgCatTranslationUUID )
    {
        return new PurgCatTranslationStatusByKeyFluentHelper(
            servicePath,
            "A_PurgCatTranslationStatus",
            purgCatTranslationUUID);
    }

    @Override
    @Nonnull
    public PurgCatTranslationStatusCreateFluentHelper createPurgCatTranslationStatus(
        @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus )
    {
        return new PurgCatTranslationStatusCreateFluentHelper(
            servicePath,
            purgCatTranslationStatus,
            "A_PurgCatTranslationStatus");
    }

    @Override
    @Nonnull
    public PurgCatTranslationStatusUpdateFluentHelper updatePurgCatTranslationStatus(
        @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus )
    {
        return new PurgCatTranslationStatusUpdateFluentHelper(
            servicePath,
            purgCatTranslationStatus,
            "A_PurgCatTranslationStatus");
    }

    @Override
    @Nonnull
    public PurgCatTranslationStatusDeleteFluentHelper deletePurgCatTranslationStatus(
        @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus )
    {
        return new PurgCatTranslationStatusDeleteFluentHelper(
            servicePath,
            purgCatTranslationStatus,
            "A_PurgCatTranslationStatus");
    }

}
