/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.batch.DefaultPurchasingInfoRecordServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound service enables you to create, update, and delete purchasing info records with conditions.
 * The service contains general data, purchase organization data and conditions. It is based on the OData protocol. The
 * information is sent in the request as a payload.All information is used when creating a purchasing info record,
 * including conditions are checked for authorizations. Once the purchasinginfo record has been created, the purchasing
 * info record number is sent in the response. If there are any issues when the purchasing info recordis created, the
 * system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d0/9550c21c0249f39c4b79754077b8d4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INFORECORD_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INFORECORD_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchasing Info Record Integration(SAP_COM_0145)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BML'>Physical Inventory - Inventory Count and Adjustment(BML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchasing Info Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchasingInfoRecordService" )
@Deprecated
public class DefaultPurchasingInfoRecordService implements PurchasingInfoRecordService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchasingInfoRecordService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchasingInfoRecordService()
    {
        servicePath = PurchasingInfoRecordService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchasingInfoRecordService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchasingInfoRecordService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchasingInfoRecordService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchasingInfoRecordServiceBatch batch()
    {
        return new DefaultPurchasingInfoRecordServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PurchasingInfoRecordFluentHelper getAllPurchasingInfoRecord()
    {
        return new PurchasingInfoRecordFluentHelper(servicePath, "A_PurchasingInfoRecord");
    }

    @Override
    @Nonnull
    public PurchasingInfoRecordByKeyFluentHelper getPurchasingInfoRecordByKey( final String purchasingInfoRecord )
    {
        return new PurchasingInfoRecordByKeyFluentHelper(servicePath, "A_PurchasingInfoRecord", purchasingInfoRecord);
    }

    @Override
    @Nonnull
    public PurchasingInfoRecordCreateFluentHelper createPurchasingInfoRecord(
        @Nonnull final PurchasingInfoRecord purchasingInfoRecord )
    {
        return new PurchasingInfoRecordCreateFluentHelper(servicePath, purchasingInfoRecord, "A_PurchasingInfoRecord");
    }

    @Override
    @Nonnull
    public PurchasingInfoRecordUpdateFluentHelper updatePurchasingInfoRecord(
        @Nonnull final PurchasingInfoRecord purchasingInfoRecord )
    {
        return new PurchasingInfoRecordUpdateFluentHelper(servicePath, purchasingInfoRecord, "A_PurchasingInfoRecord");
    }

    @Override
    @Nonnull
    public PurgInfoRecdOrgPlantDataFluentHelper getAllPurgInfoRecdOrgPlantData()
    {
        return new PurgInfoRecdOrgPlantDataFluentHelper(servicePath, "A_PurgInfoRecdOrgPlantData");
    }

    @Override
    @Nonnull
    public PurgInfoRecdOrgPlantDataByKeyFluentHelper getPurgInfoRecdOrgPlantDataByKey(
        final String purchasingInfoRecord,
        final String purchasingInfoRecordCategory,
        final String purchasingOrganization,
        final String plant )
    {
        return new PurgInfoRecdOrgPlantDataByKeyFluentHelper(
            servicePath,
            "A_PurgInfoRecdOrgPlantData",
            purchasingInfoRecord,
            purchasingInfoRecordCategory,
            purchasingOrganization,
            plant);
    }

    @Override
    @Nonnull
    public PurgInfoRecdOrgPlantDataCreateFluentHelper createPurgInfoRecdOrgPlantData(
        @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData )
    {
        return new PurgInfoRecdOrgPlantDataCreateFluentHelper(
            servicePath,
            purgInfoRecdOrgPlantData,
            "A_PurgInfoRecdOrgPlantData");
    }

    @Override
    @Nonnull
    public PurgInfoRecdOrgPlantDataUpdateFluentHelper updatePurgInfoRecdOrgPlantData(
        @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData )
    {
        return new PurgInfoRecdOrgPlantDataUpdateFluentHelper(
            servicePath,
            purgInfoRecdOrgPlantData,
            "A_PurgInfoRecdOrgPlantData");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnFluentHelper getAllPurInfoRecdPrcgCndn()
    {
        return new PurInfoRecdPrcgCndnFluentHelper(servicePath, "A_PurInfoRecdPrcgCndn");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnByKeyFluentHelper getPurInfoRecdPrcgCndnByKey( final String conditionRecord )
    {
        return new PurInfoRecdPrcgCndnByKeyFluentHelper(servicePath, "A_PurInfoRecdPrcgCndn", conditionRecord);
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnCreateFluentHelper createPurInfoRecdPrcgCndn(
        @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn )
    {
        return new PurInfoRecdPrcgCndnCreateFluentHelper(servicePath, purInfoRecdPrcgCndn, "A_PurInfoRecdPrcgCndn");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnUpdateFluentHelper updatePurInfoRecdPrcgCndn(
        @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn )
    {
        return new PurInfoRecdPrcgCndnUpdateFluentHelper(servicePath, purInfoRecdPrcgCndn, "A_PurInfoRecdPrcgCndn");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnScaleFluentHelper getAllPurInfoRecdPrcgCndnScale()
    {
        return new PurInfoRecdPrcgCndnScaleFluentHelper(servicePath, "A_PurInfoRecdPrcgCndnScale");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnScaleByKeyFluentHelper getPurInfoRecdPrcgCndnScaleByKey(
        final String conditionRecord,
        final String conditionSequentialNumber,
        final String conditionScaleLine )
    {
        return new PurInfoRecdPrcgCndnScaleByKeyFluentHelper(
            servicePath,
            "A_PurInfoRecdPrcgCndnScale",
            conditionRecord,
            conditionSequentialNumber,
            conditionScaleLine);
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnScaleCreateFluentHelper createPurInfoRecdPrcgCndnScale(
        @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale )
    {
        return new PurInfoRecdPrcgCndnScaleCreateFluentHelper(
            servicePath,
            purInfoRecdPrcgCndnScale,
            "A_PurInfoRecdPrcgCndnScale");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnScaleUpdateFluentHelper updatePurInfoRecdPrcgCndnScale(
        @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale )
    {
        return new PurInfoRecdPrcgCndnScaleUpdateFluentHelper(
            servicePath,
            purInfoRecdPrcgCndnScale,
            "A_PurInfoRecdPrcgCndnScale");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnScaleDeleteFluentHelper deletePurInfoRecdPrcgCndnScale(
        @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale )
    {
        return new PurInfoRecdPrcgCndnScaleDeleteFluentHelper(
            servicePath,
            purInfoRecdPrcgCndnScale,
            "A_PurInfoRecdPrcgCndnScale");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnValidityFluentHelper getAllPurInfoRecdPrcgCndnValidity()
    {
        return new PurInfoRecdPrcgCndnValidityFluentHelper(servicePath, "A_PurInfoRecdPrcgCndnValidity");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnValidityByKeyFluentHelper getPurInfoRecdPrcgCndnValidityByKey(
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate )
    {
        return new PurInfoRecdPrcgCndnValidityByKeyFluentHelper(
            servicePath,
            "A_PurInfoRecdPrcgCndnValidity",
            conditionRecord,
            conditionValidityEndDate);
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnValidityCreateFluentHelper createPurInfoRecdPrcgCndnValidity(
        @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity )
    {
        return new PurInfoRecdPrcgCndnValidityCreateFluentHelper(
            servicePath,
            purInfoRecdPrcgCndnValidity,
            "A_PurInfoRecdPrcgCndnValidity");
    }

    @Override
    @Nonnull
    public PurInfoRecdPrcgCndnValidityUpdateFluentHelper updatePurInfoRecdPrcgCndnValidity(
        @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity )
    {
        return new PurInfoRecdPrcgCndnValidityUpdateFluentHelper(
            servicePath,
            purInfoRecdPrcgCndnValidity,
            "A_PurInfoRecdPrcgCndnValidity");
    }

    @Override
    @Nonnull
    public PurInfoRecdSuplmntPrcgCndnFluentHelper getAllPurInfoRecdSuplmntPrcgCndn()
    {
        return new PurInfoRecdSuplmntPrcgCndnFluentHelper(servicePath, "A_PurInfoRecdSuplmntPrcgCndn");
    }

    @Override
    @Nonnull
    public
        PurInfoRecdSuplmntPrcgCndnByKeyFluentHelper
        getPurInfoRecdSuplmntPrcgCndnByKey( final String conditionRecord, final String conditionSequentialNumber )
    {
        return new PurInfoRecdSuplmntPrcgCndnByKeyFluentHelper(
            servicePath,
            "A_PurInfoRecdSuplmntPrcgCndn",
            conditionRecord,
            conditionSequentialNumber);
    }

    @Override
    @Nonnull
    public PurInfoRecdSuplmntPrcgCndnCreateFluentHelper createPurInfoRecdSuplmntPrcgCndn(
        @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn )
    {
        return new PurInfoRecdSuplmntPrcgCndnCreateFluentHelper(
            servicePath,
            purInfoRecdSuplmntPrcgCndn,
            "A_PurInfoRecdSuplmntPrcgCndn");
    }

    @Override
    @Nonnull
    public PurInfoRecdSuplmntPrcgCndnUpdateFluentHelper updatePurInfoRecdSuplmntPrcgCndn(
        @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn )
    {
        return new PurInfoRecdSuplmntPrcgCndnUpdateFluentHelper(
            servicePath,
            purInfoRecdSuplmntPrcgCndn,
            "A_PurInfoRecdSuplmntPrcgCndn");
    }

    @Override
    @Nonnull
    public PurInfoRecdSuplmntPrcgCndnDeleteFluentHelper deletePurInfoRecdSuplmntPrcgCndn(
        @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn )
    {
        return new PurInfoRecdSuplmntPrcgCndnDeleteFluentHelper(
            servicePath,
            purInfoRecdSuplmntPrcgCndn,
            "A_PurInfoRecdSuplmntPrcgCndn");
    }

}
