/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.batch.DefaultPurchasingQuotaArrangementServiceBatch;

/**
 * <p>
 * This service helps you to create, read, update, and delete quota arrangements through an API call from a source
 * system outside SAP S/4HANA Cloud or SAP S/4HANA. The service contains quota arrangement header and item. The
 * information is sent in the request as a payload. The information is used when creating, reading or updating a quota
 * arrangement, with appropriate checks for restricted values and authorizations.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4a/a0343345884bd2bf7195f1072d9679/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PUR_QUOTA_ARRANGEMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PUR_QUOTA_ARRANGEMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchasing Quota Arrangement Integration(SAP_COM_0166)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMR'>Scheduling Agreements in Procurement(BMR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OML'>Physical Inventory - Inventory Count and Adjustment(OML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMR'>Scheduling Agreements in Procurement(OMR)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchasing Quota Arrangement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchasingQuotaArrangementService" )
@Deprecated
public class DefaultPurchasingQuotaArrangementService implements PurchasingQuotaArrangementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchasingQuotaArrangementService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchasingQuotaArrangementService()
    {
        servicePath = PurchasingQuotaArrangementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchasingQuotaArrangementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchasingQuotaArrangementService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchasingQuotaArrangementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchasingQuotaArrangementServiceBatch batch()
    {
        return new DefaultPurchasingQuotaArrangementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PurchasingQuotaArrangementFluentHelper getAllPurchasingQuotaArrangement()
    {
        return new PurchasingQuotaArrangementFluentHelper(servicePath, "A_PurchasingQuotaArrangement");
    }

    @Override
    @Nonnull
    public PurchasingQuotaArrangementByKeyFluentHelper getPurchasingQuotaArrangementByKey(
        final String quotaArrangement )
    {
        return new PurchasingQuotaArrangementByKeyFluentHelper(
            servicePath,
            "A_PurchasingQuotaArrangement",
            quotaArrangement);
    }

    @Override
    @Nonnull
    public PurchasingQuotaArrangementCreateFluentHelper createPurchasingQuotaArrangement(
        @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement )
    {
        return new PurchasingQuotaArrangementCreateFluentHelper(
            servicePath,
            purchasingQuotaArrangement,
            "A_PurchasingQuotaArrangement");
    }

    @Override
    @Nonnull
    public PurchasingQuotaArrangementUpdateFluentHelper updatePurchasingQuotaArrangement(
        @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement )
    {
        return new PurchasingQuotaArrangementUpdateFluentHelper(
            servicePath,
            purchasingQuotaArrangement,
            "A_PurchasingQuotaArrangement");
    }

    @Override
    @Nonnull
    public PurchasingQuotaArrangementDeleteFluentHelper deletePurchasingQuotaArrangement(
        @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement )
    {
        return new PurchasingQuotaArrangementDeleteFluentHelper(
            servicePath,
            purchasingQuotaArrangement,
            "A_PurchasingQuotaArrangement");
    }

    @Override
    @Nonnull
    public PurgQuotaArrangementItemFluentHelper getAllPurgQuotaArrangementItem()
    {
        return new PurgQuotaArrangementItemFluentHelper(servicePath, "A_PurgQuotaArrangementItem");
    }

    @Override
    @Nonnull
    public
        PurgQuotaArrangementItemByKeyFluentHelper
        getPurgQuotaArrangementItemByKey( final String quotaArrangement, final String quotaArrangementItem )
    {
        return new PurgQuotaArrangementItemByKeyFluentHelper(
            servicePath,
            "A_PurgQuotaArrangementItem",
            quotaArrangement,
            quotaArrangementItem);
    }

    @Override
    @Nonnull
    public PurgQuotaArrangementItemCreateFluentHelper createPurgQuotaArrangementItem(
        @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem )
    {
        return new PurgQuotaArrangementItemCreateFluentHelper(
            servicePath,
            purgQuotaArrangementItem,
            "A_PurgQuotaArrangementItem");
    }

    @Override
    @Nonnull
    public PurgQuotaArrangementItemUpdateFluentHelper updatePurgQuotaArrangementItem(
        @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem )
    {
        return new PurgQuotaArrangementItemUpdateFluentHelper(
            servicePath,
            purgQuotaArrangementItem,
            "A_PurgQuotaArrangementItem");
    }

    @Override
    @Nonnull
    public PurgQuotaArrangementItemDeleteFluentHelper deletePurgQuotaArrangementItem(
        @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem )
    {
        return new PurgQuotaArrangementItemDeleteFluentHelper(
            servicePath,
            purgQuotaArrangementItem,
            "A_PurgQuotaArrangementItem");
    }

}
