/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.batch.DefaultPurchasingSourceServiceBatch;

/**
 * <p>
 * This synchronous inbound service enables you to create, update, and delete purchasing source lists. It is based on
 * the OData protocol. The information is sent in the request as a payload. All information is used when creating a
 * purchasing source list, and they are checked for authorizations. Once the purchasing source list has been created,
 * the purchasing source list number is sent in the response. If there are any issues when the purchasing source list is
 * created, the system displays error messages in the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/56/92d23783a94d8282659356113c384f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASING_SOURCE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASING_SOURCE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchasing Source Integration(SAP_COM_0162)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMD'>Purchase Contract(BMD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMD'>Purchase Contract(OMD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Source List in Procurement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultPurchasingSourceService" )
@Deprecated
public class DefaultPurchasingSourceService implements PurchasingSourceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link PurchasingSourceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultPurchasingSourceService()
    {
        servicePath = PurchasingSourceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultPurchasingSourceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPurchasingSourceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultPurchasingSourceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultPurchasingSourceServiceBatch batch()
    {
        return new DefaultPurchasingSourceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public PurchasingSourceFluentHelper getAllPurchasingSource()
    {
        return new PurchasingSourceFluentHelper(servicePath, "A_PurchasingSource");
    }

    @Override
    @Nonnull
    public
        PurchasingSourceByKeyFluentHelper
        getPurchasingSourceByKey( final String material, final String plant, final String sourceListRecord )
    {
        return new PurchasingSourceByKeyFluentHelper(
            servicePath,
            "A_PurchasingSource",
            material,
            plant,
            sourceListRecord);
    }

    @Override
    @Nonnull
    public PurchasingSourceCreateFluentHelper createPurchasingSource( @Nonnull final PurchasingSource purchasingSource )
    {
        return new PurchasingSourceCreateFluentHelper(servicePath, purchasingSource, "A_PurchasingSource");
    }

    @Override
    @Nonnull
    public PurchasingSourceUpdateFluentHelper updatePurchasingSource( @Nonnull final PurchasingSource purchasingSource )
    {
        return new PurchasingSourceUpdateFluentHelper(servicePath, purchasingSource, "A_PurchasingSource");
    }

    @Override
    @Nonnull
    public PurchasingSourceDeleteFluentHelper deletePurchasingSource( @Nonnull final PurchasingSource purchasingSource )
    {
        return new PurchasingSourceDeleteFluentHelper(servicePath, purchasingSource, "A_PurchasingSource");
    }

}
