/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.batch.DefaultQualityInfoRecordServiceBatch;

/**
 * <p>
 *
 * The data related to a quality info record and first article inspection has one entity type each. For read operations,
 * filter information must be sent according to the OData protocol. All filter information is utilized when retrieving
 * quality info records or data related to first article inspection. The detailed entity data is sent in the response.
 * If any issues arise when quality info records or data related to first article inspection is retrieved, the system
 * displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a5/77b05467254dd6a186e78c9acd1f7b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_QUALITYINFORECORD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_QUALITYINFORECORD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Info Record Integration(SAP_COM_0358), Digital Manufacturing Cloud for Network with Quality Info Record
 * Integration(SAP_COM_0557)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchasing Quality Info Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultQualityInfoRecordService" )
@Deprecated
public class DefaultQualityInfoRecordService implements QualityInfoRecordService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link QualityInfoRecordService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultQualityInfoRecordService()
    {
        servicePath = QualityInfoRecordService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultQualityInfoRecordService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultQualityInfoRecordService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultQualityInfoRecordService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultQualityInfoRecordServiceBatch batch()
    {
        return new DefaultQualityInfoRecordServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public QualityFirstArticleInspectionFluentHelper getAllQualityFirstArticleInspection()
    {
        return new QualityFirstArticleInspectionFluentHelper(servicePath, "QualityFirstArticleInspection");
    }

    @Override
    @Nonnull
    public QualityFirstArticleInspectionByKeyFluentHelper getQualityFirstArticleInspectionByKey(
        final String material,
        final String qltyInProcmtIntID,
        final String qltyInProcmt1stArticleInsp )
    {
        return new QualityFirstArticleInspectionByKeyFluentHelper(
            servicePath,
            "QualityFirstArticleInspection",
            material,
            qltyInProcmtIntID,
            qltyInProcmt1stArticleInsp);
    }

    @Override
    @Nonnull
    public QualityFirstArticleInspectionCreateFluentHelper createQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection )
    {
        return new QualityFirstArticleInspectionCreateFluentHelper(
            servicePath,
            qualityFirstArticleInspection,
            "QualityFirstArticleInspection");
    }

    @Override
    @Nonnull
    public QualityFirstArticleInspectionUpdateFluentHelper updateQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection )
    {
        return new QualityFirstArticleInspectionUpdateFluentHelper(
            servicePath,
            qualityFirstArticleInspection,
            "QualityFirstArticleInspection");
    }

    @Override
    @Nonnull
    public QualityFirstArticleInspectionDeleteFluentHelper deleteQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection )
    {
        return new QualityFirstArticleInspectionDeleteFluentHelper(
            servicePath,
            qualityFirstArticleInspection,
            "QualityFirstArticleInspection");
    }

    @Override
    @Nonnull
    public QualityInProcurementFluentHelper getAllQualityInProcurement()
    {
        return new QualityInProcurementFluentHelper(servicePath, "QualityInProcurement");
    }

    @Override
    @Nonnull
    public
        QualityInProcurementByKeyFluentHelper
        getQualityInProcurementByKey( final String material, final String qltyInProcmtIntID )
    {
        return new QualityInProcurementByKeyFluentHelper(
            servicePath,
            "QualityInProcurement",
            material,
            qltyInProcmtIntID);
    }

    @Override
    @Nonnull
    public QualityInProcurementCreateFluentHelper createQualityInProcurement(
        @Nonnull final QualityInProcurement qualityInProcurement )
    {
        return new QualityInProcurementCreateFluentHelper(servicePath, qualityInProcurement, "QualityInProcurement");
    }

    @Override
    @Nonnull
    public QualityInProcurementUpdateFluentHelper updateQualityInProcurement(
        @Nonnull final QualityInProcurement qualityInProcurement )
    {
        return new QualityInProcurementUpdateFluentHelper(servicePath, qualityInProcurement, "QualityInProcurement");
    }

    @Override
    @Nonnull
    public QualityInProcurementDeleteFluentHelper deleteQualityInProcurement(
        @Nonnull final QualityInProcurement qualityInProcurement )
    {
        return new QualityInProcurementDeleteFluentHelper(servicePath, qualityInProcurement, "QualityInProcurement");
    }

}
