/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetTrigger_valuationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.batch.DefaultQualityInspectionDataServiceBatch;

/**
 * <p>
 *
 * In the SAP system, you process quality inspections on the basis of inspection lots. The data relating to a quality
 * inspection is grouped into several entities. With this service it is possible, for example, to update inspection lot
 * header data or to create inspection results and usage decisions..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/61/ff4c3780864ce1b0822d9c5e6cd3bb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INSPECTIONLOT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INSPECTIONLOT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Inspection Process Integration(SAP_COM_0318)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Lot</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultQualityInspectionDataService" )
@Deprecated
public class DefaultQualityInspectionDataService implements QualityInspectionDataService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link QualityInspectionDataService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultQualityInspectionDataService()
    {
        servicePath = QualityInspectionDataService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultQualityInspectionDataService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultQualityInspectionDataService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultQualityInspectionDataService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultQualityInspectionDataServiceBatch batch()
    {
        return new DefaultQualityInspectionDataServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public InspectionCharacteristicFluentHelper getAllInspectionCharacteristic()
    {
        return new InspectionCharacteristicFluentHelper(servicePath, "A_InspectionCharacteristic");
    }

    @Override
    @Nonnull
    public InspectionCharacteristicByKeyFluentHelper getInspectionCharacteristicByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic )
    {
        return new InspectionCharacteristicByKeyFluentHelper(
            servicePath,
            "A_InspectionCharacteristic",
            inspectionLot,
            inspPlanOperationInternalID,
            inspectionCharacteristic);
    }

    @Override
    @Nonnull
    public InspectionCharacteristicCreateFluentHelper createInspectionCharacteristic(
        @Nonnull final InspectionCharacteristic inspectionCharacteristic )
    {
        return new InspectionCharacteristicCreateFluentHelper(
            servicePath,
            inspectionCharacteristic,
            "A_InspectionCharacteristic");
    }

    @Override
    @Nonnull
    public InspectionLotFluentHelper getAllInspectionLot()
    {
        return new InspectionLotFluentHelper(servicePath, "A_InspectionLot");
    }

    @Override
    @Nonnull
    public InspectionLotByKeyFluentHelper getInspectionLotByKey( final String inspectionLot )
    {
        return new InspectionLotByKeyFluentHelper(servicePath, "A_InspectionLot", inspectionLot);
    }

    @Override
    @Nonnull
    public InspectionLotCreateFluentHelper createInspectionLot( @Nonnull final InspectionLot inspectionLot )
    {
        return new InspectionLotCreateFluentHelper(servicePath, inspectionLot, "A_InspectionLot");
    }

    @Override
    @Nonnull
    public InspectionLotUpdateFluentHelper updateInspectionLot( @Nonnull final InspectionLot inspectionLot )
    {
        return new InspectionLotUpdateFluentHelper(servicePath, inspectionLot, "A_InspectionLot");
    }

    @Override
    @Nonnull
    public InspectionLotWithStatusFluentHelper getAllInspectionLotWithStatus()
    {
        return new InspectionLotWithStatusFluentHelper(servicePath, "A_InspectionLotWithStatus");
    }

    @Override
    @Nonnull
    public InspectionLotWithStatusByKeyFluentHelper getInspectionLotWithStatusByKey( final String inspectionLot )
    {
        return new InspectionLotWithStatusByKeyFluentHelper(servicePath, "A_InspectionLotWithStatus", inspectionLot);
    }

    @Override
    @Nonnull
    public InspectionOperationFluentHelper getAllInspectionOperation()
    {
        return new InspectionOperationFluentHelper(servicePath, "A_InspectionOperation");
    }

    @Override
    @Nonnull
    public
        InspectionOperationByKeyFluentHelper
        getInspectionOperationByKey( final String inspectionLot, final String inspPlanOperationInternalID )
    {
        return new InspectionOperationByKeyFluentHelper(
            servicePath,
            "A_InspectionOperation",
            inspectionLot,
            inspPlanOperationInternalID);
    }

    @Override
    @Nonnull
    public InspectionResultFluentHelper getAllInspectionResult()
    {
        return new InspectionResultFluentHelper(servicePath, "A_InspectionResult");
    }

    @Override
    @Nonnull
    public InspectionResultByKeyFluentHelper getInspectionResultByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic )
    {
        return new InspectionResultByKeyFluentHelper(
            servicePath,
            "A_InspectionResult",
            inspectionLot,
            inspPlanOperationInternalID,
            inspectionCharacteristic);
    }

    @Override
    @Nonnull
    public InspectionResultCreateFluentHelper createInspectionResult( @Nonnull final InspectionResult inspectionResult )
    {
        return new InspectionResultCreateFluentHelper(servicePath, inspectionResult, "A_InspectionResult");
    }

    @Override
    @Nonnull
    public InspectionResultUpdateFluentHelper updateInspectionResult( @Nonnull final InspectionResult inspectionResult )
    {
        return new InspectionResultUpdateFluentHelper(servicePath, inspectionResult, "A_InspectionResult");
    }

    @Override
    @Nonnull
    public InspectionResultValueFluentHelper getAllInspectionResultValue()
    {
        return new InspectionResultValueFluentHelper(servicePath, "A_InspectionResultValue");
    }

    @Override
    @Nonnull
    public InspectionResultValueByKeyFluentHelper getInspectionResultValueByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic,
        final String inspResultValueInternalID )
    {
        return new InspectionResultValueByKeyFluentHelper(
            servicePath,
            "A_InspectionResultValue",
            inspectionLot,
            inspPlanOperationInternalID,
            inspectionCharacteristic,
            inspResultValueInternalID);
    }

    @Override
    @Nonnull
    public InspectionResultValueCreateFluentHelper createInspectionResultValue(
        @Nonnull final InspectionResultValue inspectionResultValue )
    {
        return new InspectionResultValueCreateFluentHelper(
            servicePath,
            inspectionResultValue,
            "A_InspectionResultValue");
    }

    @Override
    @Nonnull
    public InspectionResultValueUpdateFluentHelper updateInspectionResultValue(
        @Nonnull final InspectionResultValue inspectionResultValue )
    {
        return new InspectionResultValueUpdateFluentHelper(
            servicePath,
            inspectionResultValue,
            "A_InspectionResultValue");
    }

    @Override
    @Nonnull
    public InspectionSubsetFluentHelper getAllInspectionSubset()
    {
        return new InspectionSubsetFluentHelper(servicePath, "A_InspectionSubset");
    }

    @Override
    @Nonnull
    public InspectionSubsetByKeyFluentHelper getInspectionSubsetByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionSubsetInternalID )
    {
        return new InspectionSubsetByKeyFluentHelper(
            servicePath,
            "A_InspectionSubset",
            inspectionLot,
            inspPlanOperationInternalID,
            inspectionSubsetInternalID);
    }

    @Override
    @Nonnull
    public InspectionSubsetCreateFluentHelper createInspectionSubset( @Nonnull final InspectionSubset inspectionSubset )
    {
        return new InspectionSubsetCreateFluentHelper(servicePath, inspectionSubset, "A_InspectionSubset");
    }

    @Override
    @Nonnull
    public InspectionSubsetUpdateFluentHelper updateInspectionSubset( @Nonnull final InspectionSubset inspectionSubset )
    {
        return new InspectionSubsetUpdateFluentHelper(servicePath, inspectionSubset, "A_InspectionSubset");
    }

    @Override
    @Nonnull
    public InspLotMatlDocItemFluentHelper getAllInspLotMatlDocItem()
    {
        return new InspLotMatlDocItemFluentHelper(servicePath, "A_InspLotMatlDocItem");
    }

    @Override
    @Nonnull
    public
        InspLotMatlDocItemByKeyFluentHelper
        getInspLotMatlDocItemByKey( final String inspectionLot, final String inspLotMatlDocItem )
    {
        return new InspLotMatlDocItemByKeyFluentHelper(
            servicePath,
            "A_InspLotMatlDocItem",
            inspectionLot,
            inspLotMatlDocItem);
    }

    @Override
    @Nonnull
    public InspLotMatlDocItemCreateFluentHelper createInspLotMatlDocItem(
        @Nonnull final InspLotMatlDocItem inspLotMatlDocItem )
    {
        return new InspLotMatlDocItemCreateFluentHelper(servicePath, inspLotMatlDocItem, "A_InspLotMatlDocItem");
    }

    @Override
    @Nonnull
    public InspLotMatlDocItmSrlNmbrFluentHelper getAllInspLotMatlDocItmSrlNmbr()
    {
        return new InspLotMatlDocItmSrlNmbrFluentHelper(servicePath, "A_InspLotMatlDocItmSrlNmbr");
    }

    @Override
    @Nonnull
    public InspLotMatlDocItmSrlNmbrByKeyFluentHelper getInspLotMatlDocItmSrlNmbrByKey(
        final String inspectionLot,
        final String inspLotMatlDocItem,
        final String equipment )
    {
        return new InspLotMatlDocItmSrlNmbrByKeyFluentHelper(
            servicePath,
            "A_InspLotMatlDocItmSrlNmbr",
            inspectionLot,
            inspLotMatlDocItem,
            equipment);
    }

    @Override
    @Nonnull
    public InspLotSerialNumberFluentHelper getAllInspLotSerialNumber()
    {
        return new InspLotSerialNumberFluentHelper(servicePath, "A_InspLotSerialNumber");
    }

    @Override
    @Nonnull
    public
        InspLotSerialNumberByKeyFluentHelper
        getInspLotSerialNumberByKey( final String inspectionLot, final String serialNumber )
    {
        return new InspLotSerialNumberByKeyFluentHelper(
            servicePath,
            "A_InspLotSerialNumber",
            inspectionLot,
            serialNumber);
    }

    @Override
    @Nonnull
    public InspLotUsageDecisionFluentHelper getAllInspLotUsageDecision()
    {
        return new InspLotUsageDecisionFluentHelper(servicePath, "A_InspLotUsageDecision");
    }

    @Override
    @Nonnull
    public InspLotUsageDecisionByKeyFluentHelper getInspLotUsageDecisionByKey( final String inspectionLot )
    {
        return new InspLotUsageDecisionByKeyFluentHelper(servicePath, "A_InspLotUsageDecision", inspectionLot);
    }

    @Override
    @Nonnull
    public InspLotUsageDecisionCreateFluentHelper createInspLotUsageDecision(
        @Nonnull final InspLotUsageDecision inspLotUsageDecision )
    {
        return new InspLotUsageDecisionCreateFluentHelper(servicePath, inspLotUsageDecision, "A_InspLotUsageDecision");
    }

    @Override
    @Nonnull
    public InspLotUsageDecisionUpdateFluentHelper updateInspLotUsageDecision(
        @Nonnull final InspLotUsageDecision inspLotUsageDecision )
    {
        return new InspLotUsageDecisionUpdateFluentHelper(servicePath, inspLotUsageDecision, "A_InspLotUsageDecision");
    }

    @Override
    @Nonnull
    public InspSampleCharacteristicFluentHelper getAllInspSampleCharacteristic()
    {
        return new InspSampleCharacteristicFluentHelper(servicePath, "A_InspSampleCharacteristic");
    }

    @Override
    @Nonnull
    public InspSampleCharacteristicByKeyFluentHelper getInspSampleCharacteristicByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic,
        final String inspectionSubsetInternalID )
    {
        return new InspSampleCharacteristicByKeyFluentHelper(
            servicePath,
            "A_InspSampleCharacteristic",
            inspectionLot,
            inspPlanOperationInternalID,
            inspectionCharacteristic,
            inspectionSubsetInternalID);
    }

    @Override
    @Nonnull
    public InspSampleResultFluentHelper getAllInspSampleResult()
    {
        return new InspSampleResultFluentHelper(servicePath, "A_InspSampleResult");
    }

    @Override
    @Nonnull
    public InspSampleResultByKeyFluentHelper getInspSampleResultByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic,
        final String inspectionSubsetInternalID )
    {
        return new InspSampleResultByKeyFluentHelper(
            servicePath,
            "A_InspSampleResult",
            inspectionLot,
            inspPlanOperationInternalID,
            inspectionCharacteristic,
            inspectionSubsetInternalID);
    }

    @Override
    @Nonnull
    public InspSampleResultCreateFluentHelper createInspSampleResult( @Nonnull final InspSampleResult inspSampleResult )
    {
        return new InspSampleResultCreateFluentHelper(servicePath, inspSampleResult, "A_InspSampleResult");
    }

    @Override
    @Nonnull
    public InspSampleResultUpdateFluentHelper updateInspSampleResult( @Nonnull final InspSampleResult inspSampleResult )
    {
        return new InspSampleResultUpdateFluentHelper(servicePath, inspSampleResult, "A_InspSampleResult");
    }

    @Override
    @Nonnull
    public InspectionSubsetTrigger_valuationFluentHelper inspectionSubsetTrigger_valuation(
        @Nonnull final String inspectionLot,
        @Nonnull final String inspPlanOperationInternalID,
        @Nonnull final String inspectionSubsetInternalID )
    {
        return new InspectionSubsetTrigger_valuationFluentHelper(
            servicePath,
            inspectionLot,
            inspPlanOperationInternalID,
            inspectionSubsetInternalID);
    }

}
