/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstanceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstanceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInstByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInstFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchemaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchemaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthCompByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthCompFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.batch.DefaultRealSubstanceServiceBatch;

/**
 * <p>
 *
 * This service contains data belonging to the real substance header, such as creation date and header status, as well
 * as other important information, for example material assignments, language-dependent and independent descriptions,
 * estimated price, total solids, and density. You can also read a real substance&#39;s standard composition, as well as
 * diet, religious, GMO information..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c8/004c0f6fd94c2fbf9803ddd77307ab/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_REALSUBSTANCE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_REALSUBSTANCE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Recipe Development Integration(SAP_COM_0136)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1QA'>Specification Management for Recipes(1QA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QC'>Formulation - Recipe Development(1QC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Recipe Real Substance</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultRealSubstanceService" )
@Deprecated
public class DefaultRealSubstanceService implements RealSubstanceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link RealSubstanceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultRealSubstanceService()
    {
        servicePath = RealSubstanceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultRealSubstanceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultRealSubstanceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultRealSubstanceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultRealSubstanceServiceBatch batch()
    {
        return new DefaultRealSubstanceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProductFluentHelper getAllProduct()
    {
        return new ProductFluentHelper(servicePath, "A_Product");
    }

    @Override
    @Nonnull
    public ProductByKeyFluentHelper getProductByKey( final String product )
    {
        return new ProductByKeyFluentHelper(servicePath, "A_Product", product);
    }

    @Override
    @Nonnull
    public ProductCreateFluentHelper createProduct( @Nonnull final Product product )
    {
        return new ProductCreateFluentHelper(servicePath, product, "A_Product");
    }

    @Override
    @Nonnull
    public ProductUpdateFluentHelper updateProduct( @Nonnull final Product product )
    {
        return new ProductUpdateFluentHelper(servicePath, product, "A_Product");
    }

    @Override
    @Nonnull
    public ProductDescriptionFluentHelper getAllProductDescription()
    {
        return new ProductDescriptionFluentHelper(servicePath, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductDescriptionByKeyFluentHelper getProductDescriptionByKey( final String product, final String language )
    {
        return new ProductDescriptionByKeyFluentHelper(servicePath, "A_ProductDescription", product, language);
    }

    @Override
    @Nonnull
    public ProductDescriptionCreateFluentHelper createProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return new ProductDescriptionCreateFluentHelper(servicePath, productDescription, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductDescriptionUpdateFluentHelper updateProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return new ProductDescriptionUpdateFluentHelper(servicePath, productDescription, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductDescriptionDeleteFluentHelper deleteProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return new ProductDescriptionDeleteFluentHelper(servicePath, productDescription, "A_ProductDescription");
    }

    @Override
    @Nonnull
    public ProductPlantFluentHelper getAllProductPlant()
    {
        return new ProductPlantFluentHelper(servicePath, "A_ProductPlant");
    }

    @Override
    @Nonnull
    public ProductPlantByKeyFluentHelper getProductPlantByKey( final String product, final String plant )
    {
        return new ProductPlantByKeyFluentHelper(servicePath, "A_ProductPlant", product, plant);
    }

    @Override
    @Nonnull
    public ProductPlantCreateFluentHelper createProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return new ProductPlantCreateFluentHelper(servicePath, productPlant, "A_ProductPlant");
    }

    @Override
    @Nonnull
    public ProductPlantUpdateFluentHelper updateProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return new ProductPlantUpdateFluentHelper(servicePath, productPlant, "A_ProductPlant");
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryFluentHelper getAllProductSalesDelivery()
    {
        return new ProductSalesDeliveryFluentHelper(servicePath, "A_ProductSalesDelivery");
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryByKeyFluentHelper getProductSalesDeliveryByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl )
    {
        return new ProductSalesDeliveryByKeyFluentHelper(
            servicePath,
            "A_ProductSalesDelivery",
            product,
            productSalesOrg,
            productDistributionChnl);
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryCreateFluentHelper createProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return new ProductSalesDeliveryCreateFluentHelper(servicePath, productSalesDelivery, "A_ProductSalesDelivery");
    }

    @Override
    @Nonnull
    public ProductSalesDeliveryUpdateFluentHelper updateProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return new ProductSalesDeliveryUpdateFluentHelper(servicePath, productSalesDelivery, "A_ProductSalesDelivery");
    }

    @Override
    @Nonnull
    public ProductStorageLocationFluentHelper getAllProductStorageLocation()
    {
        return new ProductStorageLocationFluentHelper(servicePath, "A_ProductStorageLocation");
    }

    @Override
    @Nonnull
    public
        ProductStorageLocationByKeyFluentHelper
        getProductStorageLocationByKey( final String product, final String plant, final String storageLocation )
    {
        return new ProductStorageLocationByKeyFluentHelper(
            servicePath,
            "A_ProductStorageLocation",
            product,
            plant,
            storageLocation);
    }

    @Override
    @Nonnull
    public ProductStorageLocationCreateFluentHelper createProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return new ProductStorageLocationCreateFluentHelper(
            servicePath,
            productStorageLocation,
            "A_ProductStorageLocation");
    }

    @Override
    @Nonnull
    public ProductStorageLocationUpdateFluentHelper updateProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return new ProductStorageLocationUpdateFluentHelper(
            servicePath,
            productStorageLocation,
            "A_ProductStorageLocation");
    }

    @Override
    @Nonnull
    public RealSubstanceFluentHelper getAllRealSubstance()
    {
        return new RealSubstanceFluentHelper(servicePath, "A_RealSubstance");
    }

    @Override
    @Nonnull
    public RealSubstanceByKeyFluentHelper getRealSubstanceByKey( final String realSubstanceInternalID )
    {
        return new RealSubstanceByKeyFluentHelper(servicePath, "A_RealSubstance", realSubstanceInternalID);
    }

    @Override
    @Nonnull
    public SpecAssignedMatlForKeyDateFluentHelper getAllSpecAssignedMatlForKeyDate()
    {
        return new SpecAssignedMatlForKeyDateFluentHelper(servicePath, "A_SpecAssignedMatlForKeyDate");
    }

    @Override
    @Nonnull
    public SpecAssignedMatlForKeyDateByKeyFluentHelper getSpecAssignedMatlForKeyDateByKey(
        final String specMaterialAssgmtInternalID,
        final String specMaterialAssgmtChangeState )
    {
        return new SpecAssignedMatlForKeyDateByKeyFluentHelper(
            servicePath,
            "A_SpecAssignedMatlForKeyDate",
            specMaterialAssgmtInternalID,
            specMaterialAssgmtChangeState);
    }

    @Override
    @Nonnull
    public SpecAssignedMatlForKeyDateCreateFluentHelper createSpecAssignedMatlForKeyDate(
        @Nonnull final SpecAssignedMatlForKeyDate specAssignedMatlForKeyDate )
    {
        return new SpecAssignedMatlForKeyDateCreateFluentHelper(
            servicePath,
            specAssignedMatlForKeyDate,
            "A_SpecAssignedMatlForKeyDate");
    }

    @Override
    @Nonnull
    public SpecAuthorizationGroupTextFluentHelper getAllSpecAuthorizationGroupText()
    {
        return new SpecAuthorizationGroupTextFluentHelper(servicePath, "A_SpecAuthorizationGroupText");
    }

    @Override
    @Nonnull
    public
        SpecAuthorizationGroupTextByKeyFluentHelper
        getSpecAuthorizationGroupTextByKey( final String specificationAuthznGroup, final String language )
    {
        return new SpecAuthorizationGroupTextByKeyFluentHelper(
            servicePath,
            "A_SpecAuthorizationGroupText",
            specificationAuthznGroup,
            language);
    }

    @Override
    @Nonnull
    public SpecCharByValueAssgmtInstFluentHelper getAllSpecCharByValueAssgmtInst()
    {
        return new SpecCharByValueAssgmtInstFluentHelper(servicePath, "A_SpecCharByValueAssgmtInst");
    }

    @Override
    @Nonnull
    public SpecCharByValueAssgmtInstByKeyFluentHelper getSpecCharByValueAssgmtInstByKey(
        final String specificationInternalID,
        final String specValAssgmtType,
        final String specificationRating,
        final String specificationValidityArea )
    {
        return new SpecCharByValueAssgmtInstByKeyFluentHelper(
            servicePath,
            "A_SpecCharByValueAssgmtInst",
            specificationInternalID,
            specValAssgmtType,
            specificationRating,
            specificationValidityArea);
    }

    @Override
    @Nonnull
    public SpecIdentifierFluentHelper getAllSpecIdentifier()
    {
        return new SpecIdentifierFluentHelper(servicePath, "A_SpecIdentifier");
    }

    @Override
    @Nonnull
    public
        SpecIdentifierByKeyFluentHelper
        getSpecIdentifierByKey( final String specIdfgDescInternalID, final String specIdfgDescChangeState )
    {
        return new SpecIdentifierByKeyFluentHelper(
            servicePath,
            "A_SpecIdentifier",
            specIdfgDescInternalID,
            specIdfgDescChangeState);
    }

    @Override
    @Nonnull
    public SpecStatusAttributesFluentHelper getAllSpecStatusAttributes()
    {
        return new SpecStatusAttributesFluentHelper(servicePath, "A_SpecStatusAttributes");
    }

    @Override
    @Nonnull
    public SpecStatusAttributesByKeyFluentHelper getSpecStatusAttributesByKey(
        final String specificationHeaderStatus,
        final String specificationHdrStsAttribute )
    {
        return new SpecStatusAttributesByKeyFluentHelper(
            servicePath,
            "A_SpecStatusAttributes",
            specificationHeaderStatus,
            specificationHdrStsAttribute);
    }

    @Override
    @Nonnull
    public SpecStatusNextStatusFluentHelper getAllSpecStatusNextStatus()
    {
        return new SpecStatusNextStatusFluentHelper(servicePath, "A_SpecStatusNextStatus");
    }

    @Override
    @Nonnull
    public SpecStatusNextStatusByKeyFluentHelper getSpecStatusNextStatusByKey(
        final String specificationHdrStsSchema,
        final String specificationHdrStsSchemaFrSts,
        final String specificationHdrStsSchemaToSts )
    {
        return new SpecStatusNextStatusByKeyFluentHelper(
            servicePath,
            "A_SpecStatusNextStatus",
            specificationHdrStsSchema,
            specificationHdrStsSchemaFrSts,
            specificationHdrStsSchemaToSts);
    }

    @Override
    @Nonnull
    public SpecStatusSchemaFluentHelper getAllSpecStatusSchema()
    {
        return new SpecStatusSchemaFluentHelper(servicePath, "A_SpecStatusSchema");
    }

    @Override
    @Nonnull
    public
        SpecStatusSchemaByKeyFluentHelper
        getSpecStatusSchemaByKey( final String specificationType, final String specificationHdrStsSchema )
    {
        return new SpecStatusSchemaByKeyFluentHelper(
            servicePath,
            "A_SpecStatusSchema",
            specificationType,
            specificationHdrStsSchema);
    }

    @Override
    @Nonnull
    public SpecValAssgmtInstanceWthCompFluentHelper getAllSpecValAssgmtInstanceWthComp()
    {
        return new SpecValAssgmtInstanceWthCompFluentHelper(servicePath, "A_SpecValAssgmtInstanceWthComp");
    }

    @Override
    @Nonnull
    public SpecValAssgmtInstanceWthCompByKeyFluentHelper getSpecValAssgmtInstanceWthCompByKey(
        final String specificationInternalID,
        final String specValAssgmtType,
        final String specificationRating,
        final String specificationValidityArea,
        final String componentSpecificationIntID )
    {
        return new SpecValAssgmtInstanceWthCompByKeyFluentHelper(
            servicePath,
            "A_SpecValAssgmtInstanceWthComp",
            specificationInternalID,
            specValAssgmtType,
            specificationRating,
            specificationValidityArea,
            componentSpecificationIntID);
    }

}
