/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.batch.DefaultRecipeHeaderAndFormulaServiceBatch;

/**
 * <p>
 *
 * The service contains information belonging to the recipe header, such as status, validity, and creation date, as well
 * as formula data, including a list of ingredients with their quantities. Details of the recipe process, like process
 * elements, process parameters, and equipment requirements are also available in the service. You can also read all
 * classification data pertaining to a recipe..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/69/01bbc0b71d4e5b8c9eb3ad20800eb2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RECIPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RECIPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Recipe Development Integration(SAP_COM_0136)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1QA'>Specification Management for Recipes(1QA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QC'>Formulation - Recipe Development(1QC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Recipe</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultRecipeHeaderAndFormulaService" )
@Deprecated
public class DefaultRecipeHeaderAndFormulaService implements RecipeHeaderAndFormulaService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link RecipeHeaderAndFormulaService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultRecipeHeaderAndFormulaService()
    {
        servicePath = RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultRecipeHeaderAndFormulaService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultRecipeHeaderAndFormulaService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultRecipeHeaderAndFormulaService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultRecipeHeaderAndFormulaServiceBatch batch()
    {
        return new DefaultRecipeHeaderAndFormulaServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public RecipeFluentHelper getAllRecipe()
    {
        return new RecipeFluentHelper(servicePath, "A_Recipe");
    }

    @Override
    @Nonnull
    public RecipeByKeyFluentHelper getRecipeByKey( final UUID recipeUUID )
    {
        return new RecipeByKeyFluentHelper(servicePath, "A_Recipe", recipeUUID);
    }

    @Override
    @Nonnull
    public RecipeCreateFluentHelper createRecipe( @Nonnull final Recipe recipe )
    {
        return new RecipeCreateFluentHelper(servicePath, recipe, "A_Recipe");
    }

    @Override
    @Nonnull
    public RecipeUpdateFluentHelper updateRecipe( @Nonnull final Recipe recipe )
    {
        return new RecipeUpdateFluentHelper(servicePath, recipe, "A_Recipe");
    }

    @Override
    @Nonnull
    public RecipeDeleteFluentHelper deleteRecipe( @Nonnull final Recipe recipe )
    {
        return new RecipeDeleteFluentHelper(servicePath, recipe, "A_Recipe");
    }

    @Override
    @Nonnull
    public RecipeCharcFluentHelper getAllRecipeCharc()
    {
        return new RecipeCharcFluentHelper(servicePath, "A_RecipeCharc");
    }

    @Override
    @Nonnull
    public
        RecipeCharcByKeyFluentHelper
        getRecipeCharcByKey( final UUID recipeUUID, final String charcInternalID, final String classType )
    {
        return new RecipeCharcByKeyFluentHelper(servicePath, "A_RecipeCharc", recipeUUID, charcInternalID, classType);
    }

    @Override
    @Nonnull
    public RecipeCharcValueFluentHelper getAllRecipeCharcValue()
    {
        return new RecipeCharcValueFluentHelper(servicePath, "A_RecipeCharcValue");
    }

    @Override
    @Nonnull
    public RecipeCharcValueByKeyFluentHelper getRecipeCharcValueByKey(
        final UUID recipeUUID,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber )
    {
        return new RecipeCharcValueByKeyFluentHelper(
            servicePath,
            "A_RecipeCharcValue",
            recipeUUID,
            classType,
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public RecipeClassFluentHelper getAllRecipeClass()
    {
        return new RecipeClassFluentHelper(servicePath, "A_RecipeClass");
    }

    @Override
    @Nonnull
    public RecipeClassByKeyFluentHelper getRecipeClassByKey( final UUID recipeUUID, final String classInternalID )
    {
        return new RecipeClassByKeyFluentHelper(servicePath, "A_RecipeClass", recipeUUID, classInternalID);
    }

    @Override
    @Nonnull
    public RecipeClassCharcFluentHelper getAllRecipeClassCharc()
    {
        return new RecipeClassCharcFluentHelper(servicePath, "A_RecipeClassCharc");
    }

    @Override
    @Nonnull
    public
        RecipeClassCharcByKeyFluentHelper
        getRecipeClassCharcByKey( final UUID recipeUUID, final String classInternalID, final String charcInternalID )
    {
        return new RecipeClassCharcByKeyFluentHelper(
            servicePath,
            "A_RecipeClassCharc",
            recipeUUID,
            classInternalID,
            charcInternalID);
    }

    @Override
    @Nonnull
    public RecipeFormulaItemFluentHelper getAllRecipeFormulaItem()
    {
        return new RecipeFormulaItemFluentHelper(servicePath, "A_RecipeFormulaItem");
    }

    @Override
    @Nonnull
    public RecipeFormulaItemByKeyFluentHelper getRecipeFormulaItemByKey( final UUID rcpFmlaItemUUID )
    {
        return new RecipeFormulaItemByKeyFluentHelper(servicePath, "A_RecipeFormulaItem", rcpFmlaItemUUID);
    }

    @Override
    @Nonnull
    public RecipeFormulaItemCreateFluentHelper createRecipeFormulaItem(
        @Nonnull final RecipeFormulaItem recipeFormulaItem )
    {
        return new RecipeFormulaItemCreateFluentHelper(servicePath, recipeFormulaItem, "A_RecipeFormulaItem");
    }

    @Override
    @Nonnull
    public RecipeFormulaItemUpdateFluentHelper updateRecipeFormulaItem(
        @Nonnull final RecipeFormulaItem recipeFormulaItem )
    {
        return new RecipeFormulaItemUpdateFluentHelper(servicePath, recipeFormulaItem, "A_RecipeFormulaItem");
    }

    @Override
    @Nonnull
    public RecipeFormulaItemDeleteFluentHelper deleteRecipeFormulaItem(
        @Nonnull final RecipeFormulaItem recipeFormulaItem )
    {
        return new RecipeFormulaItemDeleteFluentHelper(servicePath, recipeFormulaItem, "A_RecipeFormulaItem");
    }

    @Override
    @Nonnull
    public RecipeProcessElementFluentHelper getAllRecipeProcessElement()
    {
        return new RecipeProcessElementFluentHelper(servicePath, "A_RecipeProcessElement");
    }

    @Override
    @Nonnull
    public RecipeProcessElementByKeyFluentHelper getRecipeProcessElementByKey( final UUID recipeProcessElementUUID )
    {
        return new RecipeProcessElementByKeyFluentHelper(
            servicePath,
            "A_RecipeProcessElement",
            recipeProcessElementUUID);
    }

    @Override
    @Nonnull
    public RecipeProcessElementCreateFluentHelper createRecipeProcessElement(
        @Nonnull final RecipeProcessElement recipeProcessElement )
    {
        return new RecipeProcessElementCreateFluentHelper(servicePath, recipeProcessElement, "A_RecipeProcessElement");
    }

    @Override
    @Nonnull
    public RecipeProcessElementUpdateFluentHelper updateRecipeProcessElement(
        @Nonnull final RecipeProcessElement recipeProcessElement )
    {
        return new RecipeProcessElementUpdateFluentHelper(servicePath, recipeProcessElement, "A_RecipeProcessElement");
    }

    @Override
    @Nonnull
    public RecipeProcessElementDeleteFluentHelper deleteRecipeProcessElement(
        @Nonnull final RecipeProcessElement recipeProcessElement )
    {
        return new RecipeProcessElementDeleteFluentHelper(servicePath, recipeProcessElement, "A_RecipeProcessElement");
    }

    @Override
    @Nonnull
    public RecipeProcessElementTextFluentHelper getAllRecipeProcessElementText()
    {
        return new RecipeProcessElementTextFluentHelper(servicePath, "A_RecipeProcessElementText");
    }

    @Override
    @Nonnull
    public
        RecipeProcessElementTextByKeyFluentHelper
        getRecipeProcessElementTextByKey( final UUID recipeProcessElementUUID, final String language )
    {
        return new RecipeProcessElementTextByKeyFluentHelper(
            servicePath,
            "A_RecipeProcessElementText",
            recipeProcessElementUUID,
            language);
    }

    @Override
    @Nonnull
    public RecipeProcessElementTextCreateFluentHelper createRecipeProcessElementText(
        @Nonnull final RecipeProcessElementText recipeProcessElementText )
    {
        return new RecipeProcessElementTextCreateFluentHelper(
            servicePath,
            recipeProcessElementText,
            "A_RecipeProcessElementText");
    }

    @Override
    @Nonnull
    public RecipeProcessElementTextUpdateFluentHelper updateRecipeProcessElementText(
        @Nonnull final RecipeProcessElementText recipeProcessElementText )
    {
        return new RecipeProcessElementTextUpdateFluentHelper(
            servicePath,
            recipeProcessElementText,
            "A_RecipeProcessElementText");
    }

    @Override
    @Nonnull
    public RecipeProcessElementTextDeleteFluentHelper deleteRecipeProcessElementText(
        @Nonnull final RecipeProcessElementText recipeProcessElementText )
    {
        return new RecipeProcessElementTextDeleteFluentHelper(
            servicePath,
            recipeProcessElementText,
            "A_RecipeProcessElementText");
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtFluentHelper getAllRecipeProcessEquipRqmt()
    {
        return new RecipeProcessEquipRqmtFluentHelper(servicePath, "A_RecipeProcessEquipRqmt");
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtByKeyFluentHelper getRecipeProcessEquipRqmtByKey(
        final UUID recipeProcessEquipRqmtUUID )
    {
        return new RecipeProcessEquipRqmtByKeyFluentHelper(
            servicePath,
            "A_RecipeProcessEquipRqmt",
            recipeProcessEquipRqmtUUID);
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtCreateFluentHelper createRecipeProcessEquipRqmt(
        @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt )
    {
        return new RecipeProcessEquipRqmtCreateFluentHelper(
            servicePath,
            recipeProcessEquipRqmt,
            "A_RecipeProcessEquipRqmt");
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtUpdateFluentHelper updateRecipeProcessEquipRqmt(
        @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt )
    {
        return new RecipeProcessEquipRqmtUpdateFluentHelper(
            servicePath,
            recipeProcessEquipRqmt,
            "A_RecipeProcessEquipRqmt");
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtDeleteFluentHelper deleteRecipeProcessEquipRqmt(
        @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt )
    {
        return new RecipeProcessEquipRqmtDeleteFluentHelper(
            servicePath,
            recipeProcessEquipRqmt,
            "A_RecipeProcessEquipRqmt");
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtTextFluentHelper getAllRecipeProcessEquipRqmtText()
    {
        return new RecipeProcessEquipRqmtTextFluentHelper(servicePath, "A_RecipeProcessEquipRqmtText");
    }

    @Override
    @Nonnull
    public
        RecipeProcessEquipRqmtTextByKeyFluentHelper
        getRecipeProcessEquipRqmtTextByKey( final UUID recipeProcessEquipRqmtUUID, final String language )
    {
        return new RecipeProcessEquipRqmtTextByKeyFluentHelper(
            servicePath,
            "A_RecipeProcessEquipRqmtText",
            recipeProcessEquipRqmtUUID,
            language);
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtTextCreateFluentHelper createRecipeProcessEquipRqmtText(
        @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText )
    {
        return new RecipeProcessEquipRqmtTextCreateFluentHelper(
            servicePath,
            recipeProcessEquipRqmtText,
            "A_RecipeProcessEquipRqmtText");
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtTextUpdateFluentHelper updateRecipeProcessEquipRqmtText(
        @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText )
    {
        return new RecipeProcessEquipRqmtTextUpdateFluentHelper(
            servicePath,
            recipeProcessEquipRqmtText,
            "A_RecipeProcessEquipRqmtText");
    }

    @Override
    @Nonnull
    public RecipeProcessEquipRqmtTextDeleteFluentHelper deleteRecipeProcessEquipRqmtText(
        @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText )
    {
        return new RecipeProcessEquipRqmtTextDeleteFluentHelper(
            servicePath,
            recipeProcessEquipRqmtText,
            "A_RecipeProcessEquipRqmtText");
    }

    @Override
    @Nonnull
    public RecipeProcessParamFluentHelper getAllRecipeProcessParam()
    {
        return new RecipeProcessParamFluentHelper(servicePath, "A_RecipeProcessParam");
    }

    @Override
    @Nonnull
    public RecipeProcessParamByKeyFluentHelper getRecipeProcessParamByKey( final UUID recipeProcessParamUUID )
    {
        return new RecipeProcessParamByKeyFluentHelper(servicePath, "A_RecipeProcessParam", recipeProcessParamUUID);
    }

    @Override
    @Nonnull
    public RecipeProcessParamTextFluentHelper getAllRecipeProcessParamText()
    {
        return new RecipeProcessParamTextFluentHelper(servicePath, "A_RecipeProcessParamText");
    }

    @Override
    @Nonnull
    public
        RecipeProcessParamTextByKeyFluentHelper
        getRecipeProcessParamTextByKey( final UUID recipeProcessParamUUID, final String language )
    {
        return new RecipeProcessParamTextByKeyFluentHelper(
            servicePath,
            "A_RecipeProcessParamText",
            recipeProcessParamUUID,
            language);
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueFluentHelper getAllRecipeProcessParamValue()
    {
        return new RecipeProcessParamValueFluentHelper(servicePath, "A_RecipeProcessParamValue");
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueByKeyFluentHelper getRecipeProcessParamValueByKey(
        final UUID recipeProcessParamValUUID )
    {
        return new RecipeProcessParamValueByKeyFluentHelper(
            servicePath,
            "A_RecipeProcessParamValue",
            recipeProcessParamValUUID);
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueCreateFluentHelper createRecipeProcessParamValue(
        @Nonnull final RecipeProcessParamValue recipeProcessParamValue )
    {
        return new RecipeProcessParamValueCreateFluentHelper(
            servicePath,
            recipeProcessParamValue,
            "A_RecipeProcessParamValue");
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueUpdateFluentHelper updateRecipeProcessParamValue(
        @Nonnull final RecipeProcessParamValue recipeProcessParamValue )
    {
        return new RecipeProcessParamValueUpdateFluentHelper(
            servicePath,
            recipeProcessParamValue,
            "A_RecipeProcessParamValue");
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueDeleteFluentHelper deleteRecipeProcessParamValue(
        @Nonnull final RecipeProcessParamValue recipeProcessParamValue )
    {
        return new RecipeProcessParamValueDeleteFluentHelper(
            servicePath,
            recipeProcessParamValue,
            "A_RecipeProcessParamValue");
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueTxtFluentHelper getAllRecipeProcessParamValueTxt()
    {
        return new RecipeProcessParamValueTxtFluentHelper(servicePath, "A_RecipeProcessParamValueTxt");
    }

    @Override
    @Nonnull
    public
        RecipeProcessParamValueTxtByKeyFluentHelper
        getRecipeProcessParamValueTxtByKey( final UUID recipeProcessParamValUUID, final String language )
    {
        return new RecipeProcessParamValueTxtByKeyFluentHelper(
            servicePath,
            "A_RecipeProcessParamValueTxt",
            recipeProcessParamValUUID,
            language);
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueTxtCreateFluentHelper createRecipeProcessParamValueTxt(
        @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt )
    {
        return new RecipeProcessParamValueTxtCreateFluentHelper(
            servicePath,
            recipeProcessParamValueTxt,
            "A_RecipeProcessParamValueTxt");
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueTxtUpdateFluentHelper updateRecipeProcessParamValueTxt(
        @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt )
    {
        return new RecipeProcessParamValueTxtUpdateFluentHelper(
            servicePath,
            recipeProcessParamValueTxt,
            "A_RecipeProcessParamValueTxt");
    }

    @Override
    @Nonnull
    public RecipeProcessParamValueTxtDeleteFluentHelper deleteRecipeProcessParamValueTxt(
        @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt )
    {
        return new RecipeProcessParamValueTxtDeleteFluentHelper(
            servicePath,
            recipeProcessParamValueTxt,
            "A_RecipeProcessParamValueTxt");
    }

    @Override
    @Nonnull
    public RecipeTextFluentHelper getAllRecipeText()
    {
        return new RecipeTextFluentHelper(servicePath, "A_RecipeText");
    }

    @Override
    @Nonnull
    public RecipeTextByKeyFluentHelper getRecipeTextByKey( final UUID recipeUUID, final String language )
    {
        return new RecipeTextByKeyFluentHelper(servicePath, "A_RecipeText", recipeUUID, language);
    }

    @Override
    @Nonnull
    public RecipeTextCreateFluentHelper createRecipeText( @Nonnull final RecipeText recipeText )
    {
        return new RecipeTextCreateFluentHelper(servicePath, recipeText, "A_RecipeText");
    }

    @Override
    @Nonnull
    public RecipeTextUpdateFluentHelper updateRecipeText( @Nonnull final RecipeText recipeText )
    {
        return new RecipeTextUpdateFluentHelper(servicePath, recipeText, "A_RecipeText");
    }

    @Override
    @Nonnull
    public RecipeTextDeleteFluentHelper deleteRecipeText( @Nonnull final RecipeText recipeText )
    {
        return new RecipeTextDeleteFluentHelper(servicePath, recipeText, "A_RecipeText");
    }

    @Override
    @Nonnull
    public RecProcEquipRqmtCharcFluentHelper getAllRecProcEquipRqmtCharc()
    {
        return new RecProcEquipRqmtCharcFluentHelper(servicePath, "A_RecProcEquipRqmtCharc");
    }

    @Override
    @Nonnull
    public RecProcEquipRqmtCharcByKeyFluentHelper getRecProcEquipRqmtCharcByKey(
        final UUID recipeProcessEquipRqmtUUID,
        final String charcInternalID,
        final String classType )
    {
        return new RecProcEquipRqmtCharcByKeyFluentHelper(
            servicePath,
            "A_RecProcEquipRqmtCharc",
            recipeProcessEquipRqmtUUID,
            charcInternalID,
            classType);
    }

    @Override
    @Nonnull
    public RecProcEquipRqmtCharcValueFluentHelper getAllRecProcEquipRqmtCharcValue()
    {
        return new RecProcEquipRqmtCharcValueFluentHelper(servicePath, "A_RecProcEquipRqmtCharcValue");
    }

    @Override
    @Nonnull
    public RecProcEquipRqmtCharcValueByKeyFluentHelper getRecProcEquipRqmtCharcValueByKey(
        final UUID recipeProcessEquipRqmtUUID,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber )
    {
        return new RecProcEquipRqmtCharcValueByKeyFluentHelper(
            servicePath,
            "A_RecProcEquipRqmtCharcValue",
            recipeProcessEquipRqmtUUID,
            classType,
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public RecProcEquipRqmtClassFluentHelper getAllRecProcEquipRqmtClass()
    {
        return new RecProcEquipRqmtClassFluentHelper(servicePath, "A_RecProcEquipRqmtClass");
    }

    @Override
    @Nonnull
    public
        RecProcEquipRqmtClassByKeyFluentHelper
        getRecProcEquipRqmtClassByKey( final UUID recipeProcessEquipRqmtUUID, final String classInternalID )
    {
        return new RecProcEquipRqmtClassByKeyFluentHelper(
            servicePath,
            "A_RecProcEquipRqmtClass",
            recipeProcessEquipRqmtUUID,
            classInternalID);
    }

    @Override
    @Nonnull
    public RecProcEquipRqmtClassCharcFluentHelper getAllRecProcEquipRqmtClassCharc()
    {
        return new RecProcEquipRqmtClassCharcFluentHelper(servicePath, "A_RecProcEquipRqmtClassCharc");
    }

    @Override
    @Nonnull
    public RecProcEquipRqmtClassCharcByKeyFluentHelper getRecProcEquipRqmtClassCharcByKey(
        final UUID recipeProcessEquipRqmtUUID,
        final String classInternalID,
        final String charcInternalID )
    {
        return new RecProcEquipRqmtClassCharcByKeyFluentHelper(
            servicePath,
            "A_RecProcEquipRqmtClassCharc",
            recipeProcessEquipRqmtUUID,
            classInternalID,
            charcInternalID);
    }

    @Override
    @Nonnull
    public RecProcParamValCharcFluentHelper getAllRecProcParamValCharc()
    {
        return new RecProcParamValCharcFluentHelper(servicePath, "A_RecProcParamValCharc");
    }

    @Override
    @Nonnull
    public RecProcParamValCharcByKeyFluentHelper getRecProcParamValCharcByKey(
        final UUID recipeProcessParamValUUID,
        final String charcInternalID,
        final String classType )
    {
        return new RecProcParamValCharcByKeyFluentHelper(
            servicePath,
            "A_RecProcParamValCharc",
            recipeProcessParamValUUID,
            charcInternalID,
            classType);
    }

    @Override
    @Nonnull
    public RecProcParamValCharcValueFluentHelper getAllRecProcParamValCharcValue()
    {
        return new RecProcParamValCharcValueFluentHelper(servicePath, "A_RecProcParamValCharcValue");
    }

    @Override
    @Nonnull
    public RecProcParamValCharcValueByKeyFluentHelper getRecProcParamValCharcValueByKey(
        final UUID recipeProcessParamValUUID,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber )
    {
        return new RecProcParamValCharcValueByKeyFluentHelper(
            servicePath,
            "A_RecProcParamValCharcValue",
            recipeProcessParamValUUID,
            classType,
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public RecProcParamValClassFluentHelper getAllRecProcParamValClass()
    {
        return new RecProcParamValClassFluentHelper(servicePath, "A_RecProcParamValClass");
    }

    @Override
    @Nonnull
    public
        RecProcParamValClassByKeyFluentHelper
        getRecProcParamValClassByKey( final UUID recipeProcessParamValUUID, final String classInternalID )
    {
        return new RecProcParamValClassByKeyFluentHelper(
            servicePath,
            "A_RecProcParamValClass",
            recipeProcessParamValUUID,
            classInternalID);
    }

    @Override
    @Nonnull
    public RecProcParamValClassCharcFluentHelper getAllRecProcParamValClassCharc()
    {
        return new RecProcParamValClassCharcFluentHelper(servicePath, "A_RecProcParamValClassCharc");
    }

    @Override
    @Nonnull
    public RecProcParamValClassCharcByKeyFluentHelper getRecProcParamValClassCharcByKey(
        final UUID recipeProcessParamValUUID,
        final String classInternalID,
        final String charcInternalID )
    {
        return new RecProcParamValClassCharcByKeyFluentHelper(
            servicePath,
            "A_RecProcParamValClassCharc",
            recipeProcessParamValUUID,
            classInternalID,
            charcInternalID);
    }

}
