/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.CompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.SubmitForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.batch.DefaultRequestsForQuotationServiceBatch;

/**
 * <p>
 *
 * The service contains header, item, and bidder nodes. The information is sent in the request as a payload. All
 * information is utilized when creating an RFQ with appropriate checks for restricted values and authorizations. Once
 * the RFQ has been successfully created, the RFQ number is sent in the response with the data included in the RFQ. If
 * any issues arise when the RFQ is created, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/07/47b64b221046a08c552f55a4b9d292/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RFQ_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RFQ_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Distributed Manufacturing Integration(SAP_COM_0077), Purchase Request for Quotation
 * Integration(SAP_COM_0113)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1A0'>Sourcing with SAP Ariba Sourcing(1A0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1L2'>Supplier Quote Automation with SAP Ariba Commerce
 * Automation(1L2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1XF'>Request for Price(1XF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OA0'>Sourcing with SAP Ariba Sourcing(OA0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXF'>Request for Price(OXF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Request For Quotation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultRequestsForQuotationService" )
@Deprecated
public class DefaultRequestsForQuotationService implements RequestsForQuotationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link RequestsForQuotationService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultRequestsForQuotationService()
    {
        servicePath = RequestsForQuotationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultRequestsForQuotationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultRequestsForQuotationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultRequestsForQuotationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultRequestsForQuotationServiceBatch batch()
    {
        return new DefaultRequestsForQuotationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public RequestForQuotationFluentHelper getAllRequestForQuotation()
    {
        return new RequestForQuotationFluentHelper(servicePath, "A_RequestForQuotation");
    }

    @Override
    @Nonnull
    public RequestForQuotationByKeyFluentHelper getRequestForQuotationByKey( final String requestForQuotation )
    {
        return new RequestForQuotationByKeyFluentHelper(servicePath, "A_RequestForQuotation", requestForQuotation);
    }

    @Override
    @Nonnull
    public RequestForQuotationCreateFluentHelper createRequestForQuotation(
        @Nonnull final RequestForQuotation requestForQuotation )
    {
        return new RequestForQuotationCreateFluentHelper(servicePath, requestForQuotation, "A_RequestForQuotation");
    }

    @Override
    @Nonnull
    public RequestForQuotationUpdateFluentHelper updateRequestForQuotation(
        @Nonnull final RequestForQuotation requestForQuotation )
    {
        return new RequestForQuotationUpdateFluentHelper(servicePath, requestForQuotation, "A_RequestForQuotation");
    }

    @Override
    @Nonnull
    public RequestForQuotationDeleteFluentHelper deleteRequestForQuotation(
        @Nonnull final RequestForQuotation requestForQuotation )
    {
        return new RequestForQuotationDeleteFluentHelper(servicePath, requestForQuotation, "A_RequestForQuotation");
    }

    @Override
    @Nonnull
    public RequestForQuotationBidderFluentHelper getAllRequestForQuotationBidder()
    {
        return new RequestForQuotationBidderFluentHelper(servicePath, "A_RequestForQuotationBidder");
    }

    @Override
    @Nonnull
    public
        RequestForQuotationBidderByKeyFluentHelper
        getRequestForQuotationBidderByKey( final String requestForQuotation, final String partnerCounter )
    {
        return new RequestForQuotationBidderByKeyFluentHelper(
            servicePath,
            "A_RequestForQuotationBidder",
            requestForQuotation,
            partnerCounter);
    }

    @Override
    @Nonnull
    public RequestForQuotationBidderCreateFluentHelper createRequestForQuotationBidder(
        @Nonnull final RequestForQuotationBidder requestForQuotationBidder )
    {
        return new RequestForQuotationBidderCreateFluentHelper(
            servicePath,
            requestForQuotationBidder,
            "A_RequestForQuotationBidder");
    }

    @Override
    @Nonnull
    public RequestForQuotationBidderUpdateFluentHelper updateRequestForQuotationBidder(
        @Nonnull final RequestForQuotationBidder requestForQuotationBidder )
    {
        return new RequestForQuotationBidderUpdateFluentHelper(
            servicePath,
            requestForQuotationBidder,
            "A_RequestForQuotationBidder");
    }

    @Override
    @Nonnull
    public RequestForQuotationBidderDeleteFluentHelper deleteRequestForQuotationBidder(
        @Nonnull final RequestForQuotationBidder requestForQuotationBidder )
    {
        return new RequestForQuotationBidderDeleteFluentHelper(
            servicePath,
            requestForQuotationBidder,
            "A_RequestForQuotationBidder");
    }

    @Override
    @Nonnull
    public RequestForQuotationItemFluentHelper getAllRequestForQuotationItem()
    {
        return new RequestForQuotationItemFluentHelper(servicePath, "A_RequestForQuotationItem");
    }

    @Override
    @Nonnull
    public
        RequestForQuotationItemByKeyFluentHelper
        getRequestForQuotationItemByKey( final String requestForQuotationItem, final String requestForQuotation )
    {
        return new RequestForQuotationItemByKeyFluentHelper(
            servicePath,
            "A_RequestForQuotationItem",
            requestForQuotationItem,
            requestForQuotation);
    }

    @Override
    @Nonnull
    public RequestForQuotationItemCreateFluentHelper createRequestForQuotationItem(
        @Nonnull final RequestForQuotationItem requestForQuotationItem )
    {
        return new RequestForQuotationItemCreateFluentHelper(
            servicePath,
            requestForQuotationItem,
            "A_RequestForQuotationItem");
    }

    @Override
    @Nonnull
    public RequestForQuotationItemUpdateFluentHelper updateRequestForQuotationItem(
        @Nonnull final RequestForQuotationItem requestForQuotationItem )
    {
        return new RequestForQuotationItemUpdateFluentHelper(
            servicePath,
            requestForQuotationItem,
            "A_RequestForQuotationItem");
    }

    @Override
    @Nonnull
    public RequestForQuotationItemDeleteFluentHelper deleteRequestForQuotationItem(
        @Nonnull final RequestForQuotationItem requestForQuotationItem )
    {
        return new RequestForQuotationItemDeleteFluentHelper(
            servicePath,
            requestForQuotationItem,
            "A_RequestForQuotationItem");
    }

    @Override
    @Nonnull
    public CompleteFluentHelper complete( @Nonnull final String requestForQuotation )
    {
        return new CompleteFluentHelper(servicePath, requestForQuotation);
    }

    @Override
    @Nonnull
    public CancelFluentHelper cancel( @Nonnull final String requestForQuotation )
    {
        return new CancelFluentHelper(servicePath, requestForQuotation);
    }

    @Override
    @Nonnull
    public SubmitForApprovalFluentHelper submitForApproval( @Nonnull final String requestForQuotation )
    {
        return new SubmitForApprovalFluentHelper(servicePath, requestForQuotation);
    }

}
