/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.batch.DefaultReservationDocumentServiceBatch;

/**
 * <p>
 *
 * For example, a user might create a reservation for a material with some quantity and assign that reserved material to
 * a cost center, a sales order or an asset. A reservation can also be created for a transfer posting from one plant to
 * another. For an existing reservation, you can change the updatable fields of the items. The service also allows to
 * delete existing reservation documents. It can be consumed by external systems and user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/51/86af9bebab426984f5c399a5b2664b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RESERVATION_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RESERVATION_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Reservation Integration(SAP_COM_0112)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMC'>Core Inventory Management(BMC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMC'>Core Inventory Management(OMC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Reservation Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultReservationDocumentService" )
@Deprecated
public class DefaultReservationDocumentService implements ReservationDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ReservationDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultReservationDocumentService()
    {
        servicePath = ReservationDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultReservationDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultReservationDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultReservationDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultReservationDocumentServiceBatch batch()
    {
        return new DefaultReservationDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ReservationDocumentHeaderFluentHelper getAllReservationDocumentHeader()
    {
        return new ReservationDocumentHeaderFluentHelper(servicePath, "A_ReservationDocumentHeader");
    }

    @Override
    @Nonnull
    public ReservationDocumentHeaderByKeyFluentHelper getReservationDocumentHeaderByKey( final String reservation )
    {
        return new ReservationDocumentHeaderByKeyFluentHelper(servicePath, "A_ReservationDocumentHeader", reservation);
    }

    @Override
    @Nonnull
    public ReservationDocumentHeaderCreateFluentHelper createReservationDocumentHeader(
        @Nonnull final ReservationDocumentHeader reservationDocumentHeader )
    {
        return new ReservationDocumentHeaderCreateFluentHelper(
            servicePath,
            reservationDocumentHeader,
            "A_ReservationDocumentHeader");
    }

    @Override
    @Nonnull
    public ReservationDocumentHeaderDeleteFluentHelper deleteReservationDocumentHeader(
        @Nonnull final ReservationDocumentHeader reservationDocumentHeader )
    {
        return new ReservationDocumentHeaderDeleteFluentHelper(
            servicePath,
            reservationDocumentHeader,
            "A_ReservationDocumentHeader");
    }

    @Override
    @Nonnull
    public ReservationDocumentItemFluentHelper getAllReservationDocumentItem()
    {
        return new ReservationDocumentItemFluentHelper(servicePath, "A_ReservationDocumentItem");
    }

    @Override
    @Nonnull
    public ReservationDocumentItemByKeyFluentHelper getReservationDocumentItemByKey(
        final String reservation,
        final String reservationItem,
        final String recordType )
    {
        return new ReservationDocumentItemByKeyFluentHelper(
            servicePath,
            "A_ReservationDocumentItem",
            reservation,
            reservationItem,
            recordType);
    }

}
