/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.RetroBillingUsageTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.RetroBillingUsageTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.batch.DefaultSalesAndDistributionDocumentOrderReasonServiceBatch;

/**
 * <p>
 * The service contains four entities, from which Self-Billing Cockpit consumers can retrieve the order reason ID and
 * description, retro-billing relevance of the order reason, as well as the related item type for self-billing
 * processing.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/84/d3490179a44e11b6e285d359055186/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_DOCUMENT_REASON_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_DOCUMENT_REASON_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Self-Billing Cockpit Integration(SAP_COM_0564)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4H2'>Self-Billing(4H2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Billing Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesAndDistributionDocumentOrderReasonService" )
@Deprecated
public class DefaultSalesAndDistributionDocumentOrderReasonService
    implements
    SalesAndDistributionDocumentOrderReasonService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesAndDistributionDocumentOrderReasonService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultSalesAndDistributionDocumentOrderReasonService()
    {
        servicePath = SalesAndDistributionDocumentOrderReasonService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesAndDistributionDocumentOrderReasonService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesAndDistributionDocumentOrderReasonService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesAndDistributionDocumentOrderReasonService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesAndDistributionDocumentOrderReasonServiceBatch batch()
    {
        return new DefaultSalesAndDistributionDocumentOrderReasonServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public RetroBillingUsageTextFluentHelper getAllRetroBillingUsageText()
    {
        return new RetroBillingUsageTextFluentHelper(servicePath, "A_RetroBillingUsageText");
    }

    @Override
    @Nonnull
    public
        RetroBillingUsageTextByKeyFluentHelper
        getRetroBillingUsageTextByKey( final String retroBillingUsage, final String language )
    {
        return new RetroBillingUsageTextByKeyFluentHelper(
            servicePath,
            "A_RetroBillingUsageText",
            retroBillingUsage,
            language);
    }

    @Override
    @Nonnull
    public SDDocumentReasonFluentHelper getAllSDDocumentReason()
    {
        return new SDDocumentReasonFluentHelper(servicePath, "A_SDDocumentReason");
    }

    @Override
    @Nonnull
    public SDDocumentReasonByKeyFluentHelper getSDDocumentReasonByKey( final String sDDocumentReason )
    {
        return new SDDocumentReasonByKeyFluentHelper(servicePath, "A_SDDocumentReason", sDDocumentReason);
    }

    @Override
    @Nonnull
    public SDDocumentReasonTextFluentHelper getAllSDDocumentReasonText()
    {
        return new SDDocumentReasonTextFluentHelper(servicePath, "A_SDDocumentReasonText");
    }

    @Override
    @Nonnull
    public
        SDDocumentReasonTextByKeyFluentHelper
        getSDDocumentReasonTextByKey( final String sDDocumentReason, final String language )
    {
        return new SDDocumentReasonTextByKeyFluentHelper(
            servicePath,
            "A_SDDocumentReasonText",
            sDDocumentReason,
            language);
    }

    @Override
    @Nonnull
    public SelfBillingValueItemTextFluentHelper getAllSelfBillingValueItemText()
    {
        return new SelfBillingValueItemTextFluentHelper(servicePath, "A_SelfBillingValueItemText");
    }

    @Override
    @Nonnull
    public
        SelfBillingValueItemTextByKeyFluentHelper
        getSelfBillingValueItemTextByKey( final String selfBillingValueItem, final String language )
    {
        return new SelfBillingValueItemTextByKeyFluentHelper(
            servicePath,
            "A_SelfBillingValueItemText",
            selfBillingValueItem,
            language);
    }

}
