/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.batch.DefaultSalesContractServiceBatch;

/**
 * <p>
 * The service contains header and item entities, as well as their sub-entities for partners and pricing elements. Once
 * the sales contract has been created, the sales contract number is sent in the response with the data included in the
 * sales contract. If there are any issues when creating, retrieving, updating, or deleting the sales contract, the
 * system displays error messages in the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/bc/2d6c95d98e4b96ae70e7db2de4cca1/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_CONTRACT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_CONTRACT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Contract Integration(SAP_COM_0119)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/I9I'>Sales Contract Management(I9I)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesContractService" )
@Deprecated
public class DefaultSalesContractService implements SalesContractService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesContractService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesContractService()
    {
        servicePath = SalesContractService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesContractService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesContractService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesContractService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesContractServiceBatch batch()
    {
        return new DefaultSalesContractServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesContractFluentHelper getAllSalesContract()
    {
        return new SalesContractFluentHelper(servicePath, "A_SalesContract");
    }

    @Override
    @Nonnull
    public SalesContractByKeyFluentHelper getSalesContractByKey( final String salesContract )
    {
        return new SalesContractByKeyFluentHelper(servicePath, "A_SalesContract", salesContract);
    }

    @Override
    @Nonnull
    public SalesContractCreateFluentHelper createSalesContract( @Nonnull final SalesContract salesContract )
    {
        return new SalesContractCreateFluentHelper(servicePath, salesContract, "A_SalesContract");
    }

    @Override
    @Nonnull
    public SalesContractUpdateFluentHelper updateSalesContract( @Nonnull final SalesContract salesContract )
    {
        return new SalesContractUpdateFluentHelper(servicePath, salesContract, "A_SalesContract");
    }

    @Override
    @Nonnull
    public SalesContractDeleteFluentHelper deleteSalesContract( @Nonnull final SalesContract salesContract )
    {
        return new SalesContractDeleteFluentHelper(servicePath, salesContract, "A_SalesContract");
    }

    @Override
    @Nonnull
    public SalesContractItemFluentHelper getAllSalesContractItem()
    {
        return new SalesContractItemFluentHelper(servicePath, "A_SalesContractItem");
    }

    @Override
    @Nonnull
    public
        SalesContractItemByKeyFluentHelper
        getSalesContractItemByKey( final String salesContract, final String salesContractItem )
    {
        return new SalesContractItemByKeyFluentHelper(
            servicePath,
            "A_SalesContractItem",
            salesContract,
            salesContractItem);
    }

    @Override
    @Nonnull
    public SalesContractItemCreateFluentHelper createSalesContractItem(
        @Nonnull final SalesContractItem salesContractItem )
    {
        return new SalesContractItemCreateFluentHelper(servicePath, salesContractItem, "A_SalesContractItem");
    }

    @Override
    @Nonnull
    public SalesContractItemUpdateFluentHelper updateSalesContractItem(
        @Nonnull final SalesContractItem salesContractItem )
    {
        return new SalesContractItemUpdateFluentHelper(servicePath, salesContractItem, "A_SalesContractItem");
    }

    @Override
    @Nonnull
    public SalesContractItemDeleteFluentHelper deleteSalesContractItem(
        @Nonnull final SalesContractItem salesContractItem )
    {
        return new SalesContractItemDeleteFluentHelper(servicePath, salesContractItem, "A_SalesContractItem");
    }

    @Override
    @Nonnull
    public SalesContractItemPartnerFluentHelper getAllSalesContractItemPartner()
    {
        return new SalesContractItemPartnerFluentHelper(servicePath, "A_SalesContractItemPartner");
    }

    @Override
    @Nonnull
    public SalesContractItemPartnerByKeyFluentHelper getSalesContractItemPartnerByKey(
        final String salesContract,
        final String salesContractItem,
        final String partnerFunction )
    {
        return new SalesContractItemPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesContractItemPartner",
            salesContract,
            salesContractItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesContractItemPartnerUpdateFluentHelper updateSalesContractItemPartner(
        @Nonnull final SalesContractItemPartner salesContractItemPartner )
    {
        return new SalesContractItemPartnerUpdateFluentHelper(
            servicePath,
            salesContractItemPartner,
            "A_SalesContractItemPartner");
    }

    @Override
    @Nonnull
    public SalesContractItemPartnerDeleteFluentHelper deleteSalesContractItemPartner(
        @Nonnull final SalesContractItemPartner salesContractItemPartner )
    {
        return new SalesContractItemPartnerDeleteFluentHelper(
            servicePath,
            salesContractItemPartner,
            "A_SalesContractItemPartner");
    }

    @Override
    @Nonnull
    public SalesContractItemPrcgElmntFluentHelper getAllSalesContractItemPrcgElmnt()
    {
        return new SalesContractItemPrcgElmntFluentHelper(servicePath, "A_SalesContractItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesContractItemPrcgElmntByKeyFluentHelper getSalesContractItemPrcgElmntByKey(
        final String salesContract,
        final String salesContractItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesContractItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_SalesContractItemPrcgElmnt",
            salesContract,
            salesContractItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesContractItemPrcgElmntUpdateFluentHelper updateSalesContractItemPrcgElmnt(
        @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt )
    {
        return new SalesContractItemPrcgElmntUpdateFluentHelper(
            servicePath,
            salesContractItemPrcgElmnt,
            "A_SalesContractItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesContractItemPrcgElmntDeleteFluentHelper deleteSalesContractItemPrcgElmnt(
        @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt )
    {
        return new SalesContractItemPrcgElmntDeleteFluentHelper(
            servicePath,
            salesContractItemPrcgElmnt,
            "A_SalesContractItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesContractItemTextFluentHelper getAllSalesContractItemText()
    {
        return new SalesContractItemTextFluentHelper(servicePath, "A_SalesContractItemText");
    }

    @Override
    @Nonnull
    public SalesContractItemTextByKeyFluentHelper getSalesContractItemTextByKey(
        final String salesContract,
        final String salesContractItem,
        final String language,
        final String longTextID )
    {
        return new SalesContractItemTextByKeyFluentHelper(
            servicePath,
            "A_SalesContractItemText",
            salesContract,
            salesContractItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SalesContractItemTextUpdateFluentHelper updateSalesContractItemText(
        @Nonnull final SalesContractItemText salesContractItemText )
    {
        return new SalesContractItemTextUpdateFluentHelper(
            servicePath,
            salesContractItemText,
            "A_SalesContractItemText");
    }

    @Override
    @Nonnull
    public SalesContractItemTextDeleteFluentHelper deleteSalesContractItemText(
        @Nonnull final SalesContractItemText salesContractItemText )
    {
        return new SalesContractItemTextDeleteFluentHelper(
            servicePath,
            salesContractItemText,
            "A_SalesContractItemText");
    }

    @Override
    @Nonnull
    public SalesContractPartnerFluentHelper getAllSalesContractPartner()
    {
        return new SalesContractPartnerFluentHelper(servicePath, "A_SalesContractPartner");
    }

    @Override
    @Nonnull
    public
        SalesContractPartnerByKeyFluentHelper
        getSalesContractPartnerByKey( final String salesContract, final String partnerFunction )
    {
        return new SalesContractPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesContractPartner",
            salesContract,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesContractPartnerCreateFluentHelper createSalesContractPartner(
        @Nonnull final SalesContractPartner salesContractPartner )
    {
        return new SalesContractPartnerCreateFluentHelper(servicePath, salesContractPartner, "A_SalesContractPartner");
    }

    @Override
    @Nonnull
    public SalesContractPartnerUpdateFluentHelper updateSalesContractPartner(
        @Nonnull final SalesContractPartner salesContractPartner )
    {
        return new SalesContractPartnerUpdateFluentHelper(servicePath, salesContractPartner, "A_SalesContractPartner");
    }

    @Override
    @Nonnull
    public SalesContractPartnerDeleteFluentHelper deleteSalesContractPartner(
        @Nonnull final SalesContractPartner salesContractPartner )
    {
        return new SalesContractPartnerDeleteFluentHelper(servicePath, salesContractPartner, "A_SalesContractPartner");
    }

    @Override
    @Nonnull
    public SalesContractPrcgElmntFluentHelper getAllSalesContractPrcgElmnt()
    {
        return new SalesContractPrcgElmntFluentHelper(servicePath, "A_SalesContractPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesContractPrcgElmntByKeyFluentHelper getSalesContractPrcgElmntByKey(
        final String salesContract,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesContractPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_SalesContractPrcgElmnt",
            salesContract,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesContractPrcgElmntUpdateFluentHelper updateSalesContractPrcgElmnt(
        @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt )
    {
        return new SalesContractPrcgElmntUpdateFluentHelper(
            servicePath,
            salesContractPrcgElmnt,
            "A_SalesContractPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesContractPrcgElmntDeleteFluentHelper deleteSalesContractPrcgElmnt(
        @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt )
    {
        return new SalesContractPrcgElmntDeleteFluentHelper(
            servicePath,
            salesContractPrcgElmnt,
            "A_SalesContractPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesContractTextFluentHelper getAllSalesContractText()
    {
        return new SalesContractTextFluentHelper(servicePath, "A_SalesContractText");
    }

    @Override
    @Nonnull
    public
        SalesContractTextByKeyFluentHelper
        getSalesContractTextByKey( final String salesContract, final String language, final String longTextID )
    {
        return new SalesContractTextByKeyFluentHelper(
            servicePath,
            "A_SalesContractText",
            salesContract,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SalesContractTextUpdateFluentHelper updateSalesContractText(
        @Nonnull final SalesContractText salesContractText )
    {
        return new SalesContractTextUpdateFluentHelper(servicePath, salesContractText, "A_SalesContractText");
    }

    @Override
    @Nonnull
    public SalesContractTextDeleteFluentHelper deleteSalesContractText(
        @Nonnull final SalesContractText salesContractText )
    {
        return new SalesContractTextDeleteFluentHelper(servicePath, salesContractText, "A_SalesContractText");
    }

    @Override
    @Nonnull
    public ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String salesContract )
    {
        return new ReleaseApprovalRequestFluentHelper(servicePath, salesContract);
    }

    @Override
    @Nonnull
    public RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String salesContract )
    {
        return new RejectApprovalRequestFluentHelper(servicePath, salesContract);
    }

}
