/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.batch.DefaultSalesDistrictServiceBatch;

/**
 * <p>
 * The service contains sales district and sales district text nodes.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ae/06955b5a0d4005a65680bb4ca61553/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALESDISTRICT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALESDISTRICT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales District</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesDistrictService" )
@Deprecated
public class DefaultSalesDistrictService implements SalesDistrictService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesDistrictService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesDistrictService()
    {
        servicePath = SalesDistrictService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesDistrictService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesDistrictService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesDistrictService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesDistrictServiceBatch batch()
    {
        return new DefaultSalesDistrictServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesDistrictFluentHelper getAllSalesDistrict()
    {
        return new SalesDistrictFluentHelper(servicePath, "A_SalesDistrict");
    }

    @Override
    @Nonnull
    public SalesDistrictByKeyFluentHelper getSalesDistrictByKey( final String salesDistrict )
    {
        return new SalesDistrictByKeyFluentHelper(servicePath, "A_SalesDistrict", salesDistrict);
    }

    @Override
    @Nonnull
    public SalesDistrictTextFluentHelper getAllSalesDistrictText()
    {
        return new SalesDistrictTextFluentHelper(servicePath, "A_SalesDistrictText");
    }

    @Override
    @Nonnull
    public
        SalesDistrictTextByKeyFluentHelper
        getSalesDistrictTextByKey( final String salesDistrict, final String language )
    {
        return new SalesDistrictTextByKeyFluentHelper(servicePath, "A_SalesDistrictText", salesDistrict, language);
    }

}
