/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CheckCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.RejectCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.ReleaseCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.batch.DefaultSalesDocumentWithCreditBlocksServiceBatch;

/**
 * <p>
 * The service contains entities for credit blocked sales document and reject reason. Once the sales document has been
 * checked, released, or rejected, a success message containing the document number is sent in the response. Once the
 * credit blocked sales document has been retrieved, the data is sent in the response. If there are any issues when
 * reading, checking, releasing, or rejecting the credit blocked sales document, the system displays error messages in
 * the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4f/6bd74343554c3cbaa43df5ff34363d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SLS_DOC_WITH_CREDIT_BLOCK?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SLS_DOC_WITH_CREDIT_BLOCK</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Credit Management Integration(SAP_COM_0325)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD6'>Basic Credit Management(BD6)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesDocumentWithCreditBlocksService" )
@Deprecated
public class DefaultSalesDocumentWithCreditBlocksService implements SalesDocumentWithCreditBlocksService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesDocumentWithCreditBlocksService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesDocumentWithCreditBlocksService()
    {
        servicePath = SalesDocumentWithCreditBlocksService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesDocumentWithCreditBlocksService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesDocumentWithCreditBlocksService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesDocumentWithCreditBlocksService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesDocumentWithCreditBlocksServiceBatch batch()
    {
        return new DefaultSalesDocumentWithCreditBlocksServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CreditBlockedSalesDocumentFluentHelper getAllCreditBlockedSalesDocument()
    {
        return new CreditBlockedSalesDocumentFluentHelper(servicePath, "A_CreditBlockedSalesDocument");
    }

    @Override
    @Nonnull
    public CreditBlockedSalesDocumentByKeyFluentHelper getCreditBlockedSalesDocumentByKey( final String salesDocument )
    {
        return new CreditBlockedSalesDocumentByKeyFluentHelper(
            servicePath,
            "A_CreditBlockedSalesDocument",
            salesDocument);
    }

    @Override
    @Nonnull
    public SalesDocumentRjcnReasonFluentHelper getAllSalesDocumentRjcnReason()
    {
        return new SalesDocumentRjcnReasonFluentHelper(servicePath, "A_SalesDocumentRjcnReason");
    }

    @Override
    @Nonnull
    public SalesDocumentRjcnReasonByKeyFluentHelper getSalesDocumentRjcnReasonByKey(
        final String salesDocumentRjcnReason )
    {
        return new SalesDocumentRjcnReasonByKeyFluentHelper(
            servicePath,
            "A_SalesDocumentRjcnReason",
            salesDocumentRjcnReason);
    }

    @Override
    @Nonnull
    public
        CheckCreditBlockFluentHelper
        checkCreditBlock( @Nonnull final String sDDocumentCategory, @Nonnull final String salesDocument )
    {
        return new CheckCreditBlockFluentHelper(servicePath, sDDocumentCategory, salesDocument);
    }

    @Override
    @Nonnull
    public RejectCreditBlockFluentHelper rejectCreditBlock(
        @Nonnull final String sDDocumentCategory,
        @Nonnull final String salesDocumentRjcnReason,
        @Nonnull final String salesDocument )
    {
        return new RejectCreditBlockFluentHelper(
            servicePath,
            sDDocumentCategory,
            salesDocumentRjcnReason,
            salesDocument);
    }

    @Override
    @Nonnull
    public
        ReleaseCreditBlockFluentHelper
        releaseCreditBlock( @Nonnull final String salesDocument, @Nonnull final String sDDocumentCategory )
    {
        return new ReleaseCreditBlockFluentHelper(servicePath, salesDocument, sDDocumentCategory);
    }

}
