/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.batch.DefaultSalesInquiryServiceBatch;

/**
 * <p>
 * The service contains header, header partner, header pricing element, item, item partner, and item pricing element
 * entities. You can retrieve all existing data or apply filters.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/39/13cc82abf14e5ca269ff691c7a2958/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_INQUIRY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_INQUIRY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Inquiry Integration(SAP_COM_0117)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1IQ'>Sales Inquiry(1IQ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Inquiry</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesInquiryService" )
@Deprecated
public class DefaultSalesInquiryService implements SalesInquiryService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesInquiryService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesInquiryService()
    {
        servicePath = SalesInquiryService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesInquiryService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesInquiryService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesInquiryService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesInquiryServiceBatch batch()
    {
        return new DefaultSalesInquiryServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesInquiryFluentHelper getAllSalesInquiry()
    {
        return new SalesInquiryFluentHelper(servicePath, "A_SalesInquiry");
    }

    @Override
    @Nonnull
    public SalesInquiryByKeyFluentHelper getSalesInquiryByKey( final String salesInquiry )
    {
        return new SalesInquiryByKeyFluentHelper(servicePath, "A_SalesInquiry", salesInquiry);
    }

    @Override
    @Nonnull
    public SalesInquiryItemFluentHelper getAllSalesInquiryItem()
    {
        return new SalesInquiryItemFluentHelper(servicePath, "A_SalesInquiryItem");
    }

    @Override
    @Nonnull
    public
        SalesInquiryItemByKeyFluentHelper
        getSalesInquiryItemByKey( final String salesInquiry, final String salesInquiryItem )
    {
        return new SalesInquiryItemByKeyFluentHelper(servicePath, "A_SalesInquiryItem", salesInquiry, salesInquiryItem);
    }

    @Override
    @Nonnull
    public SalesInquiryItemPartnerFluentHelper getAllSalesInquiryItemPartner()
    {
        return new SalesInquiryItemPartnerFluentHelper(servicePath, "A_SalesInquiryItemPartner");
    }

    @Override
    @Nonnull
    public SalesInquiryItemPartnerByKeyFluentHelper getSalesInquiryItemPartnerByKey(
        final String salesInquiry,
        final String salesInquiryItem,
        final String partnerFunction )
    {
        return new SalesInquiryItemPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesInquiryItemPartner",
            salesInquiry,
            salesInquiryItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesInquiryItemPrcgElmntFluentHelper getAllSalesInquiryItemPrcgElmnt()
    {
        return new SalesInquiryItemPrcgElmntFluentHelper(servicePath, "A_SalesInquiryItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesInquiryItemPrcgElmntByKeyFluentHelper getSalesInquiryItemPrcgElmntByKey(
        final String salesInquiry,
        final String salesInquiryItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesInquiryItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_SalesInquiryItemPrcgElmnt",
            salesInquiry,
            salesInquiryItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesInquiryPartnerFluentHelper getAllSalesInquiryPartner()
    {
        return new SalesInquiryPartnerFluentHelper(servicePath, "A_SalesInquiryPartner");
    }

    @Override
    @Nonnull
    public
        SalesInquiryPartnerByKeyFluentHelper
        getSalesInquiryPartnerByKey( final String salesInquiry, final String partnerFunction )
    {
        return new SalesInquiryPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesInquiryPartner",
            salesInquiry,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesInquiryPrcgElmntFluentHelper getAllSalesInquiryPrcgElmnt()
    {
        return new SalesInquiryPrcgElmntFluentHelper(servicePath, "A_SalesInquiryPrcgElmnt");
    }

    @Override
    @Nonnull
    public SalesInquiryPrcgElmntByKeyFluentHelper getSalesInquiryPrcgElmntByKey(
        final String salesInquiry,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesInquiryPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_SalesInquiryPrcgElmnt",
            salesInquiry,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

}
