/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.batch.DefaultSalesOrderServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire sales orders or only parts of
 * the data, using the provided filters. - You can create sales orders. You can use deep insert requests, that is, you
 * create a header plus at least one of the following entities: header partner, header partner address, header pricing
 * element, header billing plan, header billing plan item, header text, payment plan, header related object, item, item
 * partner, item partner address, item pricing element, item billing plan, item billing plan item, item text, and item
 * related object. If the header already exists, you can create the following sub-entities on their own: header partner,
 * header pricing element, header text, payment plan, header related object, item partner, item pricing element, item
 * text, and item related object. - For existing sales orders, you can create new items. You can use deep insert
 * requests, that is, you create an item plus at least one of the following entities: item partner, item partner
 * address, item pricing element, item billing plan, item billing plan item, item text, and item related object. If the
 * item already exists, you can create the following sub-entities on their own: item partner, item pricing element, item
 * text, item related object, and item schedule line. - For existing sales orders, you can update the following entities
 * (that is, you can change the content of their properties): header, header partner, header partner address, header
 * pricing element, header billing plan, header billing plan item, header text, payment plan, item, item partner, item
 * partner address, item pricing element, item billing plan, item billing plan item, item text, and item schedule line.
 * - For existing sales orders, you can delete the following entities: header, header partner, header pricing element,
 * header billing plan item, header text, payment plan, header related object, item, item partner, item pricing element,
 * item billing plan item, item text, item related object, and item schedule line. - You can accept or deny approval
 * requests for sales orders that cannot be processed without the consent of an approver..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/00/d244581efca007e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_ORDER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_ORDER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Order Integration(SAP_COM_0109), Delivery Insights Replication App Integration
 * (Obsolete)(SAP_COM_0571)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QI'>Opportunity-to-Order with Third-Party Sales Force Automation Apps
 * (Deprecated)(1QI)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2TY'>B2B Order Fulfillment with SAP Commerce
 * Cloud(2TY)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4IH'>Delivery Insights Enabled by IoT(4IH)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultSalesOrderService" )
@Deprecated
public class DefaultSalesOrderService implements SalesOrderService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link SalesOrderService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultSalesOrderService()
    {
        servicePath = SalesOrderService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultSalesOrderService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesOrderService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesOrderService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultSalesOrderServiceBatch batch()
    {
        return new DefaultSalesOrderServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public SalesOrderFluentHelper getAllSalesOrder()
    {
        return new SalesOrderFluentHelper(servicePath, "A_SalesOrder");
    }

    @Override
    @Nonnull
    public SalesOrderByKeyFluentHelper getSalesOrderByKey( final String salesOrder )
    {
        return new SalesOrderByKeyFluentHelper(servicePath, "A_SalesOrder", salesOrder);
    }

    @Override
    @Nonnull
    public SalesOrderCreateFluentHelper createSalesOrder( @Nonnull final SalesOrder salesOrder )
    {
        return new SalesOrderCreateFluentHelper(servicePath, salesOrder, "A_SalesOrder");
    }

    @Override
    @Nonnull
    public SalesOrderUpdateFluentHelper updateSalesOrder( @Nonnull final SalesOrder salesOrder )
    {
        return new SalesOrderUpdateFluentHelper(servicePath, salesOrder, "A_SalesOrder");
    }

    @Override
    @Nonnull
    public SalesOrderDeleteFluentHelper deleteSalesOrder( @Nonnull final SalesOrder salesOrder )
    {
        return new SalesOrderDeleteFluentHelper(servicePath, salesOrder, "A_SalesOrder");
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanFluentHelper getAllSalesOrderBillingPlan()
    {
        return new SalesOrderBillingPlanFluentHelper(servicePath, "A_SalesOrderBillingPlan");
    }

    @Override
    @Nonnull
    public
        SalesOrderBillingPlanByKeyFluentHelper
        getSalesOrderBillingPlanByKey( final String salesOrder, final String billingPlan )
    {
        return new SalesOrderBillingPlanByKeyFluentHelper(
            servicePath,
            "A_SalesOrderBillingPlan",
            salesOrder,
            billingPlan);
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanCreateFluentHelper createSalesOrderBillingPlan(
        @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan )
    {
        return new SalesOrderBillingPlanCreateFluentHelper(
            servicePath,
            salesOrderBillingPlan,
            "A_SalesOrderBillingPlan");
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanUpdateFluentHelper updateSalesOrderBillingPlan(
        @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan )
    {
        return new SalesOrderBillingPlanUpdateFluentHelper(
            servicePath,
            salesOrderBillingPlan,
            "A_SalesOrderBillingPlan");
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanItemFluentHelper getAllSalesOrderBillingPlanItem()
    {
        return new SalesOrderBillingPlanItemFluentHelper(servicePath, "A_SalesOrderBillingPlanItem");
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanItemByKeyFluentHelper getSalesOrderBillingPlanItemByKey(
        final String salesOrder,
        final String billingPlan,
        final String billingPlanItem )
    {
        return new SalesOrderBillingPlanItemByKeyFluentHelper(
            servicePath,
            "A_SalesOrderBillingPlanItem",
            salesOrder,
            billingPlan,
            billingPlanItem);
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanItemCreateFluentHelper createSalesOrderBillingPlanItem(
        @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem )
    {
        return new SalesOrderBillingPlanItemCreateFluentHelper(
            servicePath,
            salesOrderBillingPlanItem,
            "A_SalesOrderBillingPlanItem");
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanItemUpdateFluentHelper updateSalesOrderBillingPlanItem(
        @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem )
    {
        return new SalesOrderBillingPlanItemUpdateFluentHelper(
            servicePath,
            salesOrderBillingPlanItem,
            "A_SalesOrderBillingPlanItem");
    }

    @Override
    @Nonnull
    public SalesOrderBillingPlanItemDeleteFluentHelper deleteSalesOrderBillingPlanItem(
        @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem )
    {
        return new SalesOrderBillingPlanItemDeleteFluentHelper(
            servicePath,
            salesOrderBillingPlanItem,
            "A_SalesOrderBillingPlanItem");
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPartnerFluentHelper getAllSalesOrderHeaderPartner()
    {
        return new SalesOrderHeaderPartnerFluentHelper(servicePath, "A_SalesOrderHeaderPartner");
    }

    @Override
    @Nonnull
    public
        SalesOrderHeaderPartnerByKeyFluentHelper
        getSalesOrderHeaderPartnerByKey( final String salesOrder, final String partnerFunction )
    {
        return new SalesOrderHeaderPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesOrderHeaderPartner",
            salesOrder,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPartnerCreateFluentHelper createSalesOrderHeaderPartner(
        @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner )
    {
        return new SalesOrderHeaderPartnerCreateFluentHelper(
            servicePath,
            salesOrderHeaderPartner,
            "A_SalesOrderHeaderPartner");
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPartnerUpdateFluentHelper updateSalesOrderHeaderPartner(
        @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner )
    {
        return new SalesOrderHeaderPartnerUpdateFluentHelper(
            servicePath,
            salesOrderHeaderPartner,
            "A_SalesOrderHeaderPartner");
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPartnerDeleteFluentHelper deleteSalesOrderHeaderPartner(
        @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner )
    {
        return new SalesOrderHeaderPartnerDeleteFluentHelper(
            servicePath,
            salesOrderHeaderPartner,
            "A_SalesOrderHeaderPartner");
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPrElementFluentHelper getAllSalesOrderHeaderPrElement()
    {
        return new SalesOrderHeaderPrElementFluentHelper(servicePath, "A_SalesOrderHeaderPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPrElementByKeyFluentHelper getSalesOrderHeaderPrElementByKey(
        final String salesOrder,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesOrderHeaderPrElementByKeyFluentHelper(
            servicePath,
            "A_SalesOrderHeaderPrElement",
            salesOrder,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPrElementCreateFluentHelper createSalesOrderHeaderPrElement(
        @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement )
    {
        return new SalesOrderHeaderPrElementCreateFluentHelper(
            servicePath,
            salesOrderHeaderPrElement,
            "A_SalesOrderHeaderPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPrElementUpdateFluentHelper updateSalesOrderHeaderPrElement(
        @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement )
    {
        return new SalesOrderHeaderPrElementUpdateFluentHelper(
            servicePath,
            salesOrderHeaderPrElement,
            "A_SalesOrderHeaderPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderHeaderPrElementDeleteFluentHelper deleteSalesOrderHeaderPrElement(
        @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement )
    {
        return new SalesOrderHeaderPrElementDeleteFluentHelper(
            servicePath,
            salesOrderHeaderPrElement,
            "A_SalesOrderHeaderPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderItemFluentHelper getAllSalesOrderItem()
    {
        return new SalesOrderItemFluentHelper(servicePath, "A_SalesOrderItem");
    }

    @Override
    @Nonnull
    public
        SalesOrderItemByKeyFluentHelper
        getSalesOrderItemByKey( final String salesOrder, final String salesOrderItem )
    {
        return new SalesOrderItemByKeyFluentHelper(servicePath, "A_SalesOrderItem", salesOrder, salesOrderItem);
    }

    @Override
    @Nonnull
    public SalesOrderItemCreateFluentHelper createSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem )
    {
        return new SalesOrderItemCreateFluentHelper(servicePath, salesOrderItem, "A_SalesOrderItem");
    }

    @Override
    @Nonnull
    public SalesOrderItemUpdateFluentHelper updateSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem )
    {
        return new SalesOrderItemUpdateFluentHelper(servicePath, salesOrderItem, "A_SalesOrderItem");
    }

    @Override
    @Nonnull
    public SalesOrderItemDeleteFluentHelper deleteSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem )
    {
        return new SalesOrderItemDeleteFluentHelper(servicePath, salesOrderItem, "A_SalesOrderItem");
    }

    @Override
    @Nonnull
    public SalesOrderItemBillingPlanFluentHelper getAllSalesOrderItemBillingPlan()
    {
        return new SalesOrderItemBillingPlanFluentHelper(servicePath, "A_SalesOrderItemBillingPlan");
    }

    @Override
    @Nonnull
    public SalesOrderItemBillingPlanByKeyFluentHelper getSalesOrderItemBillingPlanByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String billingPlan )
    {
        return new SalesOrderItemBillingPlanByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItemBillingPlan",
            salesOrder,
            salesOrderItem,
            billingPlan);
    }

    @Override
    @Nonnull
    public SalesOrderItemBillingPlanCreateFluentHelper createSalesOrderItemBillingPlan(
        @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan )
    {
        return new SalesOrderItemBillingPlanCreateFluentHelper(
            servicePath,
            salesOrderItemBillingPlan,
            "A_SalesOrderItemBillingPlan");
    }

    @Override
    @Nonnull
    public SalesOrderItemBillingPlanUpdateFluentHelper updateSalesOrderItemBillingPlan(
        @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan )
    {
        return new SalesOrderItemBillingPlanUpdateFluentHelper(
            servicePath,
            salesOrderItemBillingPlan,
            "A_SalesOrderItemBillingPlan");
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerFluentHelper getAllSalesOrderItemPartner()
    {
        return new SalesOrderItemPartnerFluentHelper(servicePath, "A_SalesOrderItemPartner");
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerByKeyFluentHelper getSalesOrderItemPartnerByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String partnerFunction )
    {
        return new SalesOrderItemPartnerByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItemPartner",
            salesOrder,
            salesOrderItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerCreateFluentHelper createSalesOrderItemPartner(
        @Nonnull final SalesOrderItemPartner salesOrderItemPartner )
    {
        return new SalesOrderItemPartnerCreateFluentHelper(
            servicePath,
            salesOrderItemPartner,
            "A_SalesOrderItemPartner");
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerUpdateFluentHelper updateSalesOrderItemPartner(
        @Nonnull final SalesOrderItemPartner salesOrderItemPartner )
    {
        return new SalesOrderItemPartnerUpdateFluentHelper(
            servicePath,
            salesOrderItemPartner,
            "A_SalesOrderItemPartner");
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerDeleteFluentHelper deleteSalesOrderItemPartner(
        @Nonnull final SalesOrderItemPartner salesOrderItemPartner )
    {
        return new SalesOrderItemPartnerDeleteFluentHelper(
            servicePath,
            salesOrderItemPartner,
            "A_SalesOrderItemPartner");
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerAddressFluentHelper getAllSalesOrderItemPartnerAddress()
    {
        return new SalesOrderItemPartnerAddressFluentHelper(servicePath, "A_SalesOrderItemPartnerAddress");
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerAddressByKeyFluentHelper getSalesOrderItemPartnerAddressByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String partnerFunction,
        final String addressRepresentationCode )
    {
        return new SalesOrderItemPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItemPartnerAddress",
            salesOrder,
            salesOrderItem,
            partnerFunction,
            addressRepresentationCode);
    }

    @Override
    @Nonnull
    public SalesOrderItemPartnerAddressUpdateFluentHelper updateSalesOrderItemPartnerAddress(
        @Nonnull final SalesOrderItemPartnerAddress salesOrderItemPartnerAddress )
    {
        return new SalesOrderItemPartnerAddressUpdateFluentHelper(
            servicePath,
            salesOrderItemPartnerAddress,
            "A_SalesOrderItemPartnerAddress");
    }

    @Override
    @Nonnull
    public SalesOrderItemPrElementFluentHelper getAllSalesOrderItemPrElement()
    {
        return new SalesOrderItemPrElementFluentHelper(servicePath, "A_SalesOrderItemPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderItemPrElementByKeyFluentHelper getSalesOrderItemPrElementByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new SalesOrderItemPrElementByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItemPrElement",
            salesOrder,
            salesOrderItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public SalesOrderItemPrElementCreateFluentHelper createSalesOrderItemPrElement(
        @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement )
    {
        return new SalesOrderItemPrElementCreateFluentHelper(
            servicePath,
            salesOrderItemPrElement,
            "A_SalesOrderItemPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderItemPrElementUpdateFluentHelper updateSalesOrderItemPrElement(
        @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement )
    {
        return new SalesOrderItemPrElementUpdateFluentHelper(
            servicePath,
            salesOrderItemPrElement,
            "A_SalesOrderItemPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderItemPrElementDeleteFluentHelper deleteSalesOrderItemPrElement(
        @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement )
    {
        return new SalesOrderItemPrElementDeleteFluentHelper(
            servicePath,
            salesOrderItemPrElement,
            "A_SalesOrderItemPrElement");
    }

    @Override
    @Nonnull
    public SalesOrderItemRelatedObjectFluentHelper getAllSalesOrderItemRelatedObject()
    {
        return new SalesOrderItemRelatedObjectFluentHelper(servicePath, "A_SalesOrderItemRelatedObject");
    }

    @Override
    @Nonnull
    public SalesOrderItemRelatedObjectByKeyFluentHelper getSalesOrderItemRelatedObjectByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String sDDocRelatedObjectSequenceNmbr )
    {
        return new SalesOrderItemRelatedObjectByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItemRelatedObject",
            salesOrder,
            salesOrderItem,
            sDDocRelatedObjectSequenceNmbr);
    }

    @Override
    @Nonnull
    public SalesOrderItemRelatedObjectCreateFluentHelper createSalesOrderItemRelatedObject(
        @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject )
    {
        return new SalesOrderItemRelatedObjectCreateFluentHelper(
            servicePath,
            salesOrderItemRelatedObject,
            "A_SalesOrderItemRelatedObject");
    }

    @Override
    @Nonnull
    public SalesOrderItemRelatedObjectDeleteFluentHelper deleteSalesOrderItemRelatedObject(
        @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject )
    {
        return new SalesOrderItemRelatedObjectDeleteFluentHelper(
            servicePath,
            salesOrderItemRelatedObject,
            "A_SalesOrderItemRelatedObject");
    }

    @Override
    @Nonnull
    public SalesOrderItemTextFluentHelper getAllSalesOrderItemText()
    {
        return new SalesOrderItemTextFluentHelper(servicePath, "A_SalesOrderItemText");
    }

    @Override
    @Nonnull
    public SalesOrderItemTextByKeyFluentHelper getSalesOrderItemTextByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String language,
        final String longTextID )
    {
        return new SalesOrderItemTextByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItemText",
            salesOrder,
            salesOrderItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public SalesOrderItemTextCreateFluentHelper createSalesOrderItemText(
        @Nonnull final SalesOrderItemText salesOrderItemText )
    {
        return new SalesOrderItemTextCreateFluentHelper(servicePath, salesOrderItemText, "A_SalesOrderItemText");
    }

    @Override
    @Nonnull
    public SalesOrderItemTextUpdateFluentHelper updateSalesOrderItemText(
        @Nonnull final SalesOrderItemText salesOrderItemText )
    {
        return new SalesOrderItemTextUpdateFluentHelper(servicePath, salesOrderItemText, "A_SalesOrderItemText");
    }

    @Override
    @Nonnull
    public SalesOrderItemTextDeleteFluentHelper deleteSalesOrderItemText(
        @Nonnull final SalesOrderItemText salesOrderItemText )
    {
        return new SalesOrderItemTextDeleteFluentHelper(servicePath, salesOrderItemText, "A_SalesOrderItemText");
    }

    @Override
    @Nonnull
    public SalesOrderItmPrecdgProcFlowFluentHelper getAllSalesOrderItmPrecdgProcFlow()
    {
        return new SalesOrderItmPrecdgProcFlowFluentHelper(servicePath, "A_SalesOrderItmPrecdgProcFlow");
    }

    @Override
    @Nonnull
    public SalesOrderItmPrecdgProcFlowByKeyFluentHelper getSalesOrderItmPrecdgProcFlowByKey(
        final String salesOrder,
        final String salesOrderItem,
        final UUID docRelationshipUUID )
    {
        return new SalesOrderItmPrecdgProcFlowByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItmPrecdgProcFlow",
            salesOrder,
            salesOrderItem,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public SalesOrderItmSubsqntProcFlowFluentHelper getAllSalesOrderItmSubsqntProcFlow()
    {
        return new SalesOrderItmSubsqntProcFlowFluentHelper(servicePath, "A_SalesOrderItmSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public SalesOrderItmSubsqntProcFlowByKeyFluentHelper getSalesOrderItmSubsqntProcFlowByKey(
        final String salesOrder,
        final String salesOrderItem,
        final UUID docRelationshipUUID )
    {
        return new SalesOrderItmSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_SalesOrderItmSubsqntProcFlow",
            salesOrder,
            salesOrderItem,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public SalesOrderPartnerAddressFluentHelper getAllSalesOrderPartnerAddress()
    {
        return new SalesOrderPartnerAddressFluentHelper(servicePath, "A_SalesOrderPartnerAddress");
    }

    @Override
    @Nonnull
    public SalesOrderPartnerAddressByKeyFluentHelper getSalesOrderPartnerAddressByKey(
        final String salesOrder,
        final String partnerFunction,
        final String addressRepresentationCode )
    {
        return new SalesOrderPartnerAddressByKeyFluentHelper(
            servicePath,
            "A_SalesOrderPartnerAddress",
            salesOrder,
            partnerFunction,
            addressRepresentationCode);
    }

    @Override
    @Nonnull
    public SalesOrderPartnerAddressUpdateFluentHelper updateSalesOrderPartnerAddress(
        @Nonnull final SalesOrderPartnerAddress salesOrderPartnerAddress )
    {
        return new SalesOrderPartnerAddressUpdateFluentHelper(
            servicePath,
            salesOrderPartnerAddress,
            "A_SalesOrderPartnerAddress");
    }

    @Override
    @Nonnull
    public SalesOrderPrecdgProcFlowFluentHelper getAllSalesOrderPrecdgProcFlow()
    {
        return new SalesOrderPrecdgProcFlowFluentHelper(servicePath, "A_SalesOrderPrecdgProcFlow");
    }

    @Override
    @Nonnull
    public
        SalesOrderPrecdgProcFlowByKeyFluentHelper
        getSalesOrderPrecdgProcFlowByKey( final String salesOrder, final UUID docRelationshipUUID )
    {
        return new SalesOrderPrecdgProcFlowByKeyFluentHelper(
            servicePath,
            "A_SalesOrderPrecdgProcFlow",
            salesOrder,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public SalesOrderRelatedObjectFluentHelper getAllSalesOrderRelatedObject()
    {
        return new SalesOrderRelatedObjectFluentHelper(servicePath, "A_SalesOrderRelatedObject");
    }

    @Override
    @Nonnull
    public
        SalesOrderRelatedObjectByKeyFluentHelper
        getSalesOrderRelatedObjectByKey( final String salesOrder, final String sDDocRelatedObjectSequenceNmbr )
    {
        return new SalesOrderRelatedObjectByKeyFluentHelper(
            servicePath,
            "A_SalesOrderRelatedObject",
            salesOrder,
            sDDocRelatedObjectSequenceNmbr);
    }

    @Override
    @Nonnull
    public SalesOrderRelatedObjectCreateFluentHelper createSalesOrderRelatedObject(
        @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject )
    {
        return new SalesOrderRelatedObjectCreateFluentHelper(
            servicePath,
            salesOrderRelatedObject,
            "A_SalesOrderRelatedObject");
    }

    @Override
    @Nonnull
    public SalesOrderRelatedObjectDeleteFluentHelper deleteSalesOrderRelatedObject(
        @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject )
    {
        return new SalesOrderRelatedObjectDeleteFluentHelper(
            servicePath,
            salesOrderRelatedObject,
            "A_SalesOrderRelatedObject");
    }

    @Override
    @Nonnull
    public SalesOrderScheduleLineFluentHelper getAllSalesOrderScheduleLine()
    {
        return new SalesOrderScheduleLineFluentHelper(servicePath, "A_SalesOrderScheduleLine");
    }

    @Override
    @Nonnull
    public SalesOrderScheduleLineByKeyFluentHelper getSalesOrderScheduleLineByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String scheduleLine )
    {
        return new SalesOrderScheduleLineByKeyFluentHelper(
            servicePath,
            "A_SalesOrderScheduleLine",
            salesOrder,
            salesOrderItem,
            scheduleLine);
    }

    @Override
    @Nonnull
    public SalesOrderScheduleLineCreateFluentHelper createSalesOrderScheduleLine(
        @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine )
    {
        return new SalesOrderScheduleLineCreateFluentHelper(
            servicePath,
            salesOrderScheduleLine,
            "A_SalesOrderScheduleLine");
    }

    @Override
    @Nonnull
    public SalesOrderScheduleLineUpdateFluentHelper updateSalesOrderScheduleLine(
        @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine )
    {
        return new SalesOrderScheduleLineUpdateFluentHelper(
            servicePath,
            salesOrderScheduleLine,
            "A_SalesOrderScheduleLine");
    }

    @Override
    @Nonnull
    public SalesOrderScheduleLineDeleteFluentHelper deleteSalesOrderScheduleLine(
        @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine )
    {
        return new SalesOrderScheduleLineDeleteFluentHelper(
            servicePath,
            salesOrderScheduleLine,
            "A_SalesOrderScheduleLine");
    }

    @Override
    @Nonnull
    public SalesOrderSubsqntProcFlowFluentHelper getAllSalesOrderSubsqntProcFlow()
    {
        return new SalesOrderSubsqntProcFlowFluentHelper(servicePath, "A_SalesOrderSubsqntProcFlow");
    }

    @Override
    @Nonnull
    public
        SalesOrderSubsqntProcFlowByKeyFluentHelper
        getSalesOrderSubsqntProcFlowByKey( final String salesOrder, final UUID docRelationshipUUID )
    {
        return new SalesOrderSubsqntProcFlowByKeyFluentHelper(
            servicePath,
            "A_SalesOrderSubsqntProcFlow",
            salesOrder,
            docRelationshipUUID);
    }

    @Override
    @Nonnull
    public SalesOrderTextFluentHelper getAllSalesOrderText()
    {
        return new SalesOrderTextFluentHelper(servicePath, "A_SalesOrderText");
    }

    @Override
    @Nonnull
    public
        SalesOrderTextByKeyFluentHelper
        getSalesOrderTextByKey( final String salesOrder, final String language, final String longTextID )
    {
        return new SalesOrderTextByKeyFluentHelper(servicePath, "A_SalesOrderText", salesOrder, language, longTextID);
    }

    @Override
    @Nonnull
    public SalesOrderTextCreateFluentHelper createSalesOrderText( @Nonnull final SalesOrderText salesOrderText )
    {
        return new SalesOrderTextCreateFluentHelper(servicePath, salesOrderText, "A_SalesOrderText");
    }

    @Override
    @Nonnull
    public SalesOrderTextUpdateFluentHelper updateSalesOrderText( @Nonnull final SalesOrderText salesOrderText )
    {
        return new SalesOrderTextUpdateFluentHelper(servicePath, salesOrderText, "A_SalesOrderText");
    }

    @Override
    @Nonnull
    public SalesOrderTextDeleteFluentHelper deleteSalesOrderText( @Nonnull final SalesOrderText salesOrderText )
    {
        return new SalesOrderTextDeleteFluentHelper(servicePath, salesOrderText, "A_SalesOrderText");
    }

    @Override
    @Nonnull
    public SlsOrderItemBillingPlanItemFluentHelper getAllSlsOrderItemBillingPlanItem()
    {
        return new SlsOrderItemBillingPlanItemFluentHelper(servicePath, "A_SlsOrderItemBillingPlanItem");
    }

    @Override
    @Nonnull
    public SlsOrderItemBillingPlanItemByKeyFluentHelper getSlsOrderItemBillingPlanItemByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String billingPlan,
        final String billingPlanItem )
    {
        return new SlsOrderItemBillingPlanItemByKeyFluentHelper(
            servicePath,
            "A_SlsOrderItemBillingPlanItem",
            salesOrder,
            salesOrderItem,
            billingPlan,
            billingPlanItem);
    }

    @Override
    @Nonnull
    public SlsOrderItemBillingPlanItemCreateFluentHelper createSlsOrderItemBillingPlanItem(
        @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem )
    {
        return new SlsOrderItemBillingPlanItemCreateFluentHelper(
            servicePath,
            slsOrderItemBillingPlanItem,
            "A_SlsOrderItemBillingPlanItem");
    }

    @Override
    @Nonnull
    public SlsOrderItemBillingPlanItemUpdateFluentHelper updateSlsOrderItemBillingPlanItem(
        @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem )
    {
        return new SlsOrderItemBillingPlanItemUpdateFluentHelper(
            servicePath,
            slsOrderItemBillingPlanItem,
            "A_SlsOrderItemBillingPlanItem");
    }

    @Override
    @Nonnull
    public SlsOrderItemBillingPlanItemDeleteFluentHelper deleteSlsOrderItemBillingPlanItem(
        @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem )
    {
        return new SlsOrderItemBillingPlanItemDeleteFluentHelper(
            servicePath,
            slsOrderItemBillingPlanItem,
            "A_SlsOrderItemBillingPlanItem");
    }

    @Override
    @Nonnull
    public SlsOrdPaymentPlanItemDetailsFluentHelper getAllSlsOrdPaymentPlanItemDetails()
    {
        return new SlsOrdPaymentPlanItemDetailsFluentHelper(servicePath, "A_SlsOrdPaymentPlanItemDetails");
    }

    @Override
    @Nonnull
    public
        SlsOrdPaymentPlanItemDetailsByKeyFluentHelper
        getSlsOrdPaymentPlanItemDetailsByKey( final String salesOrder, final String paymentPlanItem )
    {
        return new SlsOrdPaymentPlanItemDetailsByKeyFluentHelper(
            servicePath,
            "A_SlsOrdPaymentPlanItemDetails",
            salesOrder,
            paymentPlanItem);
    }

    @Override
    @Nonnull
    public SlsOrdPaymentPlanItemDetailsCreateFluentHelper createSlsOrdPaymentPlanItemDetails(
        @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails )
    {
        return new SlsOrdPaymentPlanItemDetailsCreateFluentHelper(
            servicePath,
            slsOrdPaymentPlanItemDetails,
            "A_SlsOrdPaymentPlanItemDetails");
    }

    @Override
    @Nonnull
    public SlsOrdPaymentPlanItemDetailsUpdateFluentHelper updateSlsOrdPaymentPlanItemDetails(
        @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails )
    {
        return new SlsOrdPaymentPlanItemDetailsUpdateFluentHelper(
            servicePath,
            slsOrdPaymentPlanItemDetails,
            "A_SlsOrdPaymentPlanItemDetails");
    }

    @Override
    @Nonnull
    public SlsOrdPaymentPlanItemDetailsDeleteFluentHelper deleteSlsOrdPaymentPlanItemDetails(
        @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails )
    {
        return new SlsOrdPaymentPlanItemDetailsDeleteFluentHelper(
            servicePath,
            slsOrdPaymentPlanItemDetails,
            "A_SlsOrdPaymentPlanItemDetails");
    }

    @Override
    @Nonnull
    public RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String salesOrder )
    {
        return new RejectApprovalRequestFluentHelper(servicePath, salesOrder);
    }

    @Override
    @Nonnull
    public ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String salesOrder )
    {
        return new ReleaseApprovalRequestFluentHelper(servicePath, salesOrder);
    }

}
